/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.webauthn4j.util.AssertUtil;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class AbstractImmutableMap<K extends Serializable, V extends Serializable>
extends AbstractMap<K, V>
implements Serializable {
    private HashMap<K, V> map;
    private transient Set<Map.Entry<K, V>> cachedEntrySet;

    @JsonCreator
    public AbstractImmutableMap(Map<K, V> map) {
        AssertUtil.notNull(map, (String)"map must not be null");
        this.map = new HashMap<K, V>(map);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.cachedEntrySet == null) {
            this.cachedEntrySet = Collections.unmodifiableMap(this.map).entrySet();
        }
        return this.cachedEntrySet;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractImmutableMap that = (AbstractImmutableMap)o;
        return Objects.equals(this.map, that.map);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.map);
    }
}

