/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.exts;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.FastCopyHashMap;
import org.infinispan.commons.util.Util;
import org.infinispan.distribution.util.ReadOnlySegmentAwareCollection;
import org.jboss.marshalling.util.IdentityIntMap;

public class CollectionExternalizer
implements AdvancedExternalizer<Collection> {
    private static final int ARRAY_LIST = 0;
    private static final int LINKED_LIST = 1;
    private static final int SINGLETON_LIST = 2;
    private static final int EMPTY_LIST = 3;
    private static final int HASH_SET = 4;
    private static final int TREE_SET = 5;
    private static final int SINGLETON_SET = 6;
    private static final int SYNCHRONIZED_SET = 7;
    private static final int ARRAY_DEQUE = 8;
    private static final int READ_ONLY_SEGMENT_AWARE_COLLECTION = 9;
    private static final int ENTRY_SET = 10;
    private static final int EMPTY_SET = 11;
    private final IdentityIntMap<Class<?>> numbers = new IdentityIntMap(16);

    public CollectionExternalizer() {
        this.numbers.put(ArrayList.class, 0);
        this.numbers.put(CollectionExternalizer.getPrivateArrayListClass(), 0);
        this.numbers.put(CollectionExternalizer.getPrivateUnmodifiableListClass(), 0);
        this.numbers.put(LinkedList.class, 1);
        this.numbers.put(CollectionExternalizer.getPrivateSingletonListClass(), 2);
        this.numbers.put(CollectionExternalizer.getPrivateEmptyListClass(), 3);
        this.numbers.put(CollectionExternalizer.getPrivateEmptySetClass(), 11);
        this.numbers.put(ArrayDeque.class, 8);
        this.numbers.put(HashSet.class, 4);
        this.numbers.put(TreeSet.class, 5);
        this.numbers.put(CollectionExternalizer.getPrivateSingletonSetClass(), 6);
        this.numbers.put(CollectionExternalizer.getPrivateSynchronizedSetClass(), 7);
        this.numbers.put(CollectionExternalizer.getPrivateUnmodifiableSetClass(), 4);
        this.numbers.put(ReadOnlySegmentAwareCollection.class, 9);
        this.numbers.put(FastCopyHashMap.KeySet.class, 4);
        this.numbers.put(FastCopyHashMap.Values.class, 0);
        this.numbers.put(FastCopyHashMap.EntrySet.class, 10);
    }

    public void writeObject(ObjectOutput output, Collection collection) throws IOException {
        int number = this.numbers.get(collection.getClass(), -1);
        output.writeByte(number);
        switch (number) {
            case 0: 
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                MarshallUtil.marshallCollection((Collection)collection, (ObjectOutput)output);
                break;
            }
            case 2: {
                output.writeObject(((List)collection).get(0));
                break;
            }
            case 6: {
                output.writeObject(collection.iterator().next());
                break;
            }
            case 5: {
                output.writeObject(((TreeSet)collection).comparator());
                MarshallUtil.marshallCollection((Collection)collection, (ObjectOutput)output);
                break;
            }
            case 10: {
                MarshallUtil.marshallCollection((Collection)collection, (ObjectOutput)output, (out, element) -> {
                    Map.Entry entry = (Map.Entry)element;
                    out.writeObject(entry.getKey());
                    out.writeObject(entry.getValue());
                });
            }
        }
    }

    public Collection readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        int magicNumber = input.readUnsignedByte();
        switch (magicNumber) {
            case 0: {
                return MarshallUtil.unmarshallCollection((ObjectInput)input, ArrayList::new);
            }
            case 1: {
                return MarshallUtil.unmarshallCollectionUnbounded((ObjectInput)input, LinkedList::new);
            }
            case 2: {
                return Collections.singletonList(input.readObject());
            }
            case 3: {
                return Collections.emptyList();
            }
            case 4: {
                return MarshallUtil.unmarshallCollection((ObjectInput)input, s -> new HashSet());
            }
            case 5: {
                Comparator comparator = (Comparator)input.readObject();
                return MarshallUtil.unmarshallCollection((ObjectInput)input, s -> new TreeSet(comparator));
            }
            case 6: {
                return Collections.singleton(input.readObject());
            }
            case 7: {
                return Collections.synchronizedSet((Set)MarshallUtil.unmarshallCollection((ObjectInput)input, s -> new HashSet()));
            }
            case 8: {
                return MarshallUtil.unmarshallCollection((ObjectInput)input, ArrayDeque::new);
            }
            case 9: {
                return MarshallUtil.unmarshallCollection((ObjectInput)input, ArrayList::new);
            }
            case 10: {
                return MarshallUtil.unmarshallCollection((ObjectInput)input, s -> new HashSet(), in -> new AbstractMap.SimpleEntry<Object, Object>(in.readObject(), in.readObject()));
            }
            case 11: {
                return Collections.emptySet();
            }
        }
        throw new IllegalStateException("Unknown Set type: " + magicNumber);
    }

    public Integer getId() {
        return 2;
    }

    public Set<Class<? extends Collection>> getTypeClasses() {
        return Util.asSet((Object[])new Class[]{ArrayList.class, LinkedList.class, CollectionExternalizer.getPrivateArrayListClass(), CollectionExternalizer.getPrivateUnmodifiableListClass(), CollectionExternalizer.getPrivateSingletonListClass(), CollectionExternalizer.getPrivateEmptyListClass(), CollectionExternalizer.getPrivateEmptySetClass(), HashSet.class, TreeSet.class, CollectionExternalizer.getPrivateSingletonSetClass(), CollectionExternalizer.getPrivateSynchronizedSetClass(), CollectionExternalizer.getPrivateUnmodifiableSetClass(), ArrayDeque.class, ReadOnlySegmentAwareCollection.class, FastCopyHashMap.KeySet.class, FastCopyHashMap.Values.class, FastCopyHashMap.EntrySet.class});
    }

    private static Class<Collection> getPrivateArrayListClass() {
        return CollectionExternalizer.getCollectionClass("java.util.Arrays$ArrayList");
    }

    private static Class<Collection> getPrivateUnmodifiableListClass() {
        return CollectionExternalizer.getCollectionClass("java.util.Collections$UnmodifiableRandomAccessList");
    }

    private static Class<Collection> getPrivateEmptyListClass() {
        return CollectionExternalizer.getCollectionClass("java.util.Collections$EmptyList");
    }

    private static Class<Collection> getPrivateEmptySetClass() {
        return CollectionExternalizer.getCollectionClass("java.util.Collections$EmptySet");
    }

    private static Class<Collection> getPrivateSingletonListClass() {
        return CollectionExternalizer.getCollectionClass("java.util.Collections$SingletonList");
    }

    public static Class<Collection> getPrivateSingletonSetClass() {
        return CollectionExternalizer.getCollectionClass("java.util.Collections$SingletonSet");
    }

    public static Class<Collection> getPrivateSynchronizedSetClass() {
        return CollectionExternalizer.getCollectionClass("java.util.Collections$SynchronizedSet");
    }

    private static Class<Collection> getPrivateUnmodifiableSetClass() {
        return CollectionExternalizer.getCollectionClass("java.util.Collections$UnmodifiableSet");
    }

    private static Class<Collection> getCollectionClass(String className) {
        return Util.loadClass((String)className, (ClassLoader)Collection.class.getClassLoader());
    }
}

