/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.SiteConfiguration;
import org.infinispan.configuration.global.SiteConfigurationBuilder;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerComponent;
import org.jboss.as.clustering.infinispan.subsystem.GlobalComponentServiceConfigurator;
import org.jboss.as.clustering.infinispan.subsystem.JGroupsTransportResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.jgroups.spi.JGroupsRequirement;
import org.wildfly.clustering.jgroups.spi.RelayConfiguration;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SupplierDependency;

public class SiteServiceConfigurator
extends GlobalComponentServiceConfigurator<SiteConfiguration> {
    private volatile SupplierDependency<ChannelFactory> factory;

    public SiteServiceConfigurator(PathAddress address) {
        super(CacheContainerComponent.SITE, address);
    }

    @Override
    public <T> ServiceBuilder<T> register(ServiceBuilder<T> builder) {
        return super.register(this.factory != null ? this.factory.register(builder) : builder);
    }

    public ServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        String channel = JGroupsTransportResourceDefinition.Attribute.CHANNEL.resolveModelAttribute((ExpressionResolver)context, model).asStringOrNull();
        this.factory = new ServiceSupplierDependency(JGroupsRequirement.CHANNEL_SOURCE.getServiceName(context, channel));
        return this;
    }

    @Override
    public SiteConfiguration get() {
        RelayConfiguration relay;
        SiteConfigurationBuilder builder = new GlobalConfigurationBuilder().site();
        if (this.factory != null && (relay = (RelayConfiguration)((ChannelFactory)this.factory.get()).getProtocolStackConfiguration().getRelay().orElse(null)) != null) {
            builder.localSite(relay.getSiteName());
        }
        return builder.create();
    }
}

