/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.localization;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LocalizationSupport {
    private static LocalizationSupport defaultInstance;
    private static Method withArgsMethod;
    private static Method noArgsMethod;
    private static boolean checked;
    private static Class<?> nbBundle;

    public static String getMessage(Class<?> type, String key, Object ... args) {
        Iterator<LocalizationSupport> it = ServiceLoader.load(LocalizationSupport.class).iterator();
        LocalizationSupport supp = it.hasNext() ? it.next() : LocalizationSupport.getDefault();
        return supp.getMessageSPI(type, key, args);
    }

    protected String getMessageSPI(Class<?> type, String key, Object ... args) {
        String result = LocalizationSupport.getMessageViaNbBundle(type, key, args);
        return result == null ? key : result;
    }

    static LocalizationSupport getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new LocalizationSupport();
        }
        return defaultInstance;
    }

    private static String getMessageViaNbBundle(Class<?> type, String key, Object ... args) {
        block11: {
            if (args.length == 0) {
                Method m = LocalizationSupport.getMessageNoArgs();
                if (m == null) {
                    return null;
                }
                try {
                    return (String)m.invoke(null, type, key);
                }
                catch (IllegalAccessException ex) {
                    Logger.getLogger(LocalizationSupport.class.getName()).log(Level.INFO, key, ex);
                    break block11;
                }
                catch (IllegalArgumentException ex) {
                    Logger.getLogger(LocalizationSupport.class.getName()).log(Level.INFO, key, ex);
                    break block11;
                }
                catch (InvocationTargetException ex) {
                    throw new RuntimeException(ex.getCause());
                }
            }
            Method m = LocalizationSupport.getMessageWithArgs();
            if (m == null) {
                return null;
            }
            try {
                return (String)m.invoke(null, type, key, args);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(LocalizationSupport.class.getName()).log(Level.INFO, key, ex);
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(LocalizationSupport.class.getName()).log(Level.INFO, key, ex);
            }
            catch (InvocationTargetException ex) {
                throw new RuntimeException(ex.getCause());
            }
        }
        return null;
    }

    private static Method getMessageNoArgs() {
        if (noArgsMethod != null) {
            return noArgsMethod;
        }
        Class<?> nbb = LocalizationSupport.nbBundleType();
        if (nbb == null) {
            return null;
        }
        try {
            noArgsMethod = nbb.getMethod("getMessage", Class.class, String.class);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
        catch (SecurityException ex) {
            return null;
        }
        return noArgsMethod;
    }

    private static Method getMessageWithArgs() {
        if (withArgsMethod != null) {
            return withArgsMethod;
        }
        Class<?> nbb = LocalizationSupport.nbBundleType();
        if (nbb == null) {
            return null;
        }
        try {
            withArgsMethod = nbb.getMethod("getMessage", Class.class, String.class, Object[].class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return withArgsMethod;
    }

    static Class<?> nbBundleType() {
        if (nbBundle == null && !checked) {
            checked = true;
            try {
                nbBundle = Class.forName("org.openide.util.NbBundle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return nbBundle;
    }

    static {
        checked = false;
    }
}

