/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.admin.indices.datastream.CreateDataStreamAction;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;

public class RestCreateDataStreamAction
extends BaseRestHandler {
    @Override
    public String getName() {
        return "create_data_stream_action";
    }

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.PUT, "/_data_stream/{name}"));
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        CreateDataStreamAction.Request putDataStreamRequest = new CreateDataStreamAction.Request(request.param("name"));
        request.withContentOrSourceParamParserOrNull(parser -> {
            Map body = parser.map();
            String timeStampFieldName = (String)body.get(DataStream.TIMESTAMP_FIELD_FIELD.getPreferredName());
            if (timeStampFieldName != null) {
                putDataStreamRequest.setTimestampFieldName(timeStampFieldName);
            }
        });
        return channel -> client.admin().indices().createDataStream(putDataStreamRequest, new RestToXContentListener<AcknowledgedResponse>((RestChannel)channel));
    }
}

