/* SPDX-License-Identifier: (LGPL-2.1 OR BSD-2-Clause) */

/* THIS FILE IS AUTOGENERATED BY BPFTOOL! */
#ifndef __SYSCTL_MONITOR_BPF_SKEL_H__
#define __SYSCTL_MONITOR_BPF_SKEL_H__

#include <errno.h>
#include <stdlib.h>
#include <bpf/libbpf.h>

#define BPF_SKEL_SUPPORTS_MAP_AUTO_ATTACH 1

struct sysctl_monitor_bpf {
	struct bpf_object_skeleton *skeleton;
	struct bpf_object *obj;
	struct {
		struct bpf_map *cgroup_map;
		struct bpf_map *written_sysctls;
		struct bpf_map *rodata_str1_1;
	} maps;
	struct {
		struct bpf_program *sysctl_monitor;
	} progs;
	struct {
		struct bpf_link *sysctl_monitor;
	} links;

#ifdef __cplusplus
	static inline struct sysctl_monitor_bpf *open(const struct bpf_object_open_opts *opts = nullptr);
	static inline struct sysctl_monitor_bpf *open_and_load();
	static inline int load(struct sysctl_monitor_bpf *skel);
	static inline int attach(struct sysctl_monitor_bpf *skel);
	static inline void detach(struct sysctl_monitor_bpf *skel);
	static inline void destroy(struct sysctl_monitor_bpf *skel);
	static inline const void *elf_bytes(size_t *sz);
#endif /* __cplusplus */
};

static void
sysctl_monitor_bpf__destroy(struct sysctl_monitor_bpf *obj)
{
	if (!obj)
		return;
	if (obj->skeleton)
		bpf_object__destroy_skeleton(obj->skeleton);
	free(obj);
}

static inline int
sysctl_monitor_bpf__create_skeleton(struct sysctl_monitor_bpf *obj);

static inline struct sysctl_monitor_bpf *
sysctl_monitor_bpf__open_opts(const struct bpf_object_open_opts *opts)
{
	struct sysctl_monitor_bpf *obj;
	int err;

	obj = (struct sysctl_monitor_bpf *)calloc(1, sizeof(*obj));
	if (!obj) {
		errno = ENOMEM;
		return NULL;
	}

	err = sysctl_monitor_bpf__create_skeleton(obj);
	if (err)
		goto err_out;

	err = bpf_object__open_skeleton(obj->skeleton, opts);
	if (err)
		goto err_out;

	return obj;
err_out:
	sysctl_monitor_bpf__destroy(obj);
	errno = -err;
	return NULL;
}

static inline struct sysctl_monitor_bpf *
sysctl_monitor_bpf__open(void)
{
	return sysctl_monitor_bpf__open_opts(NULL);
}

static inline int
sysctl_monitor_bpf__load(struct sysctl_monitor_bpf *obj)
{
	return bpf_object__load_skeleton(obj->skeleton);
}

static inline struct sysctl_monitor_bpf *
sysctl_monitor_bpf__open_and_load(void)
{
	struct sysctl_monitor_bpf *obj;
	int err;

	obj = sysctl_monitor_bpf__open();
	if (!obj)
		return NULL;
	err = sysctl_monitor_bpf__load(obj);
	if (err) {
		sysctl_monitor_bpf__destroy(obj);
		errno = -err;
		return NULL;
	}
	return obj;
}

static inline int
sysctl_monitor_bpf__attach(struct sysctl_monitor_bpf *obj)
{
	return bpf_object__attach_skeleton(obj->skeleton);
}

static inline void
sysctl_monitor_bpf__detach(struct sysctl_monitor_bpf *obj)
{
	bpf_object__detach_skeleton(obj->skeleton);
}

static inline const void *sysctl_monitor_bpf__elf_bytes(size_t *sz);

static inline int
sysctl_monitor_bpf__create_skeleton(struct sysctl_monitor_bpf *obj)
{
	struct bpf_object_skeleton *s;
	struct bpf_map_skeleton *map __attribute__((unused));
	int err;

	s = (struct bpf_object_skeleton *)calloc(1, sizeof(*s));
	if (!s)	{
		err = -ENOMEM;
		goto err;
	}

	s->sz = sizeof(*s);
	s->name = "sysctl_monitor_bpf";
	s->obj = &obj->obj;

	/* maps */
	s->map_cnt = 3;
	s->map_skel_sz = 24;
	s->maps = (struct bpf_map_skeleton *)calloc(s->map_cnt,
			sizeof(*s->maps) > 24 ? sizeof(*s->maps) : 24);
	if (!s->maps) {
		err = -ENOMEM;
		goto err;
	}

	map = (struct bpf_map_skeleton *)((char *)s->maps + 0 * s->map_skel_sz);
	map->name = "cgroup_map";
	map->map = &obj->maps.cgroup_map;

	map = (struct bpf_map_skeleton *)((char *)s->maps + 1 * s->map_skel_sz);
	map->name = "written_sysctls";
	map->map = &obj->maps.written_sysctls;

	map = (struct bpf_map_skeleton *)((char *)s->maps + 2 * s->map_skel_sz);
	map->name = ".rodata.str1.1";
	map->map = &obj->maps.rodata_str1_1;

	/* programs */
	s->prog_cnt = 1;
	s->prog_skel_sz = sizeof(*s->progs);
	s->progs = (struct bpf_prog_skeleton *)calloc(s->prog_cnt, s->prog_skel_sz);
	if (!s->progs) {
		err = -ENOMEM;
		goto err;
	}

	s->progs[0].name = "sysctl_monitor";
	s->progs[0].prog = &obj->progs.sysctl_monitor;
	s->progs[0].link = &obj->links.sysctl_monitor;

	s->data = sysctl_monitor_bpf__elf_bytes(&s->data_sz);

	obj->skeleton = s;
	return 0;
err:
	bpf_object__destroy_skeleton(s);
	return err;
}

static inline const void *sysctl_monitor_bpf__elf_bytes(size_t *sz)
{
	static const char data[] __attribute__((__aligned__(8))) = "\
\x7f\x45\x4c\x46\x02\x01\x01\0\0\0\0\0\0\0\0\0\x01\0\xf7\0\x01\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x88\x0f\0\0\0\0\0\0\0\0\0\0\x40\0\0\0\0\0\x40\0\x0b\0\
\x01\0\0\x2e\x73\x74\x72\x74\x61\x62\0\x2e\x73\x79\x6d\x74\x61\x62\0\x2e\x74\
\x65\x78\x74\0\x63\x67\x72\x6f\x75\x70\x2f\x73\x79\x73\x63\x74\x6c\0\x2e\x6d\
\x61\x70\x73\0\x2e\x72\x6f\x64\x61\x74\x61\x2e\x73\x74\x72\x31\x2e\x31\0\x6c\
\x69\x63\x65\x6e\x73\x65\0\x73\x79\x73\x63\x74\x6c\x2d\x6d\x6f\x6e\x69\x74\x6f\
\x72\x2e\x62\x70\x66\x2e\x63\0\x63\x75\x74\x5f\x6c\x61\x73\x74\0\x73\x79\x73\
\x63\x74\x6c\x5f\x6d\x6f\x6e\x69\x74\x6f\x72\0\x63\x67\x72\x6f\x75\x70\x5f\x6d\
\x61\x70\0\x77\x72\x69\x74\x74\x65\x6e\x5f\x73\x79\x73\x63\x74\x6c\x73\0\x5f\
\x6c\x69\x63\x65\x6e\x73\x65\0\x2e\x72\x65\x6c\x63\x67\x72\x6f\x75\x70\x2f\x73\
\x79\x73\x63\x74\x6c\0\x2e\x42\x54\x46\0\x2e\x42\x54\x46\x2e\x65\x78\x74\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x42\0\0\0\x04\0\xf1\xff\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\x03\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x57\0\0\0\x02\0\x03\
\0\0\0\0\0\0\0\0\0\xa8\0\0\0\0\0\0\0\0\0\0\0\x03\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\x60\0\0\0\x12\0\x04\0\0\0\0\0\0\0\0\0\xa8\x03\0\0\0\0\0\0\x6f\0\0\0\
\x11\0\x05\0\0\0\0\0\0\0\0\0\x20\0\0\0\0\0\0\0\x7a\0\0\0\x11\0\x05\0\x20\0\0\0\
\0\0\0\0\x10\0\0\0\0\0\0\0\x8a\0\0\0\x11\0\x07\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\0\
\0\0\xb7\0\0\0\x01\0\0\0\x79\x23\x08\0\0\0\0\0\x3d\x31\x11\0\0\0\0\0\x79\x22\0\
\0\0\0\0\0\x0f\x32\0\0\0\0\0\0\xa7\x01\0\0\xff\xff\xff\xff\x0f\x12\0\0\0\0\0\0\
\x71\x20\0\0\0\0\0\0\x25\0\x07\0\x20\0\0\0\xb7\x01\0\0\x01\0\0\0\x6f\x01\0\0\0\
\0\0\0\x18\x03\0\0\0\x26\0\0\0\0\0\0\x01\0\0\0\x5f\x31\0\0\0\0\0\0\x55\x01\x03\
\0\0\0\0\0\x15\0\x04\0\0\0\0\0\xb7\0\0\0\x01\0\0\0\x05\0\x02\0\0\0\0\0\xb7\0\0\
\0\0\0\0\0\x73\x02\0\0\0\0\0\0\x95\0\0\0\0\0\0\0\xbf\x16\0\0\0\0\0\0\x61\x61\0\
\0\0\0\0\0\x15\x01\x62\0\0\0\0\0\xb7\x01\0\0\x01\0\0\0\x7b\x1a\x20\xfe\0\0\0\0\
\xb7\x07\0\0\0\0\0\0\x73\x7a\x48\xfe\0\0\0\0\x73\x7a\x4c\xff\0\0\0\0\x73\x7a\
\xac\xfe\0\0\0\0\x73\x7a\x38\xfe\0\0\0\0\x85\0\0\0\x0e\0\0\0\x77\0\0\0\x20\0\0\
\0\x63\x0a\x28\xfe\0\0\0\0\x85\0\0\0\x50\0\0\0\x7b\x0a\x30\xfe\0\0\0\0\x18\x01\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xb7\x02\0\0\0\0\0\0\x85\0\0\0\x25\0\0\0\xbf\x01\0\
\0\0\0\0\0\x67\x01\0\0\x20\0\0\0\xbf\x10\0\0\0\0\0\0\xc7\0\0\0\x20\0\0\0\x6d\
\x07\x45\0\0\0\0\0\x77\x01\0\0\x20\0\0\0\x15\x01\x4b\0\x01\0\0\0\xbf\xa7\0\0\0\
\0\0\0\x07\x07\0\0\x48\xfe\xff\xff\xb7\x08\0\0\0\0\0\0\xbf\x61\0\0\0\0\0\0\xbf\
\x72\0\0\0\0\0\0\xb7\x03\0\0\x64\0\0\0\xb7\x04\0\0\0\0\0\0\x85\0\0\0\x65\0\0\0\
\x67\0\0\0\x20\0\0\0\xc7\0\0\0\x20\0\0\0\x6d\x08\x38\0\0\0\0\0\xbf\x71\0\0\0\0\
\0\0\xb7\x02\0\0\x04\0\0\0\x18\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x85\0\0\0\xb6\0\
\0\0\x55\0\x3a\0\0\0\0\0\xbf\xa1\0\0\0\0\0\0\x07\x01\0\0\x38\xfe\xff\xff\xb7\
\x02\0\0\x10\0\0\0\x85\0\0\0\x10\0\0\0\x67\0\0\0\x20\0\0\0\xc7\0\0\0\x20\0\0\0\
\x6d\x08\x2b\0\0\0\0\0\xbf\xa7\0\0\0\0\0\0\x07\x07\0\0\xac\xfe\xff\xff\xbf\x61\
\0\0\0\0\0\0\xbf\x72\0\0\0\0\0\0\xb7\x03\0\0\xa0\0\0\0\x85\0\0\0\x66\0\0\0\x67\
\0\0\0\x20\0\0\0\xc7\0\0\0\x20\0\0\0\x6d\x08\x22\0\0\0\0\0\xbf\xa8\0\0\0\0\0\0\
\x07\x08\0\0\x4c\xff\xff\xff\xb7\x09\0\0\xa0\0\0\0\xbf\x61\0\0\0\0\0\0\xbf\x82\
\0\0\0\0\0\0\xb7\x03\0\0\xa0\0\0\0\x85\0\0\0\x67\0\0\0\x67\0\0\0\x20\0\0\0\xc7\
\0\0\0\x20\0\0\0\xb7\x01\0\0\0\0\0\0\x6d\x01\x17\0\0\0\0\0\x7b\x7a\xf0\xff\0\0\
\0\0\x7b\x9a\xf8\xff\0\0\0\0\xbf\xa3\0\0\0\0\0\0\x07\x03\0\0\xf0\xff\xff\xff\
\xb7\x06\0\0\0\0\0\0\xb7\x01\0\0\xa0\0\0\0\x18\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\xb7\x04\0\0\0\0\0\0\x85\0\0\0\xb5\0\0\0\x7b\x8a\xf0\xff\0\0\0\0\x7b\x9a\xf8\
\xff\0\0\0\0\xbf\xa3\0\0\0\0\0\0\x07\x03\0\0\xf0\xff\xff\xff\xb7\x01\0\0\xa0\0\
\0\0\x18\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xb7\x04\0\0\0\0\0\0\x85\0\0\0\xb5\0\0\
\0\x71\xa1\xac\xfe\0\0\0\0\x71\xa2\x4c\xff\0\0\0\0\x5d\x21\x02\0\0\0\0\0\x05\0\
\x12\0\0\0\0\0\x63\x0a\x24\xfe\0\0\0\0\xbf\xa2\0\0\0\0\0\0\x07\x02\0\0\x20\xfe\
\xff\xff\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xb7\x03\0\0\xd0\x01\0\0\xb7\x04\0\
\0\0\0\0\0\x85\0\0\0\x82\0\0\0\xb7\0\0\0\x01\0\0\0\x95\0\0\0\0\0\0\0\x15\x06\
\xfd\xff\x9f\0\0\0\xbf\xa2\0\0\0\0\0\0\x07\x02\0\0\x20\xfe\xff\xff\x0f\x62\0\0\
\0\0\0\0\x07\x06\0\0\x01\0\0\0\x71\x21\x8d\0\0\0\0\0\x71\x22\x2d\x01\0\0\0\0\
\x5d\x21\x03\0\0\0\0\0\x57\x01\0\0\xff\0\0\0\x15\x01\xf4\xff\0\0\0\0\x05\0\xf5\
\xff\0\0\0\0\x07\x06\0\0\xff\xff\xff\xff\x25\x06\xf1\xff\x9e\0\0\0\x05\0\xe9\
\xff\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x6e\x65\x74\x2f\0\x47\x50\x4c\0\0\0\0\0\0\0\0\
\x78\0\0\0\0\0\0\0\x01\0\0\0\x07\0\0\0\x38\x01\0\0\0\0\0\0\x01\0\0\0\x05\0\0\0\
\x60\x02\0\0\0\0\0\0\x01\0\0\0\x02\0\0\0\xa8\x02\0\0\0\0\0\0\x01\0\0\0\x02\0\0\
\0\0\x03\0\0\0\0\0\0\x01\0\0\0\x08\0\0\0\x9f\xeb\x01\0\x18\0\0\0\0\0\0\0\x10\
\x03\0\0\x10\x03\0\0\x8e\x01\0\0\0\0\0\0\0\0\0\x02\x03\0\0\0\x01\0\0\0\0\0\0\
\x01\x04\0\0\0\x20\0\0\x01\0\0\0\0\0\0\0\x03\0\0\0\0\x02\0\0\0\x04\0\0\0\x08\0\
\0\0\x05\0\0\0\0\0\0\x01\x04\0\0\0\x20\0\0\0\0\0\0\0\0\0\0\x02\x06\0\0\0\x19\0\
\0\0\0\0\0\x08\x07\0\0\0\x1d\0\0\0\0\0\0\x08\x08\0\0\0\x23\0\0\0\0\0\0\x01\x04\
\0\0\0\x20\0\0\0\0\0\0\0\0\0\0\x02\x0a\0\0\0\0\0\0\0\0\0\0\x03\0\0\0\0\x02\0\0\
\0\x04\0\0\0\x01\0\0\0\0\0\0\0\x04\0\0\x04\x20\0\0\0\x30\0\0\0\x01\0\0\0\0\0\0\
\0\x35\0\0\0\x05\0\0\0\x40\0\0\0\x39\0\0\0\x05\0\0\0\x80\0\0\0\x3f\0\0\0\x09\0\
\0\0\xc0\0\0\0\x4b\0\0\0\0\0\0\x0e\x0b\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\x02\x0e\0\
\0\0\0\0\0\0\0\0\0\x03\0\0\0\0\x02\0\0\0\x04\0\0\0\x1b\0\0\0\0\0\0\0\0\0\0\x02\
\x10\0\0\0\0\0\0\0\0\0\0\x03\0\0\0\0\x02\0\0\0\x04\0\0\0\0\0\x04\0\0\0\0\0\x02\
\0\0\x04\x10\0\0\0\x30\0\0\0\x0d\0\0\0\0\0\0\0\x3f\0\0\0\x0f\0\0\0\x40\0\0\0\
\x56\0\0\0\0\0\0\x0e\x11\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\x02\x14\0\0\0\x66\0\0\0\
\x02\0\0\x04\x08\0\0\0\x71\0\0\0\x07\0\0\0\0\0\0\0\x77\0\0\0\x07\0\0\0\x20\0\0\
\0\0\0\0\0\x01\0\0\x0d\x02\0\0\0\x80\0\0\0\x13\0\0\0\x84\0\0\0\x01\0\0\x0c\x15\
\0\0\0\x93\0\0\0\0\0\0\x08\x18\0\0\0\x97\0\0\0\0\0\0\x08\x19\0\0\0\x9d\0\0\0\0\
\0\0\x01\x08\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\x02\x1b\0\0\0\xb0\0\0\0\x02\0\0\x04\
\x10\0\0\0\xb4\0\0\0\x1c\0\0\0\0\0\0\0\xb6\0\0\0\x1e\0\0\0\x40\0\0\0\0\0\0\0\0\
\0\0\x02\x1d\0\0\0\xb8\0\0\0\0\0\0\x01\x01\0\0\0\x08\0\0\x01\xbd\0\0\0\0\0\0\
\x08\x1f\0\0\0\xc4\0\0\0\0\0\0\x08\x20\0\0\0\xd4\0\0\0\0\0\0\x08\x21\0\0\0\xe5\
\0\0\0\0\0\0\x01\x08\0\0\0\x40\0\0\0\0\0\0\0\x02\0\0\x0d\x23\0\0\0\xf3\0\0\0\
\x17\0\0\0\xb0\0\0\0\x1a\0\0\0\xf5\0\0\0\0\0\0\x01\x08\0\0\0\x40\0\0\x01\xfa\0\
\0\0\0\0\0\x0c\x22\0\0\0\0\0\0\0\0\0\0\x03\0\0\0\0\x1d\0\0\0\x04\0\0\0\x05\0\0\
\0\0\0\0\0\0\0\0\x03\0\0\0\0\x1d\0\0\0\x04\0\0\0\x04\0\0\0\x03\x01\0\0\0\0\0\
\x0e\x26\0\0\0\x01\0\0\0\x6c\x01\0\0\x02\0\0\x0f\x30\0\0\0\x0c\0\0\0\0\0\0\0\
\x20\0\0\0\x12\0\0\0\x20\0\0\0\x10\0\0\0\x72\x01\0\0\x01\0\0\x0f\x04\0\0\0\x27\
\0\0\0\0\0\0\0\x04\0\0\0\0\x69\x6e\x74\0\x5f\x5f\x41\x52\x52\x41\x59\x5f\x53\
\x49\x5a\x45\x5f\x54\x59\x50\x45\x5f\x5f\0\x75\x33\x32\0\x5f\x5f\x75\x33\x32\0\
\x75\x6e\x73\x69\x67\x6e\x65\x64\x20\x69\x6e\x74\0\x74\x79\x70\x65\0\x6b\x65\
\x79\0\x76\x61\x6c\x75\x65\0\x6d\x61\x78\x5f\x65\x6e\x74\x72\x69\x65\x73\0\x63\
\x67\x72\x6f\x75\x70\x5f\x6d\x61\x70\0\x77\x72\x69\x74\x74\x65\x6e\x5f\x73\x79\
\x73\x63\x74\x6c\x73\0\x62\x70\x66\x5f\x73\x79\x73\x63\x74\x6c\0\x77\x72\x69\
\x74\x65\0\x66\x69\x6c\x65\x5f\x70\x6f\x73\0\x63\x74\x78\0\x73\x79\x73\x63\x74\
\x6c\x5f\x6d\x6f\x6e\x69\x74\x6f\x72\0\x75\x36\x34\0\x5f\x5f\x75\x36\x34\0\x75\
\x6e\x73\x69\x67\x6e\x65\x64\x20\x6c\x6f\x6e\x67\x20\x6c\x6f\x6e\x67\0\x73\x74\
\x72\0\x73\0\x6c\0\x63\x68\x61\x72\0\x73\x69\x7a\x65\x5f\x74\0\x5f\x5f\x6b\x65\
\x72\x6e\x65\x6c\x5f\x73\x69\x7a\x65\x5f\x74\0\x5f\x5f\x6b\x65\x72\x6e\x65\x6c\
\x5f\x75\x6c\x6f\x6e\x67\x5f\x74\0\x75\x6e\x73\x69\x67\x6e\x65\x64\x20\x6c\x6f\
\x6e\x67\0\x69\0\x6c\x6f\x6e\x67\0\x63\x75\x74\x5f\x6c\x61\x73\x74\0\x5f\x6c\
\x69\x63\x65\x6e\x73\x65\0\x2f\x75\x73\x72\x2f\x73\x72\x63\x2f\x64\x65\x62\x75\
\x67\x2f\x73\x79\x73\x74\x65\x6d\x64\x2f\x62\x75\x69\x6c\x64\x2f\x2e\x2e\x2f\
\x73\x79\x73\x74\x65\x6d\x64\x2f\x73\x72\x63\x2f\x6e\x65\x74\x77\x6f\x72\x6b\
\x2f\x62\x70\x66\x2f\x73\x79\x73\x63\x74\x6c\x5f\x6d\x6f\x6e\x69\x74\x6f\x72\
\x2f\x73\x79\x73\x63\x74\x6c\x2d\x6d\x6f\x6e\x69\x74\x6f\x72\x2e\x62\x70\x66\
\x2e\x63\0\x30\x3a\x30\0\x2e\x6d\x61\x70\x73\0\x6c\x69\x63\x65\x6e\x73\x65\0\
\x2e\x74\x65\x78\x74\0\x63\x67\x72\x6f\x75\x70\x2f\x73\x79\x73\x63\x74\x6c\0\0\
\0\x9f\xeb\x01\0\x20\0\0\0\0\0\0\0\x24\0\0\0\x24\0\0\0\xa4\x03\0\0\xc8\x03\0\0\
\x1c\0\0\0\x08\0\0\0\x7a\x01\0\0\x01\0\0\0\0\0\0\0\x24\0\0\0\x80\x01\0\0\x01\0\
\0\0\0\0\0\0\x16\0\0\0\x10\0\0\0\x7a\x01\0\0\x0b\0\0\0\0\0\0\0\x0c\x01\0\0\0\0\
\0\0\0\x90\0\0\x08\0\0\0\x0c\x01\0\0\0\0\0\0\x17\xa0\0\0\x10\0\0\0\x0c\x01\0\0\
\0\0\0\0\x0d\xa0\0\0\x18\0\0\0\x0c\x01\0\0\0\0\0\0\x12\xb0\0\0\x20\0\0\0\x0c\
\x01\0\0\0\0\0\0\x14\xb0\0\0\x28\0\0\0\x0c\x01\0\0\0\0\0\0\x18\xac\0\0\x30\0\0\
\0\x0c\x01\0\0\0\0\0\0\x14\xb0\0\0\x38\0\0\0\x0c\x01\0\0\0\0\0\0\x0d\xb8\0\0\
\x40\0\0\0\x0c\x01\0\0\0\0\0\0\x0d\xb8\0\0\x98\0\0\0\x0c\x01\0\0\0\0\0\0\x14\
\xc8\0\0\xa0\0\0\0\x0c\x01\0\0\0\0\0\0\x01\xdc\0\0\x80\x01\0\0\x2e\0\0\0\0\0\0\
\0\x0c\x01\0\0\0\0\0\0\0\x04\x01\0\x08\0\0\0\x0c\x01\0\0\0\0\0\0\x13\x14\x01\0\
\x10\0\0\0\x0c\x01\0\0\0\0\0\0\x0d\x14\x01\0\x20\0\0\0\x0c\x01\0\0\0\0\0\0\x14\
\x34\x01\0\x30\0\0\0\x0c\x01\0\0\0\0\0\0\x14\x3c\x01\0\x38\0\0\0\x0c\x01\0\0\0\
\0\0\0\x18\x48\x01\0\x40\0\0\0\x0c\x01\0\0\0\0\0\0\x17\x44\x01\0\x48\0\0\0\x0c\
\x01\0\0\0\0\0\0\x14\x40\x01\0\x50\0\0\0\x0c\x01\0\0\0\0\0\0\x12\x54\x01\0\x58\
\0\0\0\x0c\x01\0\0\0\0\0\0\x2d\x54\x01\0\x60\0\0\0\x0c\x01\0\0\0\0\0\0\x10\x54\
\x01\0\x68\0\0\0\x0c\x01\0\0\0\0\0\0\x18\x58\x01\0\x70\0\0\0\x0c\x01\0\0\0\0\0\
\0\x16\x58\x01\0\x78\0\0\0\x0c\x01\0\0\0\0\0\0\x0d\x60\x01\0\xb8\0\0\0\x0c\x01\
\0\0\0\0\0\0\x0d\x64\x01\0\xc0\0\0\0\x0c\x01\0\0\0\0\0\0\x0d\x60\x01\0\xc8\0\0\
\0\x0c\x01\0\0\0\0\0\0\x0d\x74\x01\0\xe8\0\0\0\x0c\x01\0\0\0\0\0\0\x0d\x84\x01\
\0\x20\x01\0\0\x0c\x01\0\0\0\0\0\0\x0d\x88\x01\0\x28\x01\0\0\x0c\x01\0\0\0\0\0\
\0\x0d\x9c\x01\0\x50\x01\0\0\x0c\x01\0\0\0\0\0\0\x0d\x9c\x01\0\x68\x01\0\0\x0c\
\x01\0\0\0\0\0\0\x0d\xa8\x01\0\x88\x01\0\0\x0c\x01\0\0\0\0\0\0\x0d\xac\x01\0\
\xa0\x01\0\0\x0c\x01\0\0\0\0\0\0\x0d\xc0\x01\0\xd0\x01\0\0\x0c\x01\0\0\0\0\0\0\
\x0d\xc4\x01\0\xf0\x01\0\0\x0c\x01\0\0\0\0\0\0\x0d\xd8\x01\0\x28\x02\0\0\x0c\
\x01\0\0\0\0\0\0\x0d\xdc\x01\0\x30\x02\0\0\x0c\x01\0\0\0\0\0\0\x1a\xec\0\0\x58\
\x02\0\0\x0c\x01\0\0\0\0\0\0\x09\xf4\0\0\x80\x02\0\0\x0c\x01\0\0\0\0\0\0\x1a\
\xec\0\0\xa0\x02\0\0\x0c\x01\0\0\0\0\0\0\x09\xf4\0\0\xc8\x02\0\0\x0c\x01\0\0\0\
\0\0\0\x15\x5c\0\0\xd0\x02\0\0\x0c\x01\0\0\0\0\0\0\x1e\x5c\0\0\xd8\x02\0\0\x0c\
\x01\0\0\0\0\0\0\x15\x5c\0\0\xe0\x02\0\0\x0c\x01\0\0\0\0\0\0\x09\x58\0\0\0\x03\
\0\0\x0c\x01\0\0\0\0\0\0\x11\x10\x02\0\x28\x03\0\0\x0c\x01\0\0\0\0\0\0\x01\x1c\
\x02\0\x38\x03\0\0\x0c\x01\0\0\0\0\0\0\x09\x58\0\0\x50\x03\0\0\x0c\x01\0\0\0\0\
\0\0\x15\x5c\0\0\x58\x03\0\0\x0c\x01\0\0\0\0\0\0\x24\x58\0\0\x60\x03\0\0\x0c\
\x01\0\0\0\0\0\0\x15\x5c\0\0\x68\x03\0\0\x0c\x01\0\0\0\0\0\0\x1e\x5c\0\0\x70\
\x03\0\0\x0c\x01\0\0\0\0\0\0\x15\x5c\0\0\x78\x03\0\0\x0c\x01\0\0\0\0\0\0\x1b\
\x64\0\0\x80\x03\0\0\x0c\x01\0\0\0\0\0\0\x15\x64\0\0\x98\x03\0\0\x0c\x01\0\0\0\
\0\0\0\x0d\x0c\x02\0\x10\0\0\0\x80\x01\0\0\x01\0\0\0\x08\0\0\0\x14\0\0\0\x68\
\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\
\0\0\0\x03\0\0\0\x20\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x40\0\0\0\0\0\0\0\xb3\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x09\0\0\0\x02\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xf8\0\0\0\0\0\0\0\xf0\0\0\0\0\0\0\0\x01\0\0\0\
\0\0\0\0\x08\0\0\0\0\0\0\0\x18\0\0\0\0\0\0\0\x11\0\0\0\x01\0\0\0\x06\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\xe8\x01\0\0\0\0\0\0\xa8\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x17\0\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\x90\x02\0\0\0\0\0\0\xa8\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\x25\0\0\0\x01\0\0\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x38\
\x06\0\0\0\0\0\0\x30\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\x2b\0\0\0\x01\0\0\0\x32\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x68\x06\0\0\0\0\0\
\0\x05\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\x3a\0\
\0\0\x01\0\0\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x6d\x06\0\0\0\0\0\0\x04\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x93\0\0\0\x09\0\0\0\
\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x78\x06\0\0\0\0\0\0\x50\0\0\0\0\0\0\0\x02\0\
\0\0\x04\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\xa5\0\0\0\x01\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\xc8\x06\0\0\0\0\0\0\xb6\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xaa\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\x80\x0b\0\0\0\0\0\0\x04\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0";

	*sz = sizeof(data) - 1;
	return (const void *)data;
}

#ifdef __cplusplus
struct sysctl_monitor_bpf *sysctl_monitor_bpf::open(const struct bpf_object_open_opts *opts) { return sysctl_monitor_bpf__open_opts(opts); }
struct sysctl_monitor_bpf *sysctl_monitor_bpf::open_and_load() { return sysctl_monitor_bpf__open_and_load(); }
int sysctl_monitor_bpf::load(struct sysctl_monitor_bpf *skel) { return sysctl_monitor_bpf__load(skel); }
int sysctl_monitor_bpf::attach(struct sysctl_monitor_bpf *skel) { return sysctl_monitor_bpf__attach(skel); }
void sysctl_monitor_bpf::detach(struct sysctl_monitor_bpf *skel) { sysctl_monitor_bpf__detach(skel); }
void sysctl_monitor_bpf::destroy(struct sysctl_monitor_bpf *skel) { sysctl_monitor_bpf__destroy(skel); }
const void *sysctl_monitor_bpf::elf_bytes(size_t *sz) { return sysctl_monitor_bpf__elf_bytes(sz); }
#endif /* __cplusplus */

__attribute__((unused)) static void
sysctl_monitor_bpf__assert(struct sysctl_monitor_bpf *s __attribute__((unused)))
{
#ifdef __cplusplus
#define _Static_assert static_assert
#endif
#ifdef __cplusplus
#undef _Static_assert
#endif
}

#endif /* __SYSCTL_MONITOR_BPF_SKEL_H__ */
