/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.11.1
 *
 * Copyright (c) 2024 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt5.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtNetwork.h"

#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtNetwork/qhostinfo.sip"
#include <qhostinfo.h>
#line 29 "/build/pyqt5/src/PyQt5-5.15.11/build/QtNetwork/sipQtNetworkQHostInfo.cpp"

#line 27 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qstring.sip"
#include <qstring.h>
#line 33 "/build/pyqt5/src/PyQt5-5.15.11/build/QtNetwork/sipQtNetworkQHostInfo.cpp"
#line 38 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 36 "/build/pyqt5/src/PyQt5-5.15.11/build/QtNetwork/sipQtNetworkQHostInfo.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtNetwork/qhostaddress.sip"
#include <qhostaddress.h>
#line 39 "/build/pyqt5/src/PyQt5-5.15.11/build/QtNetwork/sipQtNetworkQHostInfo.cpp"


PyDoc_STRVAR(doc_QHostInfo_hostName, "hostName(self) -> str");

extern "C" {static PyObject *meth_QHostInfo_hostName(PyObject *, PyObject *);}
static PyObject *meth_QHostInfo_hostName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QHostInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QHostInfo, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->hostName());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QHostInfo, sipName_hostName, doc_QHostInfo_hostName);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QHostInfo_setHostName, "setHostName(self, name: Optional[str])");

extern "C" {static PyObject *meth_QHostInfo_setHostName(PyObject *, PyObject *);}
static PyObject *meth_QHostInfo_setHostName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        ::QHostInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QHostInfo, &sipCpp, sipType_QString, &a0, &a0State))
        {
            sipCpp->setHostName(*a0);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QHostInfo, sipName_setHostName, doc_QHostInfo_setHostName);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QHostInfo_addresses, "addresses(self) -> list[QHostAddress]");

extern "C" {static PyObject *meth_QHostInfo_addresses(PyObject *, PyObject *);}
static PyObject *meth_QHostInfo_addresses(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QHostInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QHostInfo, &sipCpp))
        {
            QList< ::QHostAddress>*sipRes;

            sipRes = new QList< ::QHostAddress>(sipCpp->addresses());

            return sipConvertFromNewType(sipRes, sipType_QList_0100QHostAddress, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QHostInfo, sipName_addresses, doc_QHostInfo_addresses);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QHostInfo_setAddresses, "setAddresses(self, addresses: Iterable[Union[QHostAddress, QHostAddress.SpecialAddress]])");

extern "C" {static PyObject *meth_QHostInfo_setAddresses(PyObject *, PyObject *);}
static PyObject *meth_QHostInfo_setAddresses(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const QList< ::QHostAddress>* a0;
        int a0State = 0;
        ::QHostInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QHostInfo, &sipCpp, sipType_QList_0100QHostAddress, &a0, &a0State))
        {
            sipCpp->setAddresses(*a0);
            sipReleaseType(const_cast<QList< ::QHostAddress> *>(a0), sipType_QList_0100QHostAddress, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QHostInfo, sipName_setAddresses, doc_QHostInfo_setAddresses);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QHostInfo_error, "error(self) -> QHostInfo.HostInfoError");

extern "C" {static PyObject *meth_QHostInfo_error(PyObject *, PyObject *);}
static PyObject *meth_QHostInfo_error(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QHostInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QHostInfo, &sipCpp))
        {
            ::QHostInfo::HostInfoError sipRes;

            sipRes = sipCpp->error();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QHostInfo_HostInfoError);
        }
    }

    sipNoMethod(sipParseErr, sipName_QHostInfo, sipName_error, doc_QHostInfo_error);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QHostInfo_setError, "setError(self, error: QHostInfo.HostInfoError)");

extern "C" {static PyObject *meth_QHostInfo_setError(PyObject *, PyObject *);}
static PyObject *meth_QHostInfo_setError(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QHostInfo::HostInfoError a0;
        ::QHostInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BE", &sipSelf, sipType_QHostInfo, &sipCpp, sipType_QHostInfo_HostInfoError, &a0))
        {
            sipCpp->setError(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QHostInfo, sipName_setError, doc_QHostInfo_setError);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QHostInfo_errorString, "errorString(self) -> str");

extern "C" {static PyObject *meth_QHostInfo_errorString(PyObject *, PyObject *);}
static PyObject *meth_QHostInfo_errorString(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QHostInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QHostInfo, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->errorString());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QHostInfo, sipName_errorString, doc_QHostInfo_errorString);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QHostInfo_setErrorString, "setErrorString(self, errorString: Optional[str])");

extern "C" {static PyObject *meth_QHostInfo_setErrorString(PyObject *, PyObject *);}
static PyObject *meth_QHostInfo_setErrorString(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        ::QHostInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QHostInfo, &sipCpp, sipType_QString, &a0, &a0State))
        {
            sipCpp->setErrorString(*a0);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QHostInfo, sipName_setErrorString, doc_QHostInfo_setErrorString);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QHostInfo_setLookupId, "setLookupId(self, id: int)");

extern "C" {static PyObject *meth_QHostInfo_setLookupId(PyObject *, PyObject *);}
static PyObject *meth_QHostInfo_setLookupId(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        ::QHostInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QHostInfo, &sipCpp, &a0))
        {
            sipCpp->setLookupId(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QHostInfo, sipName_setLookupId, doc_QHostInfo_setLookupId);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QHostInfo_lookupId, "lookupId(self) -> int");

extern "C" {static PyObject *meth_QHostInfo_lookupId(PyObject *, PyObject *);}
static PyObject *meth_QHostInfo_lookupId(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QHostInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QHostInfo, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->lookupId();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QHostInfo, sipName_lookupId, doc_QHostInfo_lookupId);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QHostInfo_lookupHost, "lookupHost(name: Optional[str], slot: PYQT_SLOT) -> int");

extern "C" {static PyObject *meth_QHostInfo_lookupHost(PyObject *, PyObject *);}
static PyObject *meth_QHostInfo_lookupHost(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        PyObject * a1;

        if (sipParseArgs(&sipParseErr, sipArgs, "J1P0", sipType_QString, &a0, &a0State, &a1))
        {
            int sipRes = 0;
            sipErrorState sipError = sipErrorNone;

#line 52 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtNetwork/qhostinfo.sip"
        QObject *receiver;
        QByteArray slot_signature;
        
        if ((sipError = pyqt5_qtnetwork_get_connection_parts(a1, 0, "(QHostInfo)", true, &receiver, slot_signature)) == sipErrorNone)
        {
            QHostInfo::lookupHost(*a0, receiver, slot_signature.constData());
        }
        else if (sipError == sipErrorContinue)
        {
            sipError = sipBadCallableArg(1, a1);
        }
#line 337 "/build/pyqt5/src/PyQt5-5.15.11/build/QtNetwork/sipQtNetworkQHostInfo.cpp"
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            if (sipError == sipErrorFail)
                return 0;

            if (sipError == sipErrorNone)
            {
            return PyLong_FromLong(sipRes);
            }

            sipAddException(sipError, &sipParseErr);
        }
    }

    sipNoMethod(sipParseErr, sipName_QHostInfo, sipName_lookupHost, doc_QHostInfo_lookupHost);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QHostInfo_abortHostLookup, "abortHostLookup(lookupId: int)");

extern "C" {static PyObject *meth_QHostInfo_abortHostLookup(PyObject *, PyObject *);}
static PyObject *meth_QHostInfo_abortHostLookup(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;

        if (sipParseArgs(&sipParseErr, sipArgs, "i", &a0))
        {
            ::QHostInfo::abortHostLookup(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QHostInfo, sipName_abortHostLookup, doc_QHostInfo_abortHostLookup);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QHostInfo_fromName, "fromName(name: Optional[str]) -> QHostInfo");

extern "C" {static PyObject *meth_QHostInfo_fromName(PyObject *, PyObject *);}
static PyObject *meth_QHostInfo_fromName(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArgs, "J1", sipType_QString, &a0, &a0State))
        {
            ::QHostInfo*sipRes;

            sipRes = new ::QHostInfo(::QHostInfo::fromName(*a0));
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return sipConvertFromNewType(sipRes, sipType_QHostInfo, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QHostInfo, sipName_fromName, doc_QHostInfo_fromName);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QHostInfo_localHostName, "localHostName() -> str");

extern "C" {static PyObject *meth_QHostInfo_localHostName(PyObject *, PyObject *);}
static PyObject *meth_QHostInfo_localHostName(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            ::QString*sipRes;

            sipRes = new ::QString(::QHostInfo::localHostName());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QHostInfo, sipName_localHostName, doc_QHostInfo_localHostName);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QHostInfo_localDomainName, "localDomainName() -> str");

extern "C" {static PyObject *meth_QHostInfo_localDomainName(PyObject *, PyObject *);}
static PyObject *meth_QHostInfo_localDomainName(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            ::QString*sipRes;

            sipRes = new ::QString(::QHostInfo::localDomainName());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QHostInfo, sipName_localDomainName, doc_QHostInfo_localDomainName);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QHostInfo_swap, "swap(self, other: QHostInfo)");

extern "C" {static PyObject *meth_QHostInfo_swap(PyObject *, PyObject *);}
static PyObject *meth_QHostInfo_swap(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QHostInfo* a0;
        ::QHostInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QHostInfo, &sipCpp, sipType_QHostInfo, &a0))
        {
            sipCpp->swap(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QHostInfo, sipName_swap, doc_QHostInfo_swap);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_QHostInfo(void *, int);}
static void release_QHostInfo(void *sipCppV, int)
{
    delete reinterpret_cast< ::QHostInfo *>(sipCppV);
}


extern "C" {static void *array_QHostInfo(Py_ssize_t);}
static void *array_QHostInfo(Py_ssize_t sipNrElem)
{
    return new ::QHostInfo[sipNrElem];
}


extern "C" {static void array_delete_QHostInfo(void *);}
static void array_delete_QHostInfo(void *sipCpp)
{
    delete[] reinterpret_cast< ::QHostInfo *>(sipCpp);
}


extern "C" {static void assign_QHostInfo(void *, Py_ssize_t, void *);}
static void assign_QHostInfo(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QHostInfo *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QHostInfo *>(sipSrc);
}


extern "C" {static void *copy_QHostInfo(const void *, Py_ssize_t);}
static void *copy_QHostInfo(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QHostInfo(reinterpret_cast<const ::QHostInfo *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QHostInfo(sipSimpleWrapper *);}
static void dealloc_QHostInfo(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QHostInfo(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QHostInfo(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QHostInfo(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QHostInfo *sipCpp = SIP_NULLPTR;

    {
        int a0 = -1;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|i", &a0))
        {
            sipCpp = new ::QHostInfo(a0);

            return sipCpp;
        }
    }

    {
        const ::QHostInfo* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QHostInfo, &a0))
        {
            sipCpp = new ::QHostInfo(*a0);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_QHostInfo[] = {
    {sipName_abortHostLookup, meth_QHostInfo_abortHostLookup, METH_VARARGS, doc_QHostInfo_abortHostLookup},
    {sipName_addresses, meth_QHostInfo_addresses, METH_VARARGS, doc_QHostInfo_addresses},
    {sipName_error, meth_QHostInfo_error, METH_VARARGS, doc_QHostInfo_error},
    {sipName_errorString, meth_QHostInfo_errorString, METH_VARARGS, doc_QHostInfo_errorString},
    {sipName_fromName, meth_QHostInfo_fromName, METH_VARARGS, doc_QHostInfo_fromName},
    {sipName_hostName, meth_QHostInfo_hostName, METH_VARARGS, doc_QHostInfo_hostName},
    {sipName_localDomainName, meth_QHostInfo_localDomainName, METH_VARARGS, doc_QHostInfo_localDomainName},
    {sipName_localHostName, meth_QHostInfo_localHostName, METH_VARARGS, doc_QHostInfo_localHostName},
    {sipName_lookupHost, meth_QHostInfo_lookupHost, METH_VARARGS, doc_QHostInfo_lookupHost},
    {sipName_lookupId, meth_QHostInfo_lookupId, METH_VARARGS, doc_QHostInfo_lookupId},
    {sipName_setAddresses, meth_QHostInfo_setAddresses, METH_VARARGS, doc_QHostInfo_setAddresses},
    {sipName_setError, meth_QHostInfo_setError, METH_VARARGS, doc_QHostInfo_setError},
    {sipName_setErrorString, meth_QHostInfo_setErrorString, METH_VARARGS, doc_QHostInfo_setErrorString},
    {sipName_setHostName, meth_QHostInfo_setHostName, METH_VARARGS, doc_QHostInfo_setHostName},
    {sipName_setLookupId, meth_QHostInfo_setLookupId, METH_VARARGS, doc_QHostInfo_setLookupId},
    {sipName_swap, meth_QHostInfo_swap, METH_VARARGS, doc_QHostInfo_swap}
};

static sipEnumMemberDef enummembers_QHostInfo[] = {
    {sipName_HostNotFound, static_cast<int>(::QHostInfo::HostNotFound), 26},
    {sipName_NoError, static_cast<int>(::QHostInfo::NoError), 26},
    {sipName_UnknownError, static_cast<int>(::QHostInfo::UnknownError), 26},
};

PyDoc_STRVAR(doc_QHostInfo, "\1QHostInfo(id: int = -1)\n"
"QHostInfo(d: QHostInfo)");


static pyqt5ClassPluginDef plugin_QHostInfo = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef_QtNetwork_QHostInfo = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QHostInfo,
        SIP_NULLPTR,
        &plugin_QHostInfo,
    },
    {
        sipNameNr_QHostInfo,
        {0, 0, 1},
        16, methods_QHostInfo,
        3, enummembers_QHostInfo,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QHostInfo,
    -1,
    sipNameNr_sip_simplewrapper,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_QHostInfo,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QHostInfo,
    assign_QHostInfo,
    array_QHostInfo,
    copy_QHostInfo,
    release_QHostInfo,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QHostInfo,
    sizeof (::QHostInfo),
};
