/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.11.1
 *
 * Copyright (c) 2024 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt5.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtCore.h"

#line 169 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qitemselectionmodel.sip"
#include <qitemselectionmodel.h>
#line 29 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQItemSelection.cpp"

#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qabstractitemmodel.sip"
#include <qabstractitemmodel.h>
#line 33 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQItemSelection.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qitemselectionmodel.sip"
#include <qitemselectionmodel.h>
#line 36 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQItemSelection.cpp"
#line 67 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qitemselectionmodel.sip"
#include <qitemselectionmodel.h>
#line 39 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQItemSelection.cpp"
#line 38 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 42 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQItemSelection.cpp"


PyDoc_STRVAR(doc_QItemSelection_select, "select(self, topLeft: QModelIndex, bottomRight: QModelIndex)");

extern "C" {static PyObject *meth_QItemSelection_select(PyObject *, PyObject *);}
static PyObject *meth_QItemSelection_select(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QModelIndex* a0;
        const ::QModelIndex* a1;
        ::QItemSelection *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9J9", &sipSelf, sipType_QItemSelection, &sipCpp, sipType_QModelIndex, &a0, sipType_QModelIndex, &a1))
        {
            sipCpp->select(*a0, *a1);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QItemSelection, sipName_select, doc_QItemSelection_select);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QItemSelection_contains, "contains(self, index: QModelIndex) -> bool");

extern "C" {static PyObject *meth_QItemSelection_contains(PyObject *, PyObject *);}
static PyObject *meth_QItemSelection_contains(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QModelIndex* a0;
        const ::QItemSelection *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QItemSelection, &sipCpp, sipType_QModelIndex, &a0))
        {
            bool sipRes;

            sipRes = sipCpp->contains(*a0);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QItemSelection, sipName_contains, doc_QItemSelection_contains);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QItemSelection_indexes, "indexes(self) -> list[QModelIndex]");

extern "C" {static PyObject *meth_QItemSelection_indexes(PyObject *, PyObject *);}
static PyObject *meth_QItemSelection_indexes(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QItemSelection *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QItemSelection, &sipCpp))
        {
            ::QModelIndexList*sipRes;

            sipRes = new ::QModelIndexList(sipCpp->indexes());

            return sipConvertFromNewType(sipRes, sipType_QList_0100QModelIndex, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QItemSelection, sipName_indexes, doc_QItemSelection_indexes);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QItemSelection_merge, "merge(self, other: QItemSelection, command: Union[QItemSelectionModel.SelectionFlags, QItemSelectionModel.SelectionFlag])");

extern "C" {static PyObject *meth_QItemSelection_merge(PyObject *, PyObject *);}
static PyObject *meth_QItemSelection_merge(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QItemSelection* a0;
        ::QItemSelectionModel::SelectionFlags* a1;
        int a1State = 0;
        ::QItemSelection *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9J1", &sipSelf, sipType_QItemSelection, &sipCpp, sipType_QItemSelection, &a0, sipType_QItemSelectionModel_SelectionFlags, &a1, &a1State))
        {
            sipCpp->merge(*a0, *a1);
            sipReleaseType(a1, sipType_QItemSelectionModel_SelectionFlags, a1State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QItemSelection, sipName_merge, doc_QItemSelection_merge);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QItemSelection_split, "split(range: QItemSelectionRange, other: QItemSelectionRange, result: Optional[QItemSelection])");

extern "C" {static PyObject *meth_QItemSelection_split(PyObject *, PyObject *);}
static PyObject *meth_QItemSelection_split(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QItemSelectionRange* a0;
        const ::QItemSelectionRange* a1;
        ::QItemSelection* a2;

        if (sipParseArgs(&sipParseErr, sipArgs, "J9J9J8", sipType_QItemSelectionRange, &a0, sipType_QItemSelectionRange, &a1, sipType_QItemSelection, &a2))
        {
            ::QItemSelection::split(*a0, *a1, a2);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QItemSelection, sipName_split, doc_QItemSelection_split);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QItemSelection_clear, "clear(self)");

extern "C" {static PyObject *meth_QItemSelection_clear(PyObject *, PyObject *);}
static PyObject *meth_QItemSelection_clear(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QItemSelection *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QItemSelection, &sipCpp))
        {
            sipCpp->clear();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QItemSelection, sipName_clear, doc_QItemSelection_clear);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QItemSelection_isEmpty, "isEmpty(self) -> bool");

extern "C" {static PyObject *meth_QItemSelection_isEmpty(PyObject *, PyObject *);}
static PyObject *meth_QItemSelection_isEmpty(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QItemSelection *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QItemSelection, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isEmpty();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QItemSelection, sipName_isEmpty, doc_QItemSelection_isEmpty);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QItemSelection_append, "append(self, range: QItemSelectionRange)");

extern "C" {static PyObject *meth_QItemSelection_append(PyObject *, PyObject *);}
static PyObject *meth_QItemSelection_append(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QItemSelectionRange* a0;
        ::QItemSelection *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QItemSelection, &sipCpp, sipType_QItemSelectionRange, &a0))
        {
            sipCpp->append(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QItemSelection, sipName_append, doc_QItemSelection_append);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QItemSelection_prepend, "prepend(self, range: QItemSelectionRange)");

extern "C" {static PyObject *meth_QItemSelection_prepend(PyObject *, PyObject *);}
static PyObject *meth_QItemSelection_prepend(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QItemSelectionRange* a0;
        ::QItemSelection *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QItemSelection, &sipCpp, sipType_QItemSelectionRange, &a0))
        {
            sipCpp->prepend(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QItemSelection, sipName_prepend, doc_QItemSelection_prepend);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QItemSelection_insert, "insert(self, i: int, range: QItemSelectionRange)");

extern "C" {static PyObject *meth_QItemSelection_insert(PyObject *, PyObject *);}
static PyObject *meth_QItemSelection_insert(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const ::QItemSelectionRange* a1;
        ::QItemSelection *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BiJ9", &sipSelf, sipType_QItemSelection, &sipCpp, &a0, sipType_QItemSelectionRange, &a1))
        {
            sipCpp->insert(a0, *a1);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QItemSelection, sipName_insert, doc_QItemSelection_insert);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QItemSelection_replace, "replace(self, i: int, range: QItemSelectionRange)");

extern "C" {static PyObject *meth_QItemSelection_replace(PyObject *, PyObject *);}
static PyObject *meth_QItemSelection_replace(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const ::QItemSelectionRange* a1;
        ::QItemSelection *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BiJ9", &sipSelf, sipType_QItemSelection, &sipCpp, &a0, sipType_QItemSelectionRange, &a1))
        {
            sipCpp->replace(a0, *a1);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QItemSelection, sipName_replace, doc_QItemSelection_replace);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QItemSelection_removeAt, "removeAt(self, i: int)");

extern "C" {static PyObject *meth_QItemSelection_removeAt(PyObject *, PyObject *);}
static PyObject *meth_QItemSelection_removeAt(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        ::QItemSelection *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QItemSelection, &sipCpp, &a0))
        {
            sipCpp->removeAt(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QItemSelection, sipName_removeAt, doc_QItemSelection_removeAt);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QItemSelection_removeAll, "removeAll(self, range: QItemSelectionRange) -> int");

extern "C" {static PyObject *meth_QItemSelection_removeAll(PyObject *, PyObject *);}
static PyObject *meth_QItemSelection_removeAll(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QItemSelectionRange* a0;
        ::QItemSelection *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QItemSelection, &sipCpp, sipType_QItemSelectionRange, &a0))
        {
            int sipRes;

            sipRes = sipCpp->removeAll(*a0);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QItemSelection, sipName_removeAll, doc_QItemSelection_removeAll);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QItemSelection_takeAt, "takeAt(self, i: int) -> QItemSelectionRange");

extern "C" {static PyObject *meth_QItemSelection_takeAt(PyObject *, PyObject *);}
static PyObject *meth_QItemSelection_takeAt(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        ::QItemSelection *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QItemSelection, &sipCpp, &a0))
        {
            ::QItemSelectionRange*sipRes;

            sipRes = new ::QItemSelectionRange(sipCpp->takeAt(a0));

            return sipConvertFromNewType(sipRes, sipType_QItemSelectionRange, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QItemSelection, sipName_takeAt, doc_QItemSelection_takeAt);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QItemSelection_takeFirst, "takeFirst(self) -> QItemSelectionRange");

extern "C" {static PyObject *meth_QItemSelection_takeFirst(PyObject *, PyObject *);}
static PyObject *meth_QItemSelection_takeFirst(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QItemSelection *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QItemSelection, &sipCpp))
        {
            ::QItemSelectionRange*sipRes;

            sipRes = new ::QItemSelectionRange(sipCpp->takeFirst());

            return sipConvertFromNewType(sipRes, sipType_QItemSelectionRange, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QItemSelection, sipName_takeFirst, doc_QItemSelection_takeFirst);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QItemSelection_takeLast, "takeLast(self) -> QItemSelectionRange");

extern "C" {static PyObject *meth_QItemSelection_takeLast(PyObject *, PyObject *);}
static PyObject *meth_QItemSelection_takeLast(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QItemSelection *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QItemSelection, &sipCpp))
        {
            ::QItemSelectionRange*sipRes;

            sipRes = new ::QItemSelectionRange(sipCpp->takeLast());

            return sipConvertFromNewType(sipRes, sipType_QItemSelectionRange, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QItemSelection, sipName_takeLast, doc_QItemSelection_takeLast);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QItemSelection_move, "move(self, from_: int, to: int)");

extern "C" {static PyObject *meth_QItemSelection_move(PyObject *, PyObject *);}
static PyObject *meth_QItemSelection_move(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        int a1;
        ::QItemSelection *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bii", &sipSelf, sipType_QItemSelection, &sipCpp, &a0, &a1))
        {
            sipCpp->move(a0, a1);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QItemSelection, sipName_move, doc_QItemSelection_move);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QItemSelection_swap, "swap(self, i: int, j: int)");

extern "C" {static PyObject *meth_QItemSelection_swap(PyObject *, PyObject *);}
static PyObject *meth_QItemSelection_swap(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        int a1;
        ::QItemSelection *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bii", &sipSelf, sipType_QItemSelection, &sipCpp, &a0, &a1))
        {
            sipCpp->swap(a0, a1);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QItemSelection, sipName_swap, doc_QItemSelection_swap);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QItemSelection_count, "count(self, range: QItemSelectionRange) -> int\n"
"count(self) -> int");

extern "C" {static PyObject *meth_QItemSelection_count(PyObject *, PyObject *);}
static PyObject *meth_QItemSelection_count(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QItemSelectionRange* a0;
        const ::QItemSelection *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QItemSelection, &sipCpp, sipType_QItemSelectionRange, &a0))
        {
            int sipRes;

            sipRes = sipCpp->count(*a0);

            return PyLong_FromLong(sipRes);
        }
    }

    {
        const ::QItemSelection *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QItemSelection, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->count();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QItemSelection, sipName_count, doc_QItemSelection_count);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QItemSelection_first, "first(self) -> QItemSelectionRange");

extern "C" {static PyObject *meth_QItemSelection_first(PyObject *, PyObject *);}
static PyObject *meth_QItemSelection_first(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QItemSelection *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QItemSelection, &sipCpp))
        {
            ::QItemSelectionRange*sipRes;

            sipRes = &sipCpp->first();

            return sipConvertFromType(sipRes, sipType_QItemSelectionRange, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QItemSelection, sipName_first, doc_QItemSelection_first);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QItemSelection_last, "last(self) -> QItemSelectionRange");

extern "C" {static PyObject *meth_QItemSelection_last(PyObject *, PyObject *);}
static PyObject *meth_QItemSelection_last(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QItemSelection *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QItemSelection, &sipCpp))
        {
            ::QItemSelectionRange*sipRes;

            sipRes = &sipCpp->last();

            return sipConvertFromType(sipRes, sipType_QItemSelectionRange, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QItemSelection, sipName_last, doc_QItemSelection_last);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QItemSelection_indexOf, "indexOf(self, value: QItemSelectionRange, from_: int = 0) -> int");

extern "C" {static PyObject *meth_QItemSelection_indexOf(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QItemSelection_indexOf(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QItemSelectionRange* a0;
        int a1 = 0;
        const ::QItemSelection *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_from,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9|i", &sipSelf, sipType_QItemSelection, &sipCpp, sipType_QItemSelectionRange, &a0, &a1))
        {
            int sipRes;

            sipRes = sipCpp->indexOf(*a0, a1);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QItemSelection, sipName_indexOf, doc_QItemSelection_indexOf);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QItemSelection_lastIndexOf, "lastIndexOf(self, value: QItemSelectionRange, from_: int = -1) -> int");

extern "C" {static PyObject *meth_QItemSelection_lastIndexOf(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QItemSelection_lastIndexOf(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QItemSelectionRange* a0;
        int a1 = -1;
        const ::QItemSelection *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_from,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9|i", &sipSelf, sipType_QItemSelection, &sipCpp, sipType_QItemSelectionRange, &a0, &a1))
        {
            int sipRes;

            sipRes = sipCpp->lastIndexOf(*a0, a1);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QItemSelection, sipName_lastIndexOf, doc_QItemSelection_lastIndexOf);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_QItemSelection___iadd__(PyObject *, PyObject *);}
static PyObject *slot_QItemSelection___iadd__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QItemSelection *sipCpp = reinterpret_cast< ::QItemSelection *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QItemSelection));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QItemSelection* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QItemSelection, &a0))
        {
            sipCpp->::QItemSelection::operator+=(*a0);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    {
        const ::QItemSelectionRange* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QItemSelectionRange, &a0))
        {
            sipCpp->::QItemSelection::operator+=(*a0);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    /* Raise an exception if the argument couldn't be parsed. */
    sipBadOperatorArg(sipSelf, sipArg, iconcat_slot);

    return SIP_NULLPTR;
}


extern "C" {static Py_ssize_t slot_QItemSelection___len__(PyObject *);}
static Py_ssize_t slot_QItemSelection___len__(PyObject *sipSelf)
{
    ::QItemSelection *sipCpp = reinterpret_cast< ::QItemSelection *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QItemSelection));

    if (!sipCpp)
        return 0;


    {
        {
            Py_ssize_t sipRes = 0;

#line 1 "Auto-generated"
            sipRes = (Py_ssize_t)sipCpp->count();
#line 739 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQItemSelection.cpp"

            return sipRes;
        }
    }

    return 0;
}


extern "C" {static PyObject *slot_QItemSelection___eq__(PyObject *, PyObject *);}
static PyObject *slot_QItemSelection___eq__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QItemSelection *sipCpp = reinterpret_cast< ::QItemSelection *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QItemSelection));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QItemSelection* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QItemSelection, &a0))
        {
            bool sipRes;

            sipRes = sipCpp->::QItemSelection::operator==(*a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtCore, eq_slot, sipType_QItemSelection, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QItemSelection___ne__(PyObject *, PyObject *);}
static PyObject *slot_QItemSelection___ne__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QItemSelection *sipCpp = reinterpret_cast< ::QItemSelection *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QItemSelection));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QItemSelection* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QItemSelection, &a0))
        {
            bool sipRes;

            sipRes = sipCpp->::QItemSelection::operator!=(*a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtCore, ne_slot, sipType_QItemSelection, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QItemSelection___getitem__(PyObject *, PyObject *);}
static PyObject *slot_QItemSelection___getitem__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QItemSelection *sipCpp = reinterpret_cast< ::QItemSelection *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QItemSelection));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1i", &a0))
        {
            ::QItemSelectionRange*sipRes = 0;
            int sipIsErr = 0;

#line 257 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qitemselectionmodel.sip"
        Py_ssize_t idx = sipConvertFromSequenceIndex(a0, sipCpp->count());
        
        if (idx < 0)
            sipIsErr = 1;
        else
            sipRes = new QItemSelectionRange(sipCpp->operator[]((int)idx));
#line 832 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQItemSelection.cpp"

            if (sipIsErr)
                return 0;

            return sipConvertFromNewType(sipRes, sipType_QItemSelectionRange, SIP_NULLPTR);
        }
    }

    {
        PyObject * a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1T", &PySlice_Type, &a0))
        {
            ::QItemSelection*sipRes = 0;
            int sipIsErr = 0;

#line 267 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qitemselectionmodel.sip"
        Py_ssize_t start, stop, step, slicelength;
        
        if (sipConvertFromSliceObject(a0, sipCpp->count(), &start, &stop, &step, &slicelength) < 0)
        {
            sipIsErr = 1;
        }
        else
        {
            sipRes = new QItemSelection();
        
            for (Py_ssize_t i = 0; i < slicelength; ++i)
            {
                (*sipRes) += (*sipCpp)[start];
                start += step;
            }
        }
#line 866 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQItemSelection.cpp"

            if (sipIsErr)
                return 0;

            return sipConvertFromNewType(sipRes, sipType_QItemSelection, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QItemSelection, sipName___getitem__, SIP_NULLPTR);

    return SIP_NULLPTR;
}


extern "C" {static int slot_QItemSelection___delitem__(PyObject *, PyObject *);}
static int slot_QItemSelection___delitem__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QItemSelection *sipCpp = reinterpret_cast< ::QItemSelection *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QItemSelection));

    if (!sipCpp)
        return -1;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1i", &a0))
        {
            int sipIsErr = 0;

#line 231 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qitemselectionmodel.sip"
        if ((a0 = (int)sipConvertFromSequenceIndex(a0, sipCpp->count())) < 0)
            sipIsErr = 1;
        else
            sipCpp->removeAt(a0);
#line 903 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQItemSelection.cpp"

            if (sipIsErr)
                return -1;

            return 0;
        }
    }

    {
        PyObject * a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1T", &PySlice_Type, &a0))
        {
            int sipIsErr = 0;

#line 239 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qitemselectionmodel.sip"
        Py_ssize_t start, stop, step, slicelength;
        
        if (sipConvertFromSliceObject(a0, sipCpp->count(), &start, &stop, &step, &slicelength) < 0)
        {
            sipIsErr = 1;
        }
        else
        {
            for (Py_ssize_t i = 0; i < slicelength; ++i)
            {
                sipCpp->removeAt(start);
                start += step - 1;
            }
        }
#line 934 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQItemSelection.cpp"

            if (sipIsErr)
                return -1;

            return 0;
        }
    }

    sipNoMethod(sipParseErr, sipName_QItemSelection, sipName___delitem__, SIP_NULLPTR);

    return -1;
}


extern "C" {static int slot_QItemSelection___setitem__(PyObject *, PyObject *);}
static int slot_QItemSelection___setitem__(PyObject *sipSelf, PyObject *sipArgs)
{
    ::QItemSelection *sipCpp = reinterpret_cast< ::QItemSelection *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QItemSelection));

    if (!sipCpp)
        return -1;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const ::QItemSelectionRange* a1;

        if (sipParseArgs(&sipParseErr, sipArgs, "iJ9", &a0, sipType_QItemSelectionRange, &a1))
        {
            int sipIsErr = 0;

#line 188 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qitemselectionmodel.sip"
        int len;
        
        len = sipCpp->count();
        
        if ((a0 = (int)sipConvertFromSequenceIndex(a0, len)) < 0)
            sipIsErr = 1;
        else
            (*sipCpp)[a0] = *a1;
#line 976 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQItemSelection.cpp"

            if (sipIsErr)
                return -1;

            return 0;
        }
    }

    {
        PyObject * a0;
        const ::QItemSelection* a1;

        if (sipParseArgs(&sipParseErr, sipArgs, "TJ9", &PySlice_Type, &a0, sipType_QItemSelection, &a1))
        {
            int sipIsErr = 0;

#line 200 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qitemselectionmodel.sip"
        Py_ssize_t start, stop, step, slicelength;
        
        if (sipConvertFromSliceObject(a0, sipCpp->count(), &start, &stop, &step, &slicelength) < 0)
        {
            sipIsErr = 1;
        }
        else
        {
            int vlen = a1->count();
        
            if (vlen != slicelength)
            {
                sipBadLengthForSlice(vlen, slicelength);
                sipIsErr = 1;
            }
            else
            {
                QItemSelection::const_iterator it = a1->begin();
        
                for (Py_ssize_t i = 0; i < slicelength; ++i)
                {
                    (*sipCpp)[start] = *it;
                    start += step;
                    ++it;
                }
            }
        }
#line 1021 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQItemSelection.cpp"

            if (sipIsErr)
                return -1;

            return 0;
        }
    }

    sipNoMethod(sipParseErr, sipName_QItemSelection, sipName___setitem__, SIP_NULLPTR);

    return -1;
}


extern "C" {static int slot_QItemSelection___contains__(PyObject *, PyObject *);}
static int slot_QItemSelection___contains__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QItemSelection *sipCpp = reinterpret_cast< ::QItemSelection *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QItemSelection));

    if (!sipCpp)
        return -1;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QModelIndex* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QModelIndex, &a0))
        {
            int sipRes = 0;

#line 179 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qitemselectionmodel.sip"
        // It looks like you can't assign QBool to int.
        sipRes = bool(sipCpp->contains(*a0));
#line 1056 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQItemSelection.cpp"

            return sipRes;
        }
    }

    sipNoMethod(sipParseErr, sipName_QItemSelection, sipName___contains__, SIP_NULLPTR);

    return -1;
}


/* Call the instance's destructor. */
extern "C" {static void release_QItemSelection(void *, int);}
static void release_QItemSelection(void *sipCppV, int)
{
    delete reinterpret_cast< ::QItemSelection *>(sipCppV);
}


extern "C" {static void *array_QItemSelection(Py_ssize_t);}
static void *array_QItemSelection(Py_ssize_t sipNrElem)
{
    return new ::QItemSelection[sipNrElem];
}


extern "C" {static void array_delete_QItemSelection(void *);}
static void array_delete_QItemSelection(void *sipCpp)
{
    delete[] reinterpret_cast< ::QItemSelection *>(sipCpp);
}


extern "C" {static void assign_QItemSelection(void *, Py_ssize_t, void *);}
static void assign_QItemSelection(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QItemSelection *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QItemSelection *>(sipSrc);
}


extern "C" {static void *copy_QItemSelection(const void *, Py_ssize_t);}
static void *copy_QItemSelection(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QItemSelection(reinterpret_cast<const ::QItemSelection *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QItemSelection(sipSimpleWrapper *);}
static void dealloc_QItemSelection(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QItemSelection(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QItemSelection(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QItemSelection(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QItemSelection *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            sipCpp = new ::QItemSelection();

            return sipCpp;
        }
    }

    {
        const ::QModelIndex* a0;
        const ::QModelIndex* a1;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9J9", sipType_QModelIndex, &a0, sipType_QModelIndex, &a1))
        {
            sipCpp = new ::QItemSelection(*a0, *a1);

            return sipCpp;
        }
    }

    {
        const ::QItemSelection* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QItemSelection, &a0))
        {
            sipCpp = new ::QItemSelection(*a0);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QItemSelection[] = {
    {(void *)slot_QItemSelection___iadd__, iconcat_slot},
    {(void *)slot_QItemSelection___len__, len_slot},
    {(void *)slot_QItemSelection___eq__, eq_slot},
    {(void *)slot_QItemSelection___ne__, ne_slot},
    {(void *)slot_QItemSelection___getitem__, getitem_slot},
    {(void *)slot_QItemSelection___delitem__, delitem_slot},
    {(void *)slot_QItemSelection___setitem__, setitem_slot},
    {(void *)slot_QItemSelection___contains__, contains_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QItemSelection[] = {
    {sipName_append, meth_QItemSelection_append, METH_VARARGS, doc_QItemSelection_append},
    {sipName_clear, meth_QItemSelection_clear, METH_VARARGS, doc_QItemSelection_clear},
    {sipName_contains, meth_QItemSelection_contains, METH_VARARGS, doc_QItemSelection_contains},
    {sipName_count, meth_QItemSelection_count, METH_VARARGS, doc_QItemSelection_count},
    {sipName_first, meth_QItemSelection_first, METH_VARARGS, doc_QItemSelection_first},
    {sipName_indexOf, SIP_MLMETH_CAST(meth_QItemSelection_indexOf), METH_VARARGS|METH_KEYWORDS, doc_QItemSelection_indexOf},
    {sipName_indexes, meth_QItemSelection_indexes, METH_VARARGS, doc_QItemSelection_indexes},
    {sipName_insert, meth_QItemSelection_insert, METH_VARARGS, doc_QItemSelection_insert},
    {sipName_isEmpty, meth_QItemSelection_isEmpty, METH_VARARGS, doc_QItemSelection_isEmpty},
    {sipName_last, meth_QItemSelection_last, METH_VARARGS, doc_QItemSelection_last},
    {sipName_lastIndexOf, SIP_MLMETH_CAST(meth_QItemSelection_lastIndexOf), METH_VARARGS|METH_KEYWORDS, doc_QItemSelection_lastIndexOf},
    {sipName_merge, meth_QItemSelection_merge, METH_VARARGS, doc_QItemSelection_merge},
    {sipName_move, meth_QItemSelection_move, METH_VARARGS, doc_QItemSelection_move},
    {sipName_prepend, meth_QItemSelection_prepend, METH_VARARGS, doc_QItemSelection_prepend},
    {sipName_removeAll, meth_QItemSelection_removeAll, METH_VARARGS, doc_QItemSelection_removeAll},
    {sipName_removeAt, meth_QItemSelection_removeAt, METH_VARARGS, doc_QItemSelection_removeAt},
    {sipName_replace, meth_QItemSelection_replace, METH_VARARGS, doc_QItemSelection_replace},
    {sipName_select, meth_QItemSelection_select, METH_VARARGS, doc_QItemSelection_select},
    {sipName_split, meth_QItemSelection_split, METH_VARARGS, doc_QItemSelection_split},
    {sipName_swap, meth_QItemSelection_swap, METH_VARARGS, doc_QItemSelection_swap},
    {sipName_takeAt, meth_QItemSelection_takeAt, METH_VARARGS, doc_QItemSelection_takeAt},
    {sipName_takeFirst, meth_QItemSelection_takeFirst, METH_VARARGS, doc_QItemSelection_takeFirst},
    {sipName_takeLast, meth_QItemSelection_takeLast, METH_VARARGS, doc_QItemSelection_takeLast}
};

PyDoc_STRVAR(doc_QItemSelection, "\1QItemSelection()\n"
"QItemSelection(topLeft: QModelIndex, bottomRight: QModelIndex)\n"
"QItemSelection(a0: QItemSelection)");


static pyqt5ClassPluginDef plugin_QItemSelection = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef_QtCore_QItemSelection = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QItemSelection,
        SIP_NULLPTR,
        &plugin_QItemSelection,
    },
    {
        sipNameNr_QItemSelection,
        {0, 0, 1},
        23, methods_QItemSelection,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QItemSelection,
    -1,
    sipNameNr_sip_simplewrapper,
    SIP_NULLPTR,
    slots_QItemSelection,
    init_type_QItemSelection,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QItemSelection,
    assign_QItemSelection,
    array_QItemSelection,
    copy_QItemSelection,
    release_QItemSelection,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QItemSelection,
    sizeof (::QItemSelection),
};
