/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.streams.auth.scheme;

import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeProvider;
import software.amazon.awssdk.services.dynamodb.streams.auth.scheme.DynamoDbStreamsAuthSchemeParams;
import software.amazon.awssdk.services.dynamodb.streams.auth.scheme.internal.DefaultDynamoDbStreamsAuthSchemeProvider;
import software.amazon.awssdk.services.dynamodb.streams.auth.scheme.internal.PreferredDynamoDbStreamsAuthSchemeProvider;

@SdkPublicApi
public interface DynamoDbStreamsAuthSchemeProvider
extends AuthSchemeProvider {
    public List<AuthSchemeOption> resolveAuthScheme(DynamoDbStreamsAuthSchemeParams var1);

    default public List<AuthSchemeOption> resolveAuthScheme(Consumer<DynamoDbStreamsAuthSchemeParams.Builder> consumer) {
        DynamoDbStreamsAuthSchemeParams.Builder builder = DynamoDbStreamsAuthSchemeParams.builder();
        consumer.accept(builder);
        return this.resolveAuthScheme(builder.build());
    }

    public static DynamoDbStreamsAuthSchemeProvider defaultProvider() {
        return DefaultDynamoDbStreamsAuthSchemeProvider.create();
    }

    public static DynamoDbStreamsAuthSchemeProvider defaultProvider(List<String> authSchemePreference) {
        return new PreferredDynamoDbStreamsAuthSchemeProvider(DynamoDbStreamsAuthSchemeProvider.defaultProvider(), authSchemePreference);
    }
}

