/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum VideoFormat {
    MKV("mkv"),
    MOV("mov"),
    MP4("mp4"),
    WEBM("webm"),
    FLV("flv"),
    MPEG("mpeg"),
    MPG("mpg"),
    WMV("wmv"),
    THREE_GP("three_gp"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, VideoFormat> VALUE_MAP;
    private final String value;

    private VideoFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static VideoFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<VideoFormat> knownValues() {
        EnumSet<VideoFormat> knownValues = EnumSet.allOf(VideoFormat.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(VideoFormat.class, VideoFormat::toString);
    }
}

