/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.rest;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.ml.common.memorycontainer.MemoryType;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.memorycontainer.memory.MLDeleteMemoriesByQueryAction;
import org.opensearch.ml.common.transport.memorycontainer.memory.MLDeleteMemoriesByQueryRequest;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.transport.client.node.NodeClient;

public class RestMLDeleteMemoriesByQueryAction
extends BaseRestHandler {
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RestMLDeleteMemoriesByQueryAction(MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public String getName() {
        return "ml_delete_memories_by_query_action";
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.POST, "/_plugins/_ml/memory_containers/{memory_container_id}/memories/{memory_type}/_delete_by_query"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String memoryContainerId = RestActionUtils.getParameterId(request, "memory_container_id");
        String memoryTypeStr = RestActionUtils.getParameterId(request, "memory_type");
        MemoryType memoryType = MemoryType.fromString((String)memoryTypeStr);
        QueryBuilder query = null;
        if (request.hasContent()) {
            try (XContentParser parser = request.contentParser();){
                query = this.parseQuery(parser);
            }
        }
        MLDeleteMemoriesByQueryRequest deleteRequest = new MLDeleteMemoriesByQueryRequest(memoryContainerId, memoryType, query);
        return channel -> client.execute((ActionType)MLDeleteMemoriesByQueryAction.INSTANCE, (ActionRequest)deleteRequest, (ActionListener)new RestToXContentListener(channel));
    }

    private QueryBuilder parseQuery(XContentParser parser) throws IOException {
        parser.nextToken();
        QueryBuilder query = null;
        if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
            String fieldName = null;
            while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                if (parser.currentToken() == XContentParser.Token.FIELD_NAME) {
                    fieldName = parser.currentName();
                    continue;
                }
                if ("query".equals(fieldName)) {
                    query = AbstractQueryBuilder.parseInnerQueryBuilder((XContentParser)parser);
                    continue;
                }
                parser.skipChildren();
            }
        }
        return query;
    }
}

