/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.util.tokens.impl;

import com.oracle.labs.mlrg.olcut.config.Configurable;
import com.oracle.labs.mlrg.olcut.provenance.ConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.impl.ConfiguredObjectProvenanceImpl;
import org.tribuo.util.tokens.Token;
import org.tribuo.util.tokens.Tokenizer;

public class ShapeTokenizer
implements Tokenizer {
    private String cs;
    private int pos;
    private String token;
    private StringBuilder tb = new StringBuilder();
    private int start;
    private int end;
    private char currClass;
    private int prevClass;
    private boolean ready;

    public ConfiguredObjectProvenance getProvenance() {
        return new ConfiguredObjectProvenanceImpl((Configurable)this, "Tokenizer");
    }

    @Override
    public void reset(CharSequence cs) {
        this.cs = cs.toString();
        this.pos = 0;
        this.start = -1;
        this.end = -1;
        this.prevClass = -1;
        this.token = null;
        this.ready = false;
    }

    private char getClass(int cp) {
        if (Character.isUpperCase(cp)) {
            return 'A';
        }
        if (Character.isLowerCase(cp)) {
            return 'a';
        }
        if (Character.isDigit(cp)) {
            return '1';
        }
        if (Character.isWhitespace(cp)) {
            return ' ';
        }
        return (char)cp;
    }

    @Override
    public boolean advance() {
        if (this.cs == null) {
            throw new IllegalStateException("ShapeTokenizer has not been reset.");
        }
        this.tb.delete(0, this.tb.length());
        this.start = this.pos;
        while (this.pos < this.cs.length()) {
            int cp = this.cs.codePointAt(this.pos);
            int lcp = Character.charCount(cp);
            this.currClass = this.getClass(cp);
            if (this.tb.length() == 0 && this.currClass == ' ') {
                this.pos += lcp;
                this.start = this.pos;
                this.prevClass = this.currClass;
                continue;
            }
            if (this.currClass != this.prevClass && this.prevClass != -1 && (this.prevClass != 65 || this.currClass != 'a') && this.tb.length() > 0) {
                this.token = this.tb.toString();
                this.prevClass = this.currClass;
                this.ready = true;
                return true;
            }
            if (this.currClass != ' ') {
                this.tb.appendCodePoint(cp);
            }
            this.prevClass = this.currClass;
            this.pos += lcp;
            this.end = this.pos;
        }
        if (this.tb.length() > 0) {
            this.token = this.tb.toString();
            this.ready = true;
            return true;
        }
        return false;
    }

    @Override
    public String getText() {
        if (this.ready) {
            return this.token;
        }
        throw new IllegalStateException("ShapeTokenizer is not ready.");
    }

    @Override
    public int getStart() {
        if (this.ready) {
            return this.start;
        }
        throw new IllegalStateException("ShapeTokenizer is not ready.");
    }

    @Override
    public int getEnd() {
        if (this.ready) {
            return this.end;
        }
        throw new IllegalStateException("ShapeTokenizer is not ready.");
    }

    @Override
    public Token.TokenType getType() {
        if (this.ready) {
            return Token.TokenType.WORD;
        }
        throw new IllegalStateException("ShapeTokenizer is not ready.");
    }

    @Override
    public ShapeTokenizer clone() {
        try {
            ShapeTokenizer copy = (ShapeTokenizer)super.clone();
            copy.tb = new StringBuilder();
            copy.ready = false;
            copy.cs = null;
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)"ShapeTokenizer is Cloneable, but clone call failed");
        }
    }
}

