/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.security;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.security.CreateUpdateTenancyConfigResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public final class CreateUpdateTenancyConfigRequest
extends RequestBase
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, CreateUpdateTenancyConfigRequest> {
    @Nullable
    private final String defaultTenant;
    @Nullable
    private final Boolean multitenancyEnabled;
    @Nullable
    private final Boolean privateTenantEnabled;
    @Nonnull
    private final List<String> signInOptions;
    public static final JsonpDeserializer<CreateUpdateTenancyConfigRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CreateUpdateTenancyConfigRequest::setupCreateUpdateTenancyConfigRequestDeserializer);
    public static final Endpoint<CreateUpdateTenancyConfigRequest, CreateUpdateTenancyConfigResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<CreateUpdateTenancyConfigRequest, CreateUpdateTenancyConfigResponse>(request -> "PUT", request -> "/_plugins/_security/api/tenancy/config", request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), true, CreateUpdateTenancyConfigResponse._DESERIALIZER);

    private CreateUpdateTenancyConfigRequest(Builder builder) {
        super(builder);
        this.defaultTenant = builder.defaultTenant;
        this.multitenancyEnabled = builder.multitenancyEnabled;
        this.privateTenantEnabled = builder.privateTenantEnabled;
        this.signInOptions = ApiTypeHelper.unmodifiable(builder.signInOptions);
    }

    public static CreateUpdateTenancyConfigRequest of(Function<Builder, ObjectBuilder<CreateUpdateTenancyConfigRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String defaultTenant() {
        return this.defaultTenant;
    }

    @Nullable
    public final Boolean multitenancyEnabled() {
        return this.multitenancyEnabled;
    }

    @Nullable
    public final Boolean privateTenantEnabled() {
        return this.privateTenantEnabled;
    }

    @Nonnull
    public final List<String> signInOptions() {
        return this.signInOptions;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.defaultTenant != null) {
            generator.writeKey("default_tenant");
            generator.write(this.defaultTenant);
        }
        if (this.multitenancyEnabled != null) {
            generator.writeKey("multitenancy_enabled");
            generator.write(this.multitenancyEnabled.booleanValue());
        }
        if (this.privateTenantEnabled != null) {
            generator.writeKey("private_tenant_enabled");
            generator.write(this.privateTenantEnabled.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.signInOptions)) {
            generator.writeKey("sign_in_options");
            generator.writeStartArray();
            for (String item0 : this.signInOptions) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupCreateUpdateTenancyConfigRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::defaultTenant, JsonpDeserializer.stringDeserializer(), "default_tenant");
        op.add(Builder::multitenancyEnabled, JsonpDeserializer.booleanDeserializer(), "multitenancy_enabled");
        op.add(Builder::privateTenantEnabled, JsonpDeserializer.booleanDeserializer(), "private_tenant_enabled");
        op.add(Builder::signInOptions, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "sign_in_options");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.defaultTenant);
        result = 31 * result + Objects.hashCode(this.multitenancyEnabled);
        result = 31 * result + Objects.hashCode(this.privateTenantEnabled);
        result = 31 * result + Objects.hashCode(this.signInOptions);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateUpdateTenancyConfigRequest other = (CreateUpdateTenancyConfigRequest)o;
        return Objects.equals(this.defaultTenant, other.defaultTenant) && Objects.equals(this.multitenancyEnabled, other.multitenancyEnabled) && Objects.equals(this.privateTenantEnabled, other.privateTenantEnabled) && Objects.equals(this.signInOptions, other.signInOptions);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, CreateUpdateTenancyConfigRequest> {
        @Nullable
        private String defaultTenant;
        @Nullable
        private Boolean multitenancyEnabled;
        @Nullable
        private Boolean privateTenantEnabled;
        @Nullable
        private List<String> signInOptions;

        public Builder() {
        }

        private Builder(CreateUpdateTenancyConfigRequest o) {
            super(o);
            this.defaultTenant = o.defaultTenant;
            this.multitenancyEnabled = o.multitenancyEnabled;
            this.privateTenantEnabled = o.privateTenantEnabled;
            this.signInOptions = Builder._listCopy(o.signInOptions);
        }

        private Builder(Builder o) {
            super(o);
            this.defaultTenant = o.defaultTenant;
            this.multitenancyEnabled = o.multitenancyEnabled;
            this.privateTenantEnabled = o.privateTenantEnabled;
            this.signInOptions = Builder._listCopy(o.signInOptions);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder defaultTenant(@Nullable String value) {
            this.defaultTenant = value;
            return this;
        }

        @Nonnull
        public final Builder multitenancyEnabled(@Nullable Boolean value) {
            this.multitenancyEnabled = value;
            return this;
        }

        @Nonnull
        public final Builder privateTenantEnabled(@Nullable Boolean value) {
            this.privateTenantEnabled = value;
            return this;
        }

        @Nonnull
        public final Builder signInOptions(List<String> list) {
            this.signInOptions = Builder._listAddAll(this.signInOptions, list);
            return this;
        }

        @Nonnull
        public final Builder signInOptions(String value, String ... values) {
            this.signInOptions = Builder._listAdd(this.signInOptions, value, values);
            return this;
        }

        @Override
        @Nonnull
        public CreateUpdateTenancyConfigRequest build() {
            this._checkSingleUse();
            return new CreateUpdateTenancyConfigRequest(this);
        }
    }
}

