/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.ExpandWildcard;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch.core.CreatePitResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

public final class CreatePitRequest
extends RequestBase
implements ToCopyableBuilder<Builder, CreatePitRequest> {
    @Nullable
    private final Boolean allowPartialPitCreation;
    @Nonnull
    private final List<ExpandWildcard> expandWildcards;
    @Nonnull
    private final List<String> index;
    @Nullable
    private final Time keepAlive;
    @Nullable
    private final String preference;
    @Nonnull
    private final List<String> routing;
    public static final Endpoint<CreatePitRequest, CreatePitResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<CreatePitRequest, CreatePitResponse>(request -> "POST", request -> {
        StringBuilder buf = new StringBuilder();
        buf.append("/");
        SimpleEndpoint.pathEncode(String.join((CharSequence)",", request.index), buf);
        buf.append("/_search/point_in_time");
        return buf.toString();
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), false, CreatePitResponse._DESERIALIZER);

    private CreatePitRequest(Builder builder) {
        super(builder);
        this.allowPartialPitCreation = builder.allowPartialPitCreation;
        this.expandWildcards = ApiTypeHelper.unmodifiable(builder.expandWildcards);
        this.index = ApiTypeHelper.unmodifiableRequired(builder.index, (Object)this, "index");
        this.keepAlive = builder.keepAlive;
        this.preference = builder.preference;
        this.routing = ApiTypeHelper.unmodifiable(builder.routing);
    }

    public static CreatePitRequest of(Function<Builder, ObjectBuilder<CreatePitRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowPartialPitCreation() {
        return this.allowPartialPitCreation;
    }

    @Nonnull
    public final List<ExpandWildcard> expandWildcards() {
        return this.expandWildcards;
    }

    @Nonnull
    public final List<String> index() {
        return this.index;
    }

    @Nullable
    public final Time keepAlive() {
        return this.keepAlive;
    }

    @Nullable
    public final String preference() {
        return this.preference;
    }

    @Nonnull
    public final List<String> routing() {
        return this.routing;
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (this.allowPartialPitCreation != null) {
            params.put("allow_partial_pit_creation", String.valueOf(this.allowPartialPitCreation));
        }
        if (ApiTypeHelper.isDefined(this.expandWildcards)) {
            params.put("expand_wildcards", this.expandWildcards.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        if (this.keepAlive != null) {
            params.put("keep_alive", this.keepAlive._toJsonString());
        }
        if (this.preference != null) {
            params.put("preference", this.preference);
        }
        if (ApiTypeHelper.isDefined(this.routing)) {
            params.put("routing", String.join((CharSequence)",", this.routing));
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.allowPartialPitCreation);
        result = 31 * result + Objects.hashCode(this.expandWildcards);
        result = 31 * result + this.index.hashCode();
        result = 31 * result + Objects.hashCode(this.keepAlive);
        result = 31 * result + Objects.hashCode(this.preference);
        result = 31 * result + Objects.hashCode(this.routing);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreatePitRequest other = (CreatePitRequest)o;
        return Objects.equals(this.allowPartialPitCreation, other.allowPartialPitCreation) && Objects.equals(this.expandWildcards, other.expandWildcards) && this.index.equals(other.index) && Objects.equals(this.keepAlive, other.keepAlive) && Objects.equals(this.preference, other.preference) && Objects.equals(this.routing, other.routing);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, CreatePitRequest> {
        @Nullable
        private Boolean allowPartialPitCreation;
        @Nullable
        private List<ExpandWildcard> expandWildcards;
        private List<String> index;
        @Nullable
        private Time keepAlive;
        @Nullable
        private String preference;
        @Nullable
        private List<String> routing;

        public Builder() {
        }

        private Builder(CreatePitRequest o) {
            super(o);
            this.allowPartialPitCreation = o.allowPartialPitCreation;
            this.expandWildcards = Builder._listCopy(o.expandWildcards);
            this.index = Builder._listCopy(o.index);
            this.keepAlive = o.keepAlive;
            this.preference = o.preference;
            this.routing = Builder._listCopy(o.routing);
        }

        private Builder(Builder o) {
            super(o);
            this.allowPartialPitCreation = o.allowPartialPitCreation;
            this.expandWildcards = Builder._listCopy(o.expandWildcards);
            this.index = Builder._listCopy(o.index);
            this.keepAlive = o.keepAlive;
            this.preference = o.preference;
            this.routing = Builder._listCopy(o.routing);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder allowPartialPitCreation(@Nullable Boolean value) {
            this.allowPartialPitCreation = value;
            return this;
        }

        @Nonnull
        public final Builder expandWildcards(List<ExpandWildcard> list) {
            this.expandWildcards = Builder._listAddAll(this.expandWildcards, list);
            return this;
        }

        @Nonnull
        public final Builder expandWildcards(ExpandWildcard value, ExpandWildcard ... values) {
            this.expandWildcards = Builder._listAdd(this.expandWildcards, value, values);
            return this;
        }

        @Nonnull
        public final Builder index(List<String> list) {
            this.index = Builder._listAddAll(this.index, list);
            return this;
        }

        @Nonnull
        public final Builder index(String value, String ... values) {
            this.index = Builder._listAdd(this.index, value, values);
            return this;
        }

        @Nonnull
        public final Builder keepAlive(@Nullable Time value) {
            this.keepAlive = value;
            return this;
        }

        @Nonnull
        public final Builder keepAlive(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.keepAlive(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder preference(@Nullable String value) {
            this.preference = value;
            return this;
        }

        @Nonnull
        public final Builder routing(List<String> list) {
            this.routing = Builder._listAddAll(this.routing, list);
            return this;
        }

        @Nonnull
        public final Builder routing(String value, String ... values) {
            this.routing = Builder._listAdd(this.routing, value, values);
            return this;
        }

        @Override
        @Nonnull
        public CreatePitRequest build() {
            this._checkSingleUse();
            return new CreatePitRequest(this);
        }
    }
}

