/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.analysis.common;

import java.util.regex.Pattern;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.opensearch.analysis.common.PatternAnalyzer;
import org.opensearch.common.regex.Regex;
import org.opensearch.common.settings.Settings;
import org.opensearch.env.Environment;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.analysis.AbstractIndexAnalyzerProvider;
import org.opensearch.index.analysis.Analysis;

public class PatternAnalyzerProvider
extends AbstractIndexAnalyzerProvider<Analyzer> {
    private final PatternAnalyzer analyzer;

    PatternAnalyzerProvider(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(indexSettings, name, settings);
        CharArraySet defaultStopwords = CharArraySet.EMPTY_SET;
        boolean lowercase = settings.getAsBoolean("lowercase", Boolean.valueOf(true));
        CharArraySet stopWords = Analysis.parseStopWords((Environment)env, (Settings)settings, (CharArraySet)defaultStopwords);
        String sPattern = settings.get("pattern", "\\W+");
        if (sPattern == null) {
            throw new IllegalArgumentException("Analyzer [" + name + "] of type pattern must have a `pattern` set");
        }
        Pattern pattern = Regex.compile((String)sPattern, (String)settings.get("flags"));
        this.analyzer = new PatternAnalyzer(pattern, lowercase, stopWords);
    }

    public PatternAnalyzer get() {
        return this.analyzer;
    }
}

