﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/guardduty/GuardDuty_EXPORTS.h>
#include <aws/guardduty/model/MalwareProtectionResourceType.h>
#include <aws/guardduty/model/MalwareProtectionScanStatus.h>
#include <aws/guardduty/model/MalwareProtectionScanType.h>
#include <aws/guardduty/model/ScanResultStatus.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace GuardDuty {
namespace Model {

/**
 * <p>Contains information about a particular malware scan.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/MalwareScan">AWS
 * API Reference</a></p>
 */
class MalwareScan {
 public:
  AWS_GUARDDUTY_API MalwareScan() = default;
  AWS_GUARDDUTY_API MalwareScan(Aws::Utils::Json::JsonView jsonValue);
  AWS_GUARDDUTY_API MalwareScan& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_GUARDDUTY_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>Amazon Resource Name (ARN) of the resource for the given malware scan.</p>
   */
  inline const Aws::String& GetResourceArn() const { return m_resourceArn; }
  inline bool ResourceArnHasBeenSet() const { return m_resourceArnHasBeenSet; }
  template <typename ResourceArnT = Aws::String>
  void SetResourceArn(ResourceArnT&& value) {
    m_resourceArnHasBeenSet = true;
    m_resourceArn = std::forward<ResourceArnT>(value);
  }
  template <typename ResourceArnT = Aws::String>
  MalwareScan& WithResourceArn(ResourceArnT&& value) {
    SetResourceArn(std::forward<ResourceArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The type of resource that was scanned for malware.</p>
   */
  inline MalwareProtectionResourceType GetResourceType() const { return m_resourceType; }
  inline bool ResourceTypeHasBeenSet() const { return m_resourceTypeHasBeenSet; }
  inline void SetResourceType(MalwareProtectionResourceType value) {
    m_resourceTypeHasBeenSet = true;
    m_resourceType = value;
  }
  inline MalwareScan& WithResourceType(MalwareProtectionResourceType value) {
    SetResourceType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A unique identifier that gets generated when you invoke the API without any
   * error. Each malware scan has a corresponding scan ID. Using this scan ID, you
   * can monitor the status of your malware scan.</p>
   */
  inline const Aws::String& GetScanId() const { return m_scanId; }
  inline bool ScanIdHasBeenSet() const { return m_scanIdHasBeenSet; }
  template <typename ScanIdT = Aws::String>
  void SetScanId(ScanIdT&& value) {
    m_scanIdHasBeenSet = true;
    m_scanId = std::forward<ScanIdT>(value);
  }
  template <typename ScanIdT = Aws::String>
  MalwareScan& WithScanId(ScanIdT&& value) {
    SetScanId(std::forward<ScanIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An enum value representing the current status of the malware scan.</p>
   */
  inline MalwareProtectionScanStatus GetScanStatus() const { return m_scanStatus; }
  inline bool ScanStatusHasBeenSet() const { return m_scanStatusHasBeenSet; }
  inline void SetScanStatus(MalwareProtectionScanStatus value) {
    m_scanStatusHasBeenSet = true;
    m_scanStatus = value;
  }
  inline MalwareScan& WithScanStatus(MalwareProtectionScanStatus value) {
    SetScanStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An enum value representing the result of the malware scan.</p>
   */
  inline ScanResultStatus GetScanResultStatus() const { return m_scanResultStatus; }
  inline bool ScanResultStatusHasBeenSet() const { return m_scanResultStatusHasBeenSet; }
  inline void SetScanResultStatus(ScanResultStatus value) {
    m_scanResultStatusHasBeenSet = true;
    m_scanResultStatus = value;
  }
  inline MalwareScan& WithScanResultStatus(ScanResultStatus value) {
    SetScanResultStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An enum value representing the type of scan that was initiated.</p>
   */
  inline MalwareProtectionScanType GetScanType() const { return m_scanType; }
  inline bool ScanTypeHasBeenSet() const { return m_scanTypeHasBeenSet; }
  inline void SetScanType(MalwareProtectionScanType value) {
    m_scanTypeHasBeenSet = true;
    m_scanType = value;
  }
  inline MalwareScan& WithScanType(MalwareProtectionScanType value) {
    SetScanType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The timestamp representing when the malware scan was started.</p>
   */
  inline const Aws::Utils::DateTime& GetScanStartedAt() const { return m_scanStartedAt; }
  inline bool ScanStartedAtHasBeenSet() const { return m_scanStartedAtHasBeenSet; }
  template <typename ScanStartedAtT = Aws::Utils::DateTime>
  void SetScanStartedAt(ScanStartedAtT&& value) {
    m_scanStartedAtHasBeenSet = true;
    m_scanStartedAt = std::forward<ScanStartedAtT>(value);
  }
  template <typename ScanStartedAtT = Aws::Utils::DateTime>
  MalwareScan& WithScanStartedAt(ScanStartedAtT&& value) {
    SetScanStartedAt(std::forward<ScanStartedAtT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The timestamp representing when the malware scan was completed.</p>
   */
  inline const Aws::Utils::DateTime& GetScanCompletedAt() const { return m_scanCompletedAt; }
  inline bool ScanCompletedAtHasBeenSet() const { return m_scanCompletedAtHasBeenSet; }
  template <typename ScanCompletedAtT = Aws::Utils::DateTime>
  void SetScanCompletedAt(ScanCompletedAtT&& value) {
    m_scanCompletedAtHasBeenSet = true;
    m_scanCompletedAt = std::forward<ScanCompletedAtT>(value);
  }
  template <typename ScanCompletedAtT = Aws::Utils::DateTime>
  MalwareScan& WithScanCompletedAt(ScanCompletedAtT&& value) {
    SetScanCompletedAt(std::forward<ScanCompletedAtT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_resourceArn;

  MalwareProtectionResourceType m_resourceType{MalwareProtectionResourceType::NOT_SET};

  Aws::String m_scanId;

  MalwareProtectionScanStatus m_scanStatus{MalwareProtectionScanStatus::NOT_SET};

  ScanResultStatus m_scanResultStatus{ScanResultStatus::NOT_SET};

  MalwareProtectionScanType m_scanType{MalwareProtectionScanType::NOT_SET};

  Aws::Utils::DateTime m_scanStartedAt{};

  Aws::Utils::DateTime m_scanCompletedAt{};
  bool m_resourceArnHasBeenSet = false;
  bool m_resourceTypeHasBeenSet = false;
  bool m_scanIdHasBeenSet = false;
  bool m_scanStatusHasBeenSet = false;
  bool m_scanResultStatusHasBeenSet = false;
  bool m_scanTypeHasBeenSet = false;
  bool m_scanStartedAtHasBeenSet = false;
  bool m_scanCompletedAtHasBeenSet = false;
};

}  // namespace Model
}  // namespace GuardDuty
}  // namespace Aws
