/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.refactoring.java.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.refactoring.java.api.InnerToOuterRefactoring;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;


/** UI panel for collecting refactoring parameters.
 *
 * @author Martin Matula
 * @author Jan Becicka
 */
public class InnerToOuterPanel extends JPanel implements CustomRefactoringPanel {
    // refactoring this panel provides parameters for
    private final InnerToOuterRefactoring refactoring;
    private final ChangeListener parent;
    private boolean disableDeclareFields;
    private boolean initialized = false;
    
    /** Creates new form InnerToOuterPanel
     * @param refactoring The refactoring this panel provides parameters for.
     */
    public InnerToOuterPanel(InnerToOuterRefactoring refactoring, final ChangeListener parent, boolean disableDeclareFields) {
        this.refactoring = refactoring;
        this.parent = parent;
        initComponents();
        setPreferredSize(new Dimension(300, 130));
        this.disableDeclareFields = disableDeclareFields;
    }
    
    @Override
    public Component getComponent() {
        return this;
    }

    /** Initialization of the panel (called by the parent window).
     */
    @Override
    public void initialize() {
        if (initialized) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable() {
            @Override
            public void run() {
                classNameField.setText(refactoring.getClassName());
                if (disableDeclareFields) {
                    fieldCheckBox.setEnabled(false);
                } else if (refactoring.getReferenceName() != null) {
                    fieldNameField.setText(refactoring.getReferenceName());
                    fieldCheckBox.setSelected(true);
                }
                DocumentListener dl = new DocumentListener() {
                    @Override
                    public void changedUpdate(DocumentEvent event) {
                        parent.stateChanged(null);
                    }
                    @Override
                    public void insertUpdate(DocumentEvent event) {
                        parent.stateChanged(null);
                    }
                    @Override
                    public void removeUpdate(DocumentEvent event) {
                        parent.stateChanged(null);
                    }
                };
                classNameField.getDocument().addDocumentListener(dl);
                fieldNameField.getDocument().addDocumentListener(dl);
                classNameField.selectAll();
                classNameField.requestFocusInWindow();
            }
        });
        initialized = true;
    }
    
    // --- GETTERS FOR REFACTORING PARAMETERS ----------------------------------
    
    /** Getter used by the refactoring UI to get value
     * of target type.
     * @return Target type.
     */
    public String getClassName() {
        return classNameField.getText();
    }
    
    public String getReferenceName() {
        if (fieldCheckBox.isSelected()) {
            return fieldNameField.getText();
        } else {
            return null;
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        classNameField.requestFocusInWindow();
        return true;
    }
    
    // --- GENERATED CODE ------------------------------------------------------
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        dataPanel = new javax.swing.JPanel();
        classNameLabel = new javax.swing.JLabel();
        classNameField = new javax.swing.JTextField();
        fieldPanel = new javax.swing.JPanel();
        fieldCheckBox = new javax.swing.JCheckBox();
        fieldNamePanel = new javax.swing.JPanel();
        fieldNameLabel = new javax.swing.JLabel();
        fieldNameField = new javax.swing.JTextField();

        setBorder(javax.swing.BorderFactory.createEmptyBorder(12, 12, 11, 11));
        setLayout(new java.awt.BorderLayout());

        dataPanel.setBorder(javax.swing.BorderFactory.createEmptyBorder(1, 1, 1, 1));
        dataPanel.setLayout(new java.awt.BorderLayout(12, 0));

        classNameLabel.setLabelFor(classNameField);
        org.openide.awt.Mnemonics.setLocalizedText(classNameLabel, org.openide.util.NbBundle.getBundle(InnerToOuterPanel.class).getString("LBL_InnerToOuter_ClassName")); // NOI18N
        dataPanel.add(classNameLabel, java.awt.BorderLayout.WEST);
        dataPanel.add(classNameField, java.awt.BorderLayout.CENTER);
        classNameField.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(InnerToOuterPanel.class, "ACSD_nameField")); // NOI18N
        classNameField.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(InnerToOuterPanel.class, "ACSD_nameField")); // NOI18N

        fieldPanel.setBorder(javax.swing.BorderFactory.createEmptyBorder(12, 0, 0, 0));
        fieldPanel.setLayout(new java.awt.BorderLayout());

        org.openide.awt.Mnemonics.setLocalizedText(fieldCheckBox, org.openide.util.NbBundle.getMessage(InnerToOuterPanel.class, "LBL_InnerToOuter_DeclareField")); // NOI18N
        fieldCheckBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(4, 0, 4, 0));
        fieldCheckBox.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                fieldCheckBoxItemStateChanged(evt);
            }
        });
        fieldPanel.add(fieldCheckBox, java.awt.BorderLayout.NORTH);
        fieldCheckBox.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(InnerToOuterPanel.class, "ACSD_DeclareFieldName")); // NOI18N
        fieldCheckBox.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(InnerToOuterPanel.class, "ACSD_DeclareFieldDescription")); // NOI18N

        fieldNamePanel.setBorder(javax.swing.BorderFactory.createEmptyBorder(4, 32, 0, 0));
        fieldNamePanel.setLayout(new java.awt.BorderLayout(12, 0));

        fieldNameLabel.setLabelFor(fieldNameField);
        org.openide.awt.Mnemonics.setLocalizedText(fieldNameLabel, org.openide.util.NbBundle.getMessage(InnerToOuterPanel.class, "LBL_InnerToOuter_FieldName")); // NOI18N
        fieldNameLabel.setEnabled(false);
        fieldNamePanel.add(fieldNameLabel, java.awt.BorderLayout.WEST);
        fieldNameLabel.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(InnerToOuterPanel.class, "ACSD_DeclareFieldName")); // NOI18N

        fieldNameField.setEnabled(false);
        fieldNamePanel.add(fieldNameField, java.awt.BorderLayout.CENTER);
        fieldNameField.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(InnerToOuterPanel.class, "ACSD_DeclareFieldName")); // NOI18N
        fieldNameField.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(InnerToOuterPanel.class, "ACSD_DeclareFieldDescription")); // NOI18N

        fieldPanel.add(fieldNamePanel, java.awt.BorderLayout.SOUTH);

        dataPanel.add(fieldPanel, java.awt.BorderLayout.SOUTH);

        add(dataPanel, java.awt.BorderLayout.NORTH);
    }// </editor-fold>//GEN-END:initComponents

    private void fieldCheckBoxItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_fieldCheckBoxItemStateChanged
        boolean enable = evt.getStateChange() == ItemEvent.SELECTED;
        fieldNameField.setEnabled(enable);
        fieldNameLabel.setEnabled(enable);
        parent.stateChanged(null);
    }//GEN-LAST:event_fieldCheckBoxItemStateChanged
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField classNameField;
    private javax.swing.JLabel classNameLabel;
    private javax.swing.JPanel dataPanel;
    private javax.swing.JCheckBox fieldCheckBox;
    private javax.swing.JTextField fieldNameField;
    private javax.swing.JLabel fieldNameLabel;
    private javax.swing.JPanel fieldNamePanel;
    private javax.swing.JPanel fieldPanel;
    // End of variables declaration//GEN-END:variables
    
}
