// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkCompositeUnsignedIntArray
 * @brief   composite implicit array of unsigned int.
 *
 * vtkCompositeUnsignedIntArray is a composite implicit array of values of type unsigned int.
 * see vtkCompositeArray, vtkCompositeImplicitBackend
 *
 * This file is generated by vtkImplicitArrays.cmake
 */

#ifndef vtkCompositeUnsignedIntArray_h
#define vtkCompositeUnsignedIntArray_h

#include "vtkCompositeArray.h" // Real Superclass
#include "vtkCommonCoreModule.h"     // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkCompositeArray<unsigned int>
#endif
VTK_ABI_NAMESPACE_BEGIN
class vtkDataArrayCollection;

class VTKCOMMONCORE_EXPORT vtkCompositeUnsignedIntArray : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkCompositeUnsignedIntArray, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkCompositeUnsignedIntArray* New();
  static vtkCompositeUnsignedIntArray* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(unsigned int);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkCompositeUnsignedIntArray* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkCompositeUnsignedIntArray*>(Superclass::FastDownCast(source));
  }

  /**
   * Set the underlying arrays to use.
   */
  void ConstructBackend(vtkDataArrayCollection* arrays);

protected:
  vtkCompositeUnsignedIntArray();
  ~vtkCompositeUnsignedIntArray() override;

private:
  typedef vtkCompositeArray<unsigned int> RealSuperclass;

  vtkCompositeUnsignedIntArray(const vtkCompositeUnsignedIntArray&) = delete;
  void operator=(const vtkCompositeUnsignedIntArray&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkCompositeUnsignedIntArray);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
