%feature("docstring") OT::RayleighFactory
"Rayleigh factory.

Notes
-----
The parameters are estimated by method of moments:

.. math::
    :nowrap:

    \\begin{eqnarray*}
      \\displaystyle\\Hat{\\gamma}_n = (1-\\mathrm{sign}(x_{(1,n)})/(2+n))x_{(1,n)}\\\\
      \\displaystyle\\Hat{\\sigma}_n=\\sqrt{\\frac{2}{n}\\sum_{i=1}^n(x_i-\\Hat{\\gamma}_n)^2}
    \\end{eqnarray*}

See also
--------
DistributionFactory, Rayleigh"

// ---------------------------------------------------------------------

%feature("docstring") OT::RayleighFactory::buildAsRayleigh
"Estimate the distribution as native distribution.

**Available usages**:

    buildAsRayleigh()

    buildAsRayleigh(*sample*)

    buildAsRayleigh(*param*)

Parameters
----------
sample : 2-d sequence of float
    Data.
param : sequence of float,
    The parameters of the :class:`~openturns.Rayleigh`.

Returns
-------
dist : :class:`~openturns.Rayleigh`
    The estimated distribution as a Rayleigh.
    
    In the first usage, the default Rayleigh distribution is built."

