# enca

> Detect and convert the encoding of text files.
> More information: <https://manned.org/enca>.

- Detect file(s) encoding according to the system's locale:

`enca {{path/to/file1 path/to/file2 ...}}`

- Detect file(s) encoding specifying a language in the POSIX/C locale format (e.g. zh_CN, en_US):

`enca {{[-L|--language]}} {{language}} {{path/to/file1 path/to/file2 ...}}`

- Convert file(s) to a specific encoding:

`enca {{[-L|--language]}} {{language}} {{[-x|--convert-to]}} {{to_encoding}} {{path/to/file1 path/to/file2 ...}}`

- Create a copy of an existing file using a different encoding:

`enca < {{original_file}} {{[-L|--language]}} {{language}} {{[-x|--convert-to]}} {{to_encoding}} > {{new_file}}`
