# git cherry-pick

> தற்போதுள்ள கமிட்டுகளால் அறிமுகப்படுத்தப்பட்ட மாற்றங்களை தற்போதைய கிளையில் பயன்படுத்துங்கள்.
> மற்றொரு கிளையில் மாற்றங்களைப் பயன்படுத்த, முதலில் விரும்பிய கிளைக்கு மாற `git checkout` ஐப் பயன்படுத்தவும்.
> மேலும் விவரத்திற்கு: <https://git-scm.com/docs/git-cherry-pick>.

- தற்போதைய கிளைக்கு ஒரு கமிட்டை பயன்படுத்துங்கள்:

`git cherry-pick {{கமிட்}}`

- தற்போதைய கிளையில் பலவிதமான கமிட்டுகளைப் பயன்படுத்துங்கள் (மேலும் `git rebase --onto` பார்க்கவும் ):

`git cherry-pick {{தொடக்க_கமிட்}}~..{{முடிவு_கமிட்}}`

- தற்போதைய கிளைக்கு பல (வரிசை அல்லாத) கமிட்டுகளைப் பயன்படுத்துங்கள்:

`git cherry-pick {{கமிட்_1 கமிட்_2 ...}}`

- ஒரு கமிட்டை உருவாக்காமல், பணிபுரியும் கோப்பகத்தில் ஒரு கமிட்டின் மாற்றங்களைச் சேர்க்கவும்:

`git cherry-pick {{[-n|--no-commit]}} {{கமிட்}}`
