# FastAPI 지원 - 도움 받기 { #help-fastapi-get-help }

**FastAPI** 가 마음에 드시나요?

FastAPI, 다른 사용자, 개발자를 응원하고 싶으신가요?

혹은 **FastAPI** 에 대해 도움이 필요하신가요?

아주 간단하게 응원할 수 있습니다 (몇 번의 클릭만으로).

또한 도움을 받을 수 있는 방법도 몇 가지 있습니다.

## 뉴스레터 구독 { #subscribe-to-the-newsletter }

(자주 발송되지 않는) [**FastAPI and friends** 뉴스레터](newsletter.md){.internal-link target=_blank}를 구독하여 최신 정보를 유지할 수 있습니다:

* FastAPI and friends에 대한 뉴스 🚀
* 가이드 📝
* 기능 ✨
* 획기적인 변화 🚨
* 팁과 요령 ✅

## X(Twitter)에서 FastAPI 팔로우하기 { #follow-fastapi-on-x-twitter }

<a href="https://x.com/fastapi" class="external-link" target="_blank">**X (Twitter)**의 @fastapi를 팔로우</a>하여 **FastAPI** 에 대한 최신 뉴스를 얻을 수 있습니다. 🐦

## GitHub에서 **FastAPI**에 Star 주기 { #star-fastapi-in-github }

GitHub에서 FastAPI에 "star"를 붙일 수 있습니다 (오른쪽 상단의 star 버튼을 클릭): <a href="https://github.com/fastapi/fastapi" class="external-link" target="_blank">https://github.com/fastapi/fastapi</a>. ⭐️

스타를 늘림으로써, 다른 사용자들이 좀 더 쉽게 찾을 수 있고, 많은 사람들에게 유용한 것임을 나타낼 수 있습니다.

## 릴리즈 확인을 위해 GitHub 저장소 보기 { #watch-the-github-repository-for-releases }

GitHub에서 FastAPI를 "watch"할 수 있습니다 (오른쪽 상단 "watch" 버튼을 클릭): <a href="https://github.com/fastapi/fastapi" class="external-link" target="_blank">https://github.com/fastapi/fastapi</a>. 👀

여기서 "Releases only"를 선택할 수 있습니다.

이렇게하면, **FastAPI** 의 버그 수정 및 새로운 기능의 구현 등의 새로운 릴리즈(새 버전)가 있을 때마다 (이메일) 통지를 받을 수 있습니다.

## 개발자와의 연결 { #connect-with-the-author }

개발자(작성자)인 <a href="https://tiangolo.com" class="external-link" target="_blank">저(Sebastián Ramírez / `tiangolo`)</a>와 연락을 취할 수 있습니다.

여러분은 할 수 있습니다:

* <a href="https://github.com/tiangolo" class="external-link" target="_blank">**GitHub**에서 팔로우하기</a>.
    * 여러분에게 도움이 될 저의 다른 오픈소스 프로젝트를 확인하십시오.
    * 새로운 오픈소스 프로젝트를 만들었을 때 확인하려면 팔로우 하십시오.
* <a href="https://x.com/tiangolo" class="external-link" target="_blank">**X (Twitter)**</a> 또는 <a href="https://fosstodon.org/@tiangolo" class="external-link" target="_blank">Mastodon</a>에서 팔로우하기.
    * FastAPI의 사용 용도를 알려주세요 (그것을 듣는 것을 좋아합니다).
    * 발표나 새로운 툴 출시 소식을 받아보십시오.
    * <a href="https://x.com/fastapi" class="external-link" target="_blank">X(Twitter)에서 @fastapi를 팔로우</a> (별도 계정에서) 할 수 있습니다.
* <a href="https://www.linkedin.com/in/tiangolo/" class="external-link" target="_blank">**LinkedIn**에서 팔로우하기</a>.
    * 새로운 툴의 발표나 출시 소식을 받아보십시오 (단, X (Twitter)를 더 자주 사용합니다 🤷‍♂).
* <a href="https://dev.to/tiangolo" class="external-link" target="_blank">**Dev.to**</a> 또는 <a href="https://medium.com/@tiangolo" class="external-link" target="_blank">**Medium**</a>에서 제가 작성한 내용을 읽어 보십시오 (또는 팔로우).
    * 다른 아이디어와 기사들을 읽고, 제가 만들어왔던 툴에 대해서도 읽으십시오.
    * 새로운 내용을 게시할 때 읽기 위해 팔로우 하십시오.

## **FastAPI**에 대해 트윗하기 { #tweet-about-fastapi }

<a href="https://x.com/compose/tweet?text=I'm loving @fastapi because... https://github.com/fastapi/fastapi" class="external-link" target="_blank">**FastAPI**에 대해 트윗</a> 하고 저와 다른 사람들에게 FastAPI가 마음에 드는 이유를 알려주세요. 🎉

**FastAPI**가 어떻게 사용되고 있는지, 어떤 점이 마음에 들었는지, 어떤 프로젝트/회사에서 사용하고 있는지 등에 대해 듣고 싶습니다.

## FastAPI에 투표하기 { #vote-for-fastapi }

* <a href="https://www.slant.co/options/34241/~fastapi-review" class="external-link" target="_blank">Slant에서 **FastAPI** 에 대해 투표하십시오</a>.
* <a href="https://alternativeto.net/software/fastapi/about/" class="external-link" target="_blank">AlternativeTo에서 **FastAPI** 에 대해 투표하십시오</a>.
* <a href="https://stackshare.io/pypi-fastapi" class="external-link" target="_blank">StackShare에서 **FastAPI**를 사용한다고 표시하세요</a>.

## GitHub에서 질문으로 다른 사람 돕기 { #help-others-with-questions-in-github }

다른 사람들의 질문에 도움을 줄 수 있습니다:

* <a href="https://github.com/fastapi/fastapi/discussions/categories/questions?discussions_q=category%3AQuestions+is%3Aunanswered" class="external-link" target="_blank">GitHub Discussions</a>
* <a href="https://github.com/fastapi/fastapi/issues?q=is%3Aissue+is%3Aopen+sort%3Aupdated-desc+label%3Aquestion+-label%3Aanswered+" class="external-link" target="_blank">GitHub Issues</a>

많은 경우, 여러분은 이미 그 질문에 대한 답을 알고 있을 수도 있습니다. 🤓

만약 많은 사람들의 질문을 도와준다면, 공식적인 [FastAPI 전문가](fastapi-people.md#fastapi-experts){.internal-link target=_blank}가 될 것입니다. 🎉

가장 중요한 점은: 친절하려고 노력하는 것입니다. 사람들은 좌절감을 안고 오며, 많은 경우 최선의 방식으로 질문하지 않을 수도 있습니다. 하지만 최대한 친절하게 대하려고 노력하세요. 🤗

**FastAPI** 커뮤니티의 목표는 친절하고 환영하는 것입니다. 동시에, 괴롭힘이나 무례한 행동을 받아들이지 마세요. 우리는 서로를 돌봐야 합니다.

---

다른 사람들의 질문(디스커션 또는 이슈에서) 해결을 도울 수 있는 방법은 다음과 같습니다.

### 질문 이해하기 { #understand-the-question }

* 질문하는 사람이 가진 **목적**과 사용 사례를 이해할 수 있는지 확인하세요.

* 그런 다음 질문(대부분은 질문입니다)이 **명확**한지 확인하세요.

* 많은 경우 사용자가 상상한 해결책에 대한 질문을 하지만, 더 **좋은** 해결책이 있을 수 있습니다. 문제와 사용 사례를 더 잘 이해하면 더 나은 **대안적인 해결책**을 제안할 수 있습니다.

* 질문을 이해할 수 없다면, 더 **자세한 정보**를 요청하세요.

### 문제 재현하기 { #reproduce-the-problem }

대부분의 경우 그리고 대부분의 질문에서는 질문자의 **원본 코드**와 관련된 내용이 있습니다.

많은 경우, 코드의 일부만 복사해서 올리지만, 그것만으로는 **문제를 재현**하기에 충분하지 않습니다.

* 질문자에게 <a href="https://stackoverflow.com/help/minimal-reproducible-example" class="external-link" target="_blank">최소한의 재현 가능한 예제</a>를 제공해달라고 요청할 수 있습니다. 이렇게 하면 코드를 **복사-붙여넣기**하여 로컬에서 실행하고, 질문자가 보고 있는 것과 동일한 오류나 동작을 확인하거나 사용 사례를 더 잘 이해할 수 있습니다.

* 너그러운 마음이 든다면, 문제 설명만을 기반으로 직접 **예제를 만들어**볼 수도 있습니다. 다만 이는 시간이 많이 걸릴 수 있으므로, 먼저 문제를 명확히 해달라고 요청하는 것이 더 나을 수 있다는 점을 기억하세요.

### 해결책 제안하기 { #suggest-solutions }

* 질문을 충분히 이해한 후에는 가능한 **답변**을 제공할 수 있습니다.

* 많은 경우, 질문자의 **근본적인 문제나 사용 사례**를 이해하는 것이 더 좋습니다. 그들이 시도하는 방법보다 더 나은 해결책이 있을 수 있기 때문입니다.

### 종료 요청하기 { #ask-to-close }

질문자가 답변을 하면, 여러분이 문제를 해결했을 가능성이 높습니다. 축하합니다, **여러분은 영웅입니다**! 🦸

* 이제 문제를 해결했다면, 질문자에게 다음을 요청할 수 있습니다.

    * GitHub Discussions에서: 댓글을 **답변**으로 표시하도록 요청하세요.
    * GitHub Issues에서: 이슈를 **닫아달라고** 요청하세요.

## GitHub 저장소 보기 { #watch-the-github-repository }

GitHub에서 FastAPI를 "watch"할 수 있습니다 (오른쪽 상단 "watch" 버튼을 클릭): <a href="https://github.com/fastapi/fastapi" class="external-link" target="_blank">https://github.com/fastapi/fastapi</a>. 👀

"Releases only" 대신 "Watching"을 선택하면 누군가가 새 이슈나 질문을 만들 때 알림을 받게 됩니다. 또한 새 이슈, 디스커션, PR 등만 알림을 받도록 지정할 수도 있습니다.

그런 다음 이런 질문들을 해결하도록 도와줄 수 있습니다.

## 질문하기 { #ask-questions }

GitHub 저장소에서 <a href="https://github.com/fastapi/fastapi/discussions/new?category=questions" class="external-link" target="_blank">새 질문을 생성</a>할 수 있습니다. 예를 들면 다음과 같습니다:

* **질문**을 하거나 **문제**에 대해 질문합니다.
* 새로운 **기능**을 제안 합니다.

**참고**: 만약 이렇게 한다면, 저는 여러분에게 다른 사람들도 도와달라고 요청할 것입니다. 😉

## Pull Request 리뷰하기 { #review-pull-requests }

다른 사람들이 만든 pull request를 리뷰하는 데 저를 도와줄 수 있습니다.

다시 한번 말하지만, 최대한 친절하게 리뷰해 주세요. 🤗

---

Pull request를 리뷰할 때 고려해야 할 사항과 방법은 다음과 같습니다:

### 문제 이해하기 { #understand-the-problem }

* 먼저, 해당 pull request가 해결하려는 **문제를 이해하는지** 확인하세요. GitHub Discussion 또는 이슈에서 더 긴 논의가 있었을 수도 있습니다.

* Pull request가 실제로 필요하지 않을 가능성도 큽니다. 문제가 **다른 방식**으로 해결될 수 있기 때문입니다. 그런 경우 그 방법을 제안하거나 질문할 수 있습니다.

### 스타일에 너무 신경 쓰지 않기 { #dont-worry-about-style }

* 커밋 메시지 스타일 같은 것에 너무 신경 쓰지 마세요. 저는 커밋을 수동으로 조정해서 squash and merge를 할 것입니다.

* 코드 스타일 규칙도 걱정할 필요 없습니다. 이미 자동화된 도구들이 이를 검사하고 있습니다.

그리고 다른 스타일이나 일관성 관련 필요 사항이 있다면, 제가 직접 요청하거나 필요한 변경 사항을 위에 커밋으로 추가할 것입니다.

### 코드 확인하기 { #check-the-code }

* 코드를 확인하고 읽어서 말이 되는지 보고, **로컬에서 실행**해 실제로 문제가 해결되는지 확인하세요.

* 그런 다음 그렇게 했다고 **댓글**로 남겨 주세요. 그래야 제가 정말로 확인했음을 알 수 있습니다.

/// info | 정보

불행히도, 제가 단순히 여러 개의 승인만으로 PR을 신뢰할 수는 없습니다.

여러 번, 설명이 그럴듯해서인지 3개, 5개 이상의 승인이 달린 PR이 있었지만, 제가 확인해보면 실제로는 깨져 있거나, 버그가 있거나, 주장하는 문제를 해결하지 못하는 경우가 있었습니다. 😅

따라서, 정말로 코드를 읽고 실행한 뒤, 댓글로 확인 내용을 남겨 주는 것이 매우 중요합니다. 🤓

///

* PR을 더 단순하게 만들 수 있다면 그렇게 요청할 수 있지만, 너무 까다로울 필요는 없습니다. 주관적인 견해가 많이 있을 수 있기 때문입니다(그리고 저도 제 견해가 있을 거예요 🙈). 따라서 핵심적인 부분에 집중하는 것이 좋습니다.

### 테스트 { #tests }

* PR에 **테스트**가 포함되어 있는지 확인하는 데 도움을 주세요.

* PR 전에는 테스트가 **실패**하는지 확인하세요. 🚨

* 그런 다음 PR 후에는 테스트가 **통과**하는지 확인하세요. ✅

* 많은 PR에는 테스트가 없습니다. 테스트를 추가하도록 **상기**시켜줄 수도 있고, 직접 테스트를 **제안**할 수도 있습니다. 이는 시간이 가장 많이 드는 것들 중 하나이며, 그 부분을 많이 도와줄 수 있습니다.

* 그리고 시도한 내용을 댓글로 남겨주세요. 그러면 제가 확인했다는 걸 알 수 있습니다. 🤓

## Pull Request 만들기 { #create-a-pull-request }

Pull Requests를 이용하여 소스 코드에 [기여](contributing.md){.internal-link target=_blank}할 수 있습니다. 예를 들면 다음과 같습니다:

* 문서에서 발견한 오타를 수정할 때.
* FastAPI에 대한 글, 비디오, 팟캐스트를 작성했거나 발견했다면 <a href="https://github.com/fastapi/fastapi/edit/master/docs/en/data/external_links.yml" class="external-link" target="_blank">이 파일을 편집</a>하여 공유할 때.
    * 해당 섹션의 시작 부분에 링크를 추가해야 합니다.
* 여러분의 언어로 [문서 번역에](contributing.md#translations){.internal-link target=_blank} 도움을 줄 때.
    * 다른 사람이 작성한 번역을 검토하는 것도 도울 수 있습니다.
* 새로운 문서 섹션을 제안할 때.
* 기존 이슈/버그를 수정할 때.
    * 테스트를 반드시 추가해야 합니다.
* 새로운 기능을 추가할 때.
    * 테스트를 반드시 추가해야 합니다.
    * 관련 문서가 있다면 반드시 추가해야 합니다.

## FastAPI 유지 관리 돕기 { #help-maintain-fastapi }

**FastAPI** 유지를 도와주세요! 🤓

할 일이 많고, 그중 대부분은 **여러분**이 할 수 있습니다.

지금 할 수 있는 주요 작업은:

* [GitHub에서 질문으로 다른 사람 돕기](#help-others-with-questions-in-github){.internal-link target=_blank} (위의 섹션을 참조하세요).
* [Pull Request 리뷰하기](#review-pull-requests){.internal-link target=_blank} (위의 섹션을 참조하세요).

이 두 작업이 **가장 많은 시간을 소모**합니다. 이것이 FastAPI를 유지 관리하는 주요 작업입니다.

이 작업을 도와주신다면, **FastAPI 유지를 돕는 것**이며 FastAPI가 **더 빠르고 더 잘 발전하는 것**을 보장하는 것입니다. 🚀

## 채팅에 참여하기 { #join-the-chat }

👥 <a href="https://discord.gg/VQjSZaeJmf" class="external-link" target="_blank">Discord 채팅 서버</a> 👥 에 참여해서 FastAPI 커뮤니티의 다른 사람들과 어울리세요.

/// tip | 팁

질문은 <a href="https://github.com/fastapi/fastapi/discussions/new?category=questions" class="external-link" target="_blank">GitHub Discussions</a>에서 하세요. [FastAPI Experts](fastapi-people.md#fastapi-experts){.internal-link target=_blank}로부터 도움을 받을 가능성이 훨씬 높습니다.

채팅은 다른 일반적인 대화를 위해서만 사용하세요.

///

### 질문을 위해 채팅을 사용하지 마세요 { #dont-use-the-chat-for-questions }

채팅은 더 많은 "자유로운 대화"를 허용하기 때문에, 너무 일반적인 질문이나 답하기 어려운 질문을 쉽게 할 수 있어 답변을 받지 못할 수도 있다는 점을 기억하세요.

GitHub에서는 템플릿이 올바른 질문을 작성하도록 안내하여 더 쉽게 좋은 답변을 얻거나, 질문하기 전에 스스로 문제를 해결할 수도 있습니다. 그리고 GitHub에서는 시간이 조금 걸리더라도 제가 항상 모든 것에 답하도록 보장할 수 있습니다. 채팅 시스템에서는 제가 개인적으로 그렇게 할 수 없습니다. 😅

채팅 시스템에서의 대화 또한 GitHub만큼 쉽게 검색할 수 없기 때문에, 질문과 답변이 대화 속에서 사라질 수 있습니다. 그리고 GitHub에 있는 것만 [FastAPI Expert](fastapi-people.md#fastapi-experts){.internal-link target=_blank}가 되는 것으로 인정되므로, GitHub에서 더 많은 관심을 받게 될 가능성이 큽니다.

반면, 채팅 시스템에는 수천 명의 사용자가 있으므로, 거의 항상 대화 상대를 찾을 가능성이 높습니다. 😄

## 개발자 스폰서 되기 { #sponsor-the-author }

여러분의 **제품/회사**가 **FastAPI**에 의존하거나 관련되어 있고, FastAPI 사용자를 대상으로 알리고 싶다면 <a href="https://github.com/sponsors/tiangolo" class="external-link" target="_blank">GitHub sponsors</a>를 통해 개발자(저)를 스폰서할 수 있습니다. 티어에 따라 문서에 배지 같은 추가 혜택을 받을 수도 있습니다. 🎁

---

감사합니다! 🚀
