# Тестовый файл LLM { #llm-test-file }

Этот документ проверяет, понимает ли <abbr title="Large Language Model - Большая языковая модель">LLM</abbr>, переводящая документацию, `general_prompt` в `scripts/translate.py` и языковой специфичный промпт в `docs/{language code}/llm-prompt.md`. Языковой специфичный промпт добавляется к `general_prompt`.

Тесты, добавленные здесь, увидят все создатели языковых специфичных промптов.

Использование:

* Подготовьте языковой специфичный промпт — `docs/{language code}/llm-prompt.md`.
* Выполните новый перевод этого документа на нужный целевой язык (см., например, команду `translate-page` в `translate.py`). Это создаст перевод в `docs/{language code}/docs/_llm-test.md`.
* Проверьте, всё ли в порядке в переводе.
* При необходимости улучшите ваш языковой специфичный промпт, общий промпт или английский документ.
* Затем вручную исправьте оставшиеся проблемы в переводе, чтобы он был хорошим.
* Переведите заново, имея хороший перевод на месте. Идеальным результатом будет ситуация, когда LLM больше не вносит изменений в перевод. Это означает, что общий промпт и ваш языковой специфичный промпт настолько хороши, насколько это возможно (иногда он будет делать несколько, казалось бы, случайных изменений, причина в том, что <a href="https://doublespeak.chat/#/handbook#deterministic-output" class="external-link" target="_blank">LLM — недетерминированные алгоритмы</a>).

Тесты:

## Фрагменты кода { #code-snippets }

//// tab | Тест

Это фрагмент кода: `foo`. А это ещё один фрагмент кода: `bar`. И ещё один: `baz quux`.

////

//// tab | Информация

Содержимое фрагментов кода должно оставаться как есть.

См. раздел `### Content of code snippets` в общем промпте в `scripts/translate.py`.

////

## Кавычки { #quotes }

//// tab | Тест

Вчера мой друг написал: "Если вы написали incorrectly правильно, значит вы написали это неправильно". На что я ответил: "Верно, но 'incorrectly' — это неправильно, а не '"incorrectly"'".

/// note | Примечание

LLM, вероятно, переведёт это неправильно. Интересно лишь то, сохранит ли она фиксированный перевод при повторном переводе.

///

////

//// tab | Информация

Автор промпта может выбрать, хочет ли он преобразовывать нейтральные кавычки в типографские. Допускается оставить их как есть.

См., например, раздел `### Quotes` в `docs/de/llm-prompt.md`.

////

## Кавычки во фрагментах кода { #quotes-in-code-snippets }

//// tab | Тест

`pip install "foo[bar]"`

Примеры строковых литералов во фрагментах кода: `"this"`, `'that'`.

Сложный пример строковых литералов во фрагментах кода: `f"I like {'oranges' if orange else "apples"}"`

Хардкор: `Yesterday, my friend wrote: "If you spell incorrectly correctly, you have spelled it incorrectly". To which I answered: "Correct, but 'incorrectly' is incorrectly not '"incorrectly"'"`

////

//// tab | Информация

... Однако кавычки внутри фрагментов кода должны оставаться как есть.

////

## Блоки кода { #code-blocks }

//// tab | Тест

Пример кода Bash...

```bash
# Вывести приветствие вселенной
echo "Hello universe"
```

...и пример вывода в консоли...

```console
$ <font color="#4E9A06">fastapi</font> run <u style="text-decoration-style:solid">main.py</u>
<span style="background-color:#009485"><font color="#D3D7CF"> FastAPI </font></span>  Starting server
        Searching for package file structure
```

...и ещё один пример вывода в консоли...

```console
// Создать директорию "Code"
$ mkdir code
// Перейти в эту директорию
$ cd code
```

...и пример кода на Python...

```Python
wont_work()  # Это не сработает 😱
works(foo="bar")  # Это работает 🎉
```

...и на этом всё.

////

//// tab | Информация

Код в блоках кода не должен изменяться, за исключением комментариев.

См. раздел `### Content of code blocks` в общем промпте в `scripts/translate.py`.

////

## Вкладки и цветные блоки { #tabs-and-colored-boxes }

//// tab | Тест

/// info | Информация
Некоторый текст
///

/// note | Примечание
Некоторый текст
///

/// note | Технические подробности
Некоторый текст
///

/// check | Проверка
Некоторый текст
///

/// tip | Совет
Некоторый текст
///

/// warning | Предупреждение
Некоторый текст
///

/// danger | Опасность
Некоторый текст
///

////

//// tab | Информация

Для вкладок и блоков `Info`/`Note`/`Warning`/и т.п. нужно добавить перевод их заголовка после вертикальной черты (`|`).

См. разделы `### Special blocks` и `### Tab blocks` в общем промпте в `scripts/translate.py`.

////

## Веб- и внутренние ссылки { #web-and-internal-links }

//// tab | Тест

Текст ссылок должен переводиться, адрес ссылки не должен изменяться:

* [Ссылка на заголовок выше](#code-snippets)
* [Внутренняя ссылка](index.md#installation){.internal-link target=_blank}
* <a href="https://sqlmodel.tiangolo.com/" class="external-link" target="_blank">Внешняя ссылка</a>
* <a href="https://fastapi.tiangolo.com/css/styles.css" class="external-link" target="_blank">Ссылка на стиль</a>
* <a href="https://fastapi.tiangolo.com/js/logic.js" class="external-link" target="_blank">Ссылка на скрипт</a>
* <a href="https://fastapi.tiangolo.com/img/foo.jpg" class="external-link" target="_blank">Ссылка на изображение</a>

Текст ссылок должен переводиться, адрес ссылки должен указывать на перевод:

* <a href="https://fastapi.tiangolo.com/ru/" class="external-link" target="_blank">Ссылка на FastAPI</a>

////

//// tab | Информация

Ссылки должны переводиться, но их адреса не должны изменяться. Исключение — абсолютные ссылки на страницы документации FastAPI. В этом случае ссылка должна вести на перевод.

См. раздел `### Links` в общем промпте в `scripts/translate.py`.

////

## HTML-элементы "abbr" { #html-abbr-elements }

//// tab | Тест

Вот некоторые элементы, обёрнутые в HTML-элементы "abbr" (часть выдумана):

### abbr даёт полную расшифровку { #the-abbr-gives-a-full-phrase }

* <abbr title="Getting Things Done - Как привести дела в порядок">GTD</abbr>
* <abbr title="less than - меньше чем"><code>lt</code></abbr>
* <abbr title="XML Web Token - XML веб‑токен">XWT</abbr>
* <abbr title="Parallel Server Gateway Interface - Параллельный серверный интерфейс шлюза">PSGI</abbr>

### abbr даёт объяснение { #the-abbr-gives-an-explanation }

* <abbr title="Группа машин, которые настроены на соединение и совместную работу определённым образом.">кластер</abbr>
* <abbr title="Метод машинного обучения, который использует искусственные нейронные сети с многочисленными скрытыми слоями между входным и выходным слоями, тем самым формируя сложную внутреннюю структуру">Глубокое обучение</abbr>

### abbr даёт полную расшифровку и объяснение { #the-abbr-gives-a-full-phrase-and-an-explanation }

* <abbr title="Mozilla Developer Network - Сеть разработчиков Mozilla: документация для разработчиков, созданная командой Firefox">MDN</abbr>
* <abbr title="Input/Output - Ввод/Вывод: чтение или запись на диск, сетевое взаимодействие.">I/O</abbr>.

////

//// tab | Информация

Атрибуты "title" элементов "abbr" переводятся по определённым правилам.

Переводы могут добавлять свои собственные элементы "abbr", которые LLM не должна удалять. Например, чтобы объяснить английские слова.

См. раздел `### HTML abbr elements` в общем промпте в `scripts/translate.py`.

////

## Заголовки { #headings }

//// tab | Тест

### Разработка веб‑приложения — руководство { #develop-a-webapp-a-tutorial }

Привет.

### Аннотации типов и -аннотации { #type-hints-and-annotations }

Снова привет.

### Супер- и подклассы { #super-and-subclasses }

Снова привет.

////

//// tab | Информация

Единственное жёсткое правило для заголовков — LLM должна оставить часть хеша в фигурных скобках без изменений, чтобы ссылки не ломались.

См. раздел `### Headings` в общем промпте в `scripts/translate.py`.

Для некоторых языковых инструкций см., например, раздел `### Headings` в `docs/de/llm-prompt.md`.

////

## Термины, используемые в документации { #terms-used-in-the-docs }

//// tab | Тест

* вы
* ваш

* например
* и т.д.

* `foo` как `int`
* `bar` как `str`
* `baz` как `list`

* Учебник — Руководство пользователя
* Расширенное руководство пользователя
* Документация по SQLModel
* Документация API
* Автоматическая документация

* Наука о данных
* Глубокое обучение
* Машинное обучение
* Внедрение зависимостей
* Аутентификация HTTP Basic
* HTTP Digest
* формат ISO
* стандарт JSON Schema
* JSON-схема
* определение схемы
* password flow
* Мобильный

* устаревший
* спроектированный
* некорректный
* на лету
* стандарт
* по умолчанию
* чувствительный к регистру
* нечувствительный к регистру

* обслуживать приложение
* отдавать страницу

* приложение
* приложение

* HTTP-запрос
* HTTP-ответ
* ответ с ошибкой

* операция пути
* декоратор операции пути
* функция-обработчик пути

* тело
* тело запроса
* тело ответа
* JSON-тело
* тело формы
* тело файла
* тело функции

* параметр
* body-параметр
* path-параметр
* query-параметр
* cookie-параметр
* параметр заголовка
* параметр формы
* параметр функции

* событие
* событие запуска
* запуск сервера
* событие остановки
* событие lifespan

* обработчик
* обработчик события
* обработчик исключений
* обрабатывать

* модель
* Pydantic-модель
* модель данных
* модель базы данных
* модель формы
* объект модели

* класс
* базовый класс
* родительский класс
* подкласс
* дочерний класс
* родственный класс
* метод класса

* заголовок
* HTTP-заголовки
* заголовок авторизации
* заголовок `Authorization`
* заголовок `Forwarded`

* система внедрения зависимостей
* зависимость
* зависимый объект
* зависимый

* ограниченный вводом/выводом
* ограниченный процессором
* конкурентность
* параллелизм
* многопроцессность

* переменная окружения
* переменная окружения
* `PATH`
* переменная `PATH`

* аутентификация
* провайдер аутентификации
* авторизация
* форма авторизации
* провайдер авторизации
* пользователь аутентифицируется
* система аутентифицирует пользователя

* CLI
* интерфейс командной строки

* сервер
* клиент

* облачный провайдер
* облачный сервис

* разработка
* этапы разработки

* dict
* словарь
* перечисление
* enum
* член перечисления

* кодировщик
* декодировщик
* кодировать
* декодировать

* исключение
* вызвать

* выражение
* оператор

* фронтенд
* бэкенд

* обсуждение на GitHub
* Issue на GitHub (тикет/обращение)

* производительность
* оптимизация производительности

* тип возвращаемого значения
* возвращаемое значение

* безопасность
* схема безопасности

* задача
* фоновая задача
* функция задачи

* шаблон
* шаблонизатор

* аннотация типов
* аннотация типов

* воркер сервера
* воркер Uvicorn
* воркер Gunicorn
* воркер-процесс
* класс воркера
* рабочая нагрузка

* деплой
* развернуть

* SDK
* набор средств разработки ПО

* `APIRouter`
* `requirements.txt`
* токен Bearer
* несовместимое изменение
* баг
* кнопка
* вызываемый объект
* код
* коммит
* менеджер контекста
* корутина
* сессия базы данных
* диск
* домен
* движок
* фиктивный X
* метод HTTP GET
* элемент
* библиотека
* lifespan
* блокировка
* middleware (Промежуточный слой)
* мобильное приложение
* модуль
* монтирование
* сеть
* origin (источник)
* переопределение
* полезная нагрузка
* процессор
* свойство
* прокси
* пулл-реквест (запрос на изменение)
* запрос
* ОЗУ
* удалённая машина
* статус-код
* строка
* тег
* веб‑фреймворк
* подстановочный знак
* вернуть
* валидировать

////

//// tab | Информация

Это неполный и ненормативный список (в основном) технических терминов, встречающихся в документации. Он может помочь автору промпта понять, по каким терминам LLM нужна подсказка. Например, когда она продолжает возвращать действительно хороший перевод к неоптимальному. Или когда у неё возникают проблемы со склонением/спряжением термина на вашем языке.

См., например, раздел `### List of English terms and their preferred German translations` в `docs/de/llm-prompt.md`.

////
