# Возврат ответа напрямую { #return-a-response-directly }

Когда вы создаёте **FastAPI** *операцию пути*, вы можете возвращать из неё любые данные: `dict`, `list`, Pydantic-модель, модель базы данных и т.д.

По умолчанию **FastAPI** автоматически преобразует возвращаемое значение в JSON с помощью `jsonable_encoder`, как описано в [JSON кодировщик](../tutorial/encoder.md){.internal-link target=_blank}.

Затем "под капотом" эти данные, совместимые с JSON (например `dict`), помещаются в `JSONResponse`, который используется для отправки ответа клиенту.

Но вы можете возвращать `JSONResponse` напрямую из ваших *операций пути*.

Это может быть полезно, например, если нужно вернуть пользовательские HTTP-заголовки или cookie.

## Возврат `Response` { #return-a-response }

На самом деле, вы можете возвращать любой объект `Response` или его подкласс.

/// tip | Подсказка

`JSONResponse` сам по себе является подклассом `Response`.

///

И когда вы возвращаете `Response`, **FastAPI** передаст его напрямую.

Это не приведет к преобразованию данных с помощью Pydantic-моделей, содержимое не будет преобразовано в какой-либо тип и т.д.

Это даёт вам большую гибкость. Вы можете возвращать любые типы данных, переопределять любые объявления или валидацию данных и т.д.

## Использование `jsonable_encoder` в `Response` { #using-the-jsonable-encoder-in-a-response }

Поскольку **FastAPI** не изменяет объект `Response`, который вы возвращаете, вы должны убедиться, что его содержимое готово к отправке.

Например, вы не можете поместить Pydantic-модель в `JSONResponse`, не преобразовав её сначала в `dict` с помощью преобразования всех типов данных (таких как `datetime`, `UUID` и т.д.) в совместимые с JSON типы.

В таких случаях вы можете использовать `jsonable_encoder` для преобразования данных перед передачей их в ответ:

{* ../../docs_src/response_directly/tutorial001.py hl[6:7,21:22] *}

/// note | Технические детали

Вы также можете использовать `from starlette.responses import JSONResponse`.

**FastAPI** предоставляет `starlette.responses` через `fastapi.responses` просто для вашего удобства, как разработчика. Но большинство доступных Response-классов поступают напрямую из Starlette.

///

## Возврат пользовательского `Response` { #returning-a-custom-response }

Пример выше показывает все необходимые части, но он пока не очень полезен, так как вы могли бы просто вернуть `item` напрямую, и **FastAPI** поместил бы его в `JSONResponse`, преобразовав в `dict` и т.д. Всё это происходит по умолчанию.

Теперь давайте посмотрим, как можно использовать это для возврата пользовательского ответа.

Допустим, вы хотите вернуть ответ в формате <a href="https://en.wikipedia.org/wiki/XML" class="external-link" target="_blank">XML</a>.

Вы можете поместить ваш XML-контент в строку, поместить её в `Response` и вернуть:

{* ../../docs_src/response_directly/tutorial002.py hl[1,18] *}

## Примечания { #notes }

Когда вы возвращаете объект `Response` напрямую, его данные не валидируются, не преобразуются (не сериализуются) и не документируются автоматически.

Но вы всё равно можете задокументировать это, как описано в [Дополнительные ответы в OpenAPI](additional-responses.md){.internal-link target=_blank}.

В следующих разделах вы увидите, как использовать/объявлять такие кастомные `Response`, при этом сохраняя автоматическое преобразование данных, документацию и т.д.
