/***************************************************************************
 * Copyright (c) Johan Mabille, Sylvain Corlay and Wolf Vollprecht          *
 * Copyright (c) QuantStack                                                 *
 *                                                                          *
 * Distributed under the terms of the BSD 3-Clause License.                 *
 *                                                                          *
 * The full license is in the file LICENSE, distributed with this software. *
 ****************************************************************************/
// This file is generated from test/files/cppy_source/test_extended_broadcast_view.cppy by preprocess.py!
// Warning: This file should not be modified directly! Instead, modify the `*.cppy` file.


#include <algorithm>

#include "xtensor/containers/xarray.hpp"
#include "xtensor/containers/xfixed.hpp"
#include "xtensor/containers/xtensor.hpp"
#include "xtensor/core/xnoalias.hpp"
#include "xtensor/views/xstrided_view.hpp"
#include "xtensor/views/xview.hpp"

#include "test_common_macros.hpp"

namespace xt
{
    using namespace xt::placeholders;

    /*py
    a = np.arange(35, dtype=np.float64).reshape(5, 7)
    */
    TEST(xtest_extended, negative_slices_twod)
    {
        // py_a
        xarray<double> py_a = {
            {0., 1., 2., 3., 4., 5., 6.},
            {7., 8., 9., 10., 11., 12., 13.},
            {14., 15., 16., 17., 18., 19., 20.},
            {21., 22., 23., 24., 25., 26., 27.},
            {28., 29., 30., 31., 32., 33., 34.}
        };
        // py_av0 = a[:-2, ::-1]
        xarray<double> py_av0 = {
            {6., 5., 4., 3., 2., 1., 0.},
            {13., 12., 11., 10., 9., 8., 7.},
            {20., 19., 18., 17., 16., 15., 14.}
        };
        auto av0 = xt::strided_view(py_a, {_r | _ | -2, _r | _ | _ | -1});
        EXPECT_EQ(av0, py_av0);
        // py_av1 = a[::-1, ::-1]
        xarray<double> py_av1 = {
            {34., 33., 32., 31., 30., 29., 28.},
            {27., 26., 25., 24., 23., 22., 21.},
            {20., 19., 18., 17., 16., 15., 14.},
            {13., 12., 11., 10., 9., 8., 7.},
            {6., 5., 4., 3., 2., 1., 0.}
        };
        auto av1 = xt::strided_view(py_a, {_r | _ | _ | -1, _r | _ | _ | -1});
        EXPECT_EQ(av1, py_av1);
        // py_av2 = a[1:-3, -3:2:-1]
        xarray<double> py_av2 = {{11., 10.}};
        auto av2 = xt::strided_view(py_a, {_r | 1 | -3, _r | -3 | 2 | -1});
        EXPECT_EQ(av2, py_av2);
        // py_av3 = a[-1:-4:-1, -3:1:-2]
        xarray<double> py_av3 = {{32., 30.}, {25., 23.}, {18., 16.}};
        auto av3 = xt::strided_view(py_a, {_r | -1 | -4 | -1, _r | -3 | 1 | -2});
        EXPECT_EQ(av3, py_av3);
        auto av4 = xt::strided_view(py_a, {_r | -3 | -5, _r | -3 | 10});
        EXPECT_EQ(av4.size(), size_t(0));
        // py_av5 = a[-5:-2, -3:10]
        xarray<double> py_av5 = {{4., 5., 6.}, {11., 12., 13.}, {18., 19., 20.}};
        auto av5 = xt::strided_view(py_a, {_r | -5 | -2, _r | -3 | 10});
        EXPECT_EQ(av5, py_av5);
    }

    /*py
    a0 = np.arange(35).reshape(5, 7)
    a = np.copy(a0)
    a[0:-2] += a[:3:-1]
    at = np.copy(a)
    at[::-2] += at[::2]
    */
    TEST(xtest_extended, negative_slices_math)
    {
        // py_a0
        xarray<long> py_a0 = {
            {0, 1, 2, 3, 4, 5, 6},
            {7, 8, 9, 10, 11, 12, 13},
            {14, 15, 16, 17, 18, 19, 20},
            {21, 22, 23, 24, 25, 26, 27},
            {28, 29, 30, 31, 32, 33, 34}
        };
        strided_view(py_a0, {_r | 0 | -2}) += strided_view(py_a0, {{_r | _ | 3 | -1}});
        // py_a
        xarray<long> py_a = {
            {28, 30, 32, 34, 36, 38, 40},
            {35, 37, 39, 41, 43, 45, 47},
            {42, 44, 46, 48, 50, 52, 54},
            {21, 22, 23, 24, 25, 26, 27},
            {28, 29, 30, 31, 32, 33, 34}
        };
        EXPECT_EQ(py_a0, py_a);
        strided_view(py_a0, {_r | _ | _ | -2}) += strided_view(py_a0, {_r | _ | _ | 2});
        // py_at
        xarray<long> py_at = {
            {56, 59, 62, 65, 68, 71, 74},
            {35, 37, 39, 41, 43, 45, 47},
            {84, 88, 92, 96, 100, 104, 108},
            {21, 22, 23, 24, 25, 26, 27},
            {56, 59, 62, 65, 68, 71, 74}
        };
        EXPECT_EQ(py_a0, py_at);
    }

    /*py
    a1 = np.arange(35).reshape(5, 1, 7)
    a2 = np.copy(a).reshape(1, 5, 1, 7)
    a3 = np.array([6,2,3,5,1]).reshape(1, 5, 1, 1)
    a1_a2 = a1 + a2
    b1 = np.arange(7)
    b1_a1 = a1 + b1
    b2 = np.copy(b1).reshape(1, 1, 1, 7)
    a1_b2 = a1 + b2
    b3 = np.random.random((2, 5, 4, 7))
    a2_b3 = a2 + b3
    */
    TEST(xtest_extended, broadcasting)
    {
        // py_a1
        xarray<long> py_a1 = {
            {{0, 1, 2, 3, 4, 5, 6}},

            {{7, 8, 9, 10, 11, 12, 13}},

            {{14, 15, 16, 17, 18, 19, 20}},

            {{21, 22, 23, 24, 25, 26, 27}},

            {{28, 29, 30, 31, 32, 33, 34}}
        };
        // py_a2
        xarray<long> py_a2 = {
            {{{28, 30, 32, 34, 36, 38, 40}},

             {{35, 37, 39, 41, 43, 45, 47}},

             {{42, 44, 46, 48, 50, 52, 54}},

             {{21, 22, 23, 24, 25, 26, 27}},

             {{28, 29, 30, 31, 32, 33, 34}}}
        };
        // py_b1
        xarray<long> py_b1 = {0, 1, 2, 3, 4, 5, 6};
        // py_b2
        xarray<long> py_b2 = {{{{0, 1, 2, 3, 4, 5, 6}}}};
        // py_b3
        xarray<double> py_b3 = {
            {{{0.3745401188473625,
               0.9507143064099162,
               0.7319939418114051,
               0.5986584841970366,
               0.1560186404424365,
               0.1559945203362026,
               0.0580836121681995},
              {0.8661761457749352,
               0.6011150117432088,
               0.7080725777960455,
               0.0205844942958024,
               0.9699098521619943,
               0.8324426408004217,
               0.2123391106782762},
              {0.1818249672071006,
               0.1834045098534338,
               0.3042422429595377,
               0.5247564316322378,
               0.4319450186421158,
               0.2912291401980419,
               0.6118528947223795},
              {0.1394938606520418,
               0.2921446485352182,
               0.3663618432936917,
               0.4560699842170359,
               0.7851759613930136,
               0.1996737821583597,
               0.5142344384136116}},

             {{0.5924145688620425,
               0.0464504127199977,
               0.6075448519014384,
               0.1705241236872915,
               0.0650515929852795,
               0.9488855372533332,
               0.9656320330745594},
              {0.8083973481164611,
               0.3046137691733707,
               0.0976721140063839,
               0.6842330265121569,
               0.4401524937396013,
               0.1220382348447788,
               0.4951769101112702},
              {0.0343885211152184,
               0.9093204020787821,
               0.2587799816000169,
               0.662522284353982,
               0.311711076089411,
               0.5200680211778108,
               0.5467102793432796},
              {0.184854455525527,
               0.9695846277645586,
               0.7751328233611146,
               0.9394989415641891,
               0.8948273504276488,
               0.5978999788110851,
               0.9218742350231168}},

             {{0.0884925020519195,
               0.1959828624191452,
               0.0452272889105381,
               0.3253303307632643,
               0.388677289689482,
               0.2713490317738959,
               0.8287375091519293},
              {0.3567533266935893,
               0.2809345096873808,
               0.5426960831582485,
               0.1409242249747626,
               0.8021969807540397,
               0.0745506436797708,
               0.9868869366005173},
              {0.7722447692966574,
               0.1987156815341724,
               0.0055221171236024,
               0.8154614284548342,
               0.7068573438476171,
               0.7290071680409873,
               0.7712703466859457},
              {0.0740446517340904,
               0.3584657285442726,
               0.1158690595251297,
               0.8631034258755935,
               0.6232981268275579,
               0.3308980248526492,
               0.0635583502860236}},

             {{0.3109823217156622,
               0.325183322026747,
               0.7296061783380641,
               0.6375574713552131,
               0.8872127425763265,
               0.4722149251619493,
               0.1195942459383017},
              {0.713244787222995,
               0.7607850486168974,
               0.5612771975694962,
               0.770967179954561,
               0.4937955963643907,
               0.5227328293819941,
               0.4275410183585496},
              {0.0254191267440952,
               0.1078914269933045,
               0.0314291856867343,
               0.6364104112637804,
               0.3143559810763267,
               0.5085706911647028,
               0.907566473926093},
              {0.2492922291488749,
               0.4103829230356297,
               0.7555511385430487,
               0.2287981654916225,
               0.076979909828793,
               0.289751452913768,
               0.1612212872540044}},

             {{0.9296976523425731,
               0.808120379564417,
               0.6334037565104235,
               0.8714605901877177,
               0.8036720768991145,
               0.1865700588860358,
               0.8925589984899778},
              {0.5393422419156507,
               0.8074401551640625,
               0.8960912999234932,
               0.3180034749718639,
               0.1100519245276768,
               0.2279351625419417,
               0.4271077886262563},
              {0.8180147659224931,
               0.8607305832563434,
               0.0069521305311907,
               0.5107473025775657,
               0.417411003148779,
               0.2221078104707302,
               0.1198653673336828},
              {0.337615171403628,
               0.9429097039125192,
               0.3232029320207552,
               0.5187906217433661,
               0.7030189588951778,
               0.363629602379294,
               0.9717820827209607}}},


            {{{0.9624472949421112,
               0.2517822958253642,
               0.4972485058923855,
               0.3008783098167697,
               0.2848404943774676,
               0.0368869473545328,
               0.6095643339798968},
              {0.5026790232288615,
               0.0514787512499894,
               0.2786464642366114,
               0.9082658859666537,
               0.2395618906669724,
               0.1448948720912231,
               0.489452760277563},
              {0.9856504541106007,
               0.2420552715115004,
               0.6721355474058786,
               0.7616196153287176,
               0.2376375439923997,
               0.7282163486118596,
               0.3677831327192532},
              {0.6323058305935795,
               0.6335297107608947,
               0.5357746840747585,
               0.0902897700544083,
               0.835302495589238,
               0.3207800649717358,
               0.1865185103998542}},

             {{0.0407751415547639,
               0.5908929431882418,
               0.6775643618422824,
               0.0165878289278562,
               0.512093058299281,
               0.226495775197938,
               0.6451727904094499},
              {0.1743664290049914,
               0.690937738102466,
               0.3867353463005374,
               0.9367299887367345,
               0.1375209441459933,
               0.3410663510502585,
               0.1134735212405891},
              {0.9246936182785628,
               0.877339353380981,
               0.2579416277151556,
               0.659984046034179,
               0.8172222002012158,
               0.5552008115994623,
               0.5296505783560065},
              {0.2418522909004517,
               0.0931027678058992,
               0.8972157579533268,
               0.9004180571633305,
               0.6331014572732679,
               0.3390297910487007,
               0.3492095746126609}},

             {{0.7259556788702394,
               0.8971102599525771,
               0.8870864242651173,
               0.7798755458576239,
               0.6420316461542878,
               0.0841399649950488,
               0.1616287140946138},
              {0.8985541885270792,
               0.6064290596595899,
               0.0091970516166296,
               0.1014715428660321,
               0.6635017691080558,
               0.0050615838462187,
               0.1608080514174987},
              {0.5487337893665861,
               0.6918951976926933,
               0.6519612595026005,
               0.2242693094605598,
               0.7121792213475359,
               0.2372490874968001,
               0.3253996981592677},
              {0.7464914051180241,
               0.6496328990472147,
               0.8492234104941779,
               0.6576128923003434,
               0.5683086033354716,
               0.0936747678280925,
               0.3677158030594335}},

             {{0.2652023676817254,
               0.2439896433790836,
               0.9730105547524456,
               0.3930977246667604,
               0.8920465551771133,
               0.6311386259972629,
               0.7948113035416484},
              {0.5026370931051921,
               0.5769038846263591,
               0.4925176938188639,
               0.1952429877980445,
               0.7224521152615053,
               0.2807723624408558,
               0.0243159664314538},
              {0.6454722959071678,
               0.1771106794070489,
               0.9404585843529143,
               0.9539285770025874,
               0.9148643902204485,
               0.3701587002554444,
               0.0154566165288674},
              {0.9283185625877254,
               0.4281841483173143,
               0.9666548190436696,
               0.9636199770892528,
               0.8530094554673601,
               0.2944488920695857,
               0.3850977286019253}},

             {{0.8511366715168569,
               0.3169220051562777,
               0.1694927466860925,
               0.5568012624583502,
               0.936154774160781,
               0.696029796674973,
               0.570061170089365},
              {0.0971764937707685,
               0.6150072266991697,
               0.9900538501042633,
               0.140084015236524,
               0.5183296523637367,
               0.8773730719279554,
               0.7407686177542044},
              {0.697015740995268,
               0.7024840839871093,
               0.3594911512197552,
               0.2935918442644934,
               0.8093611554785136,
               0.8101133946791808,
               0.8670723185801037},
              {0.9132405525564713,
               0.5113423988609378,
               0.5015162946871996,
               0.7982951789667752,
               0.6499639307777652,
               0.7019668772577033,
               0.795792669436101}}}
        };
        xt::xarray<long> a1_a2 = py_a1 + py_a2;
        // py_a1_a2
        xarray<long> py_a1_a2 = {
            {{{28, 31, 34, 37, 40, 43, 46}},

             {{42, 45, 48, 51, 54, 57, 60}},

             {{56, 59, 62, 65, 68, 71, 74}},

             {{42, 44, 46, 48, 50, 52, 54}},

             {{56, 58, 60, 62, 64, 66, 68}}}
        };
        EXPECT_EQ(a1_a2, py_a1_a2);

        xt::xarray<long> b1_a1 = py_b1 + py_a1;
        // py_b1_a1
        xarray<long> py_b1_a1 = {
            {{0, 2, 4, 6, 8, 10, 12}},

            {{7, 9, 11, 13, 15, 17, 19}},

            {{14, 16, 18, 20, 22, 24, 26}},

            {{21, 23, 25, 27, 29, 31, 33}},

            {{28, 30, 32, 34, 36, 38, 40}}
        };
        EXPECT_EQ(b1_a1, py_b1_a1);

        xt::xarray<long> a1_b2 = py_a1 + py_b2;
        // py_a1_b2
        xarray<long> py_a1_b2 = {
            {{{0, 2, 4, 6, 8, 10, 12}},

             {{7, 9, 11, 13, 15, 17, 19}},

             {{14, 16, 18, 20, 22, 24, 26}},

             {{21, 23, 25, 27, 29, 31, 33}},

             {{28, 30, 32, 34, 36, 38, 40}}}
        };
        EXPECT_EQ(a1_b2, py_a1_b2);

        xt::xarray<double> a2_b3 = xt::cast<double>(py_a2) + py_b3;
        // py_a2_b3
        xarray<double> py_a2_b3 = {
            {{{28.374540118847364,
               30.950714306409917,
               32.7319939418114,
               34.59865848419704,
               36.15601864044244,
               38.1559945203362,
               40.0580836121682},
              {28.866176145774936,
               30.601115011743207,
               32.708072577796045,
               34.020584494295804,
               36.969909852162,
               38.83244264080042,
               40.21233911067828},
              {28.1818249672071,
               30.183404509853435,
               32.30424224295954,
               34.52475643163224,
               36.43194501864212,
               38.29122914019804,
               40.61185289472238},
              {28.139493860652042,
               30.292144648535217,
               32.36636184329369,
               34.45606998421704,
               36.785175961393016,
               38.19967378215836,
               40.51423443841361}},

             {{35.59241456886204,
               37.04645041272,
               39.60754485190144,
               41.170524123687294,
               43.06505159298528,
               45.94888553725333,
               47.965632033074556},
              {35.80839734811646,
               37.30461376917337,
               39.097672114006386,
               41.68423302651216,
               43.4401524937396,
               45.12203823484478,
               47.49517691011127},
              {35.03438852111522,
               37.909320402078784,
               39.258779981600014,
               41.66252228435398,
               43.31171107608941,
               45.52006802117781,
               47.54671027934328},
              {35.184854455525524,
               37.96958462776456,
               39.77513282336111,
               41.93949894156419,
               43.89482735042765,
               45.597899978811085,
               47.92187423502312}},

             {{42.08849250205192,
               44.19598286241914,
               46.04522728891054,
               48.325330330763265,
               50.38867728968948,
               52.271349031773894,
               54.82873750915193},
              {42.35675332669359,
               44.280934509687384,
               46.54269608315825,
               48.14092422497476,
               50.80219698075404,
               52.07455064367977,
               54.98688693660052},
              {42.772244769296655,
               44.198715681534175,
               46.005522117123604,
               48.81546142845483,
               50.70685734384762,
               52.72900716804099,
               54.771270346685945},
              {42.07404465173409,
               44.358465728544274,
               46.11586905952513,
               48.86310342587559,
               50.62329812682756,
               52.33089802485265,
               54.06355835028602}},

             {{21.310982321715663,
               22.325183322026746,
               23.729606178338063,
               24.637557471355212,
               25.887212742576327,
               26.47221492516195,
               27.119594245938302},
              {21.713244787222994,
               22.760785048616896,
               23.561277197569495,
               24.77096717995456,
               25.49379559636439,
               26.522732829381994,
               27.42754101835855},
              {21.025419126744094,
               22.107891426993305,
               23.031429185686733,
               24.636410411263782,
               25.314355981076325,
               26.508570691164703,
               27.907566473926092},
              {21.249292229148875,
               22.41038292303563,
               23.755551138543048,
               24.22879816549162,
               25.076979909828793,
               26.28975145291377,
               27.161221287254005}},

             {{28.929697652342572,
               29.808120379564418,
               30.633403756510422,
               31.871460590187716,
               32.80367207689911,
               33.18657005888603,
               34.892558998489974},
              {28.53934224191565,
               29.807440155164063,
               30.896091299923494,
               31.318003474971864,
               32.110051924527674,
               33.22793516254194,
               34.42710778862626},
              {28.81801476592249,
               29.860730583256345,
               30.00695213053119,
               31.510747302577567,
               32.41741100314878,
               33.22210781047073,
               34.11986536733368},
              {28.337615171403627,
               29.94290970391252,
               30.323202932020756,
               31.518790621743367,
               32.70301895889518,
               33.36362960237929,
               34.971782082720964}}},


            {{{28.962447294942113,
               30.251782295825365,
               32.49724850589239,
               34.30087830981677,
               36.28484049437747,
               38.03688694735453,
               40.6095643339799},
              {28.50267902322886,
               30.051478751249988,
               32.27864646423661,
               34.90826588596666,
               36.23956189066697,
               38.14489487209122,
               40.489452760277565},
              {28.9856504541106,
               30.2420552715115,
               32.67213554740588,
               34.76161961532872,
               36.2376375439924,
               38.72821634861186,
               40.367783132719254},
              {28.63230583059358,
               30.633529710760893,
               32.53577468407476,
               34.09028977005441,
               36.83530249558924,
               38.320780064971736,
               40.18651851039986}},

             {{35.04077514155476,
               37.590892943188244,
               39.67756436184228,
               41.016587828927854,
               43.51209305829928,
               45.22649577519794,
               47.64517279040945},
              {35.17436642900499,
               37.69093773810246,
               39.38673534630054,
               41.93672998873674,
               43.13752094414599,
               45.34106635105026,
               47.113473521240586},
              {35.92469361827856,
               37.87733935338098,
               39.257941627715155,
               41.65998404603418,
               43.817222200201215,
               45.55520081159946,
               47.529650578356005},
              {35.241852290900454,
               37.0931027678059,
               39.897215757953326,
               41.90041805716333,
               43.63310145727327,
               45.3390297910487,
               47.34920957461266}},

             {{42.72595567887024,
               44.897110259952576,
               46.88708642426512,
               48.77987554585762,
               50.64203164615429,
               52.084139964995046,
               54.16162871409461},
              {42.89855418852708,
               44.60642905965959,
               46.00919705161663,
               48.10147154286603,
               50.66350176910806,
               52.00506158384622,
               54.1608080514175},
              {42.54873378936659,
               44.691895197692695,
               46.6519612595026,
               48.22426930946056,
               50.71217922134753,
               52.2372490874968,
               54.325399698159266},
              {42.74649140511802,
               44.64963289904721,
               46.849223410494176,
               48.65761289230034,
               50.568308603335474,
               52.09367476782809,
               54.36771580305943}},

             {{21.265202367681724,
               22.243989643379084,
               23.973010554752445,
               24.39309772466676,
               25.892046555177114,
               26.631138625997263,
               27.79481130354165},
              {21.502637093105193,
               22.576903884626358,
               23.492517693818865,
               24.195242987798043,
               25.722452115261504,
               26.280772362440857,
               27.024315966431455},
              {21.64547229590717,
               22.17711067940705,
               23.940458584352914,
               24.953928577002586,
               25.914864390220448,
               26.370158700255445,
               27.015456616528866},
              {21.928318562587727,
               22.428184148317314,
               23.96665481904367,
               24.96361997708925,
               25.85300945546736,
               26.294448892069585,
               27.385097728601924}},

             {{28.85113667151686,
               29.31692200515628,
               30.169492746686092,
               31.55680126245835,
               32.936154774160784,
               33.69602979667497,
               34.57006117008937},
              {28.097176493770768,
               29.61500722669917,
               30.990053850104264,
               31.140084015236525,
               32.51832965236374,
               33.877373071927956,
               34.740768617754206},
              {28.69701574099527,
               29.70248408398711,
               30.359491151219757,
               31.293591844264494,
               32.80936115547851,
               33.81011339467918,
               34.86707231858011},
              {28.91324055255647,
               29.511342398860936,
               30.5015162946872,
               31.798295178966775,
               32.649963930777766,
               33.7019668772577,
               34.7957926694361}}}
        };
        EXPECT_TRUE(xt::allclose(a2_b3, py_a2_b3));
    }

    /*py
    a0 = np.arange(5 * 3 * 7).reshape(5, 3, 7)
    a1 = np.copy(a0)
    b1 = np.arange(5 * 3).reshape(5, 3)
    a1[:, :, 2] = b1
    a2 = np.copy(a1)
    ar2 = np.arange(35).reshape(5, 1, 7)
    a1[:, 0, np.newaxis, :] = ar2
    a3 = np.copy(a1)
    a1[:, 2, :] = np.arange(7)
    a4 = np.copy(a1)
    ax1 = np.copy(a0)
    ax1[1, :, :] = -1
    ax2 = np.copy(a0)
    ax2[0:2, 0:2, :] = -1
    ax3 = np.copy(a0)
    ax3[1, 0:2:2, :] = -1
    ax4 = np.copy(a0)
    ax4[:, 0:2, :] = -1
    */
    TEST(xtest_extended, broadcast_into_view)
    {
        // py_a0
        xarray<long> py_a0 = {
            {{0, 1, 2, 3, 4, 5, 6}, {7, 8, 9, 10, 11, 12, 13}, {14, 15, 16, 17, 18, 19, 20}},

            {{21, 22, 23, 24, 25, 26, 27}, {28, 29, 30, 31, 32, 33, 34}, {35, 36, 37, 38, 39, 40, 41}},

            {{42, 43, 44, 45, 46, 47, 48}, {49, 50, 51, 52, 53, 54, 55}, {56, 57, 58, 59, 60, 61, 62}},

            {{63, 64, 65, 66, 67, 68, 69}, {70, 71, 72, 73, 74, 75, 76}, {77, 78, 79, 80, 81, 82, 83}},

            {{84, 85, 86, 87, 88, 89, 90}, {91, 92, 93, 94, 95, 96, 97}, {98, 99, 100, 101, 102, 103, 104}}
        };
        xt::xarray<long> a = py_a0;

        // py_b1
        xarray<long> py_b1 = {{0, 1, 2}, {3, 4, 5}, {6, 7, 8}, {9, 10, 11}, {12, 13, 14}};
        // py_a2
        xarray<long> py_a2 = {
            {{0, 1, 0, 3, 4, 5, 6}, {7, 8, 1, 10, 11, 12, 13}, {14, 15, 2, 17, 18, 19, 20}},

            {{21, 22, 3, 24, 25, 26, 27}, {28, 29, 4, 31, 32, 33, 34}, {35, 36, 5, 38, 39, 40, 41}},

            {{42, 43, 6, 45, 46, 47, 48}, {49, 50, 7, 52, 53, 54, 55}, {56, 57, 8, 59, 60, 61, 62}},

            {{63, 64, 9, 66, 67, 68, 69}, {70, 71, 10, 73, 74, 75, 76}, {77, 78, 11, 80, 81, 82, 83}},

            {{84, 85, 12, 87, 88, 89, 90}, {91, 92, 13, 94, 95, 96, 97}, {98, 99, 14, 101, 102, 103, 104}}
        };
        view(a, all(), all(), 2) = py_b1;
        EXPECT_EQ(a, py_a2);

        // py_ar2
        xarray<long> py_ar2 = {
            {{0, 1, 2, 3, 4, 5, 6}},

            {{7, 8, 9, 10, 11, 12, 13}},

            {{14, 15, 16, 17, 18, 19, 20}},

            {{21, 22, 23, 24, 25, 26, 27}},

            {{28, 29, 30, 31, 32, 33, 34}}
        };
        xt::xarray<long> ar2 = py_ar2;
        view(a, all(), 0, newaxis(), all()) = ar2;

        // py_a3
        xarray<long> py_a3 = {
            {{0, 1, 2, 3, 4, 5, 6}, {7, 8, 1, 10, 11, 12, 13}, {14, 15, 2, 17, 18, 19, 20}},

            {{7, 8, 9, 10, 11, 12, 13}, {28, 29, 4, 31, 32, 33, 34}, {35, 36, 5, 38, 39, 40, 41}},

            {{14, 15, 16, 17, 18, 19, 20}, {49, 50, 7, 52, 53, 54, 55}, {56, 57, 8, 59, 60, 61, 62}},

            {{21, 22, 23, 24, 25, 26, 27}, {70, 71, 10, 73, 74, 75, 76}, {77, 78, 11, 80, 81, 82, 83}},

            {{28, 29, 30, 31, 32, 33, 34}, {91, 92, 13, 94, 95, 96, 97}, {98, 99, 14, 101, 102, 103, 104}}
        };
        EXPECT_EQ(a, py_a3);

        view(a, all(), 2, all()) = xt::arange(7);
        // py_a4
        xarray<long> py_a4 = {
            {{0, 1, 2, 3, 4, 5, 6}, {7, 8, 1, 10, 11, 12, 13}, {0, 1, 2, 3, 4, 5, 6}},

            {{7, 8, 9, 10, 11, 12, 13}, {28, 29, 4, 31, 32, 33, 34}, {0, 1, 2, 3, 4, 5, 6}},

            {{14, 15, 16, 17, 18, 19, 20}, {49, 50, 7, 52, 53, 54, 55}, {0, 1, 2, 3, 4, 5, 6}},

            {{21, 22, 23, 24, 25, 26, 27}, {70, 71, 10, 73, 74, 75, 76}, {0, 1, 2, 3, 4, 5, 6}},

            {{28, 29, 30, 31, 32, 33, 34}, {91, 92, 13, 94, 95, 96, 97}, {0, 1, 2, 3, 4, 5, 6}}
        };
        EXPECT_EQ(a, py_a4);

        a = py_a0;
        view(a, 1, all(), all()) = -1;

        // py_ax1
        xarray<long> py_ax1 = {
            {{0, 1, 2, 3, 4, 5, 6}, {7, 8, 9, 10, 11, 12, 13}, {14, 15, 16, 17, 18, 19, 20}},

            {{-1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1}},

            {{42, 43, 44, 45, 46, 47, 48}, {49, 50, 51, 52, 53, 54, 55}, {56, 57, 58, 59, 60, 61, 62}},

            {{63, 64, 65, 66, 67, 68, 69}, {70, 71, 72, 73, 74, 75, 76}, {77, 78, 79, 80, 81, 82, 83}},

            {{84, 85, 86, 87, 88, 89, 90}, {91, 92, 93, 94, 95, 96, 97}, {98, 99, 100, 101, 102, 103, 104}}
        };
        EXPECT_EQ(a, py_ax1);

        a = py_a0;
        view(a, range(0, 2), range(0, 2), all()) = -1;

        // py_ax2
        xarray<long> py_ax2 = {
            {{-1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1}, {14, 15, 16, 17, 18, 19, 20}},

            {{-1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1}, {35, 36, 37, 38, 39, 40, 41}},

            {{42, 43, 44, 45, 46, 47, 48}, {49, 50, 51, 52, 53, 54, 55}, {56, 57, 58, 59, 60, 61, 62}},

            {{63, 64, 65, 66, 67, 68, 69}, {70, 71, 72, 73, 74, 75, 76}, {77, 78, 79, 80, 81, 82, 83}},

            {{84, 85, 86, 87, 88, 89, 90}, {91, 92, 93, 94, 95, 96, 97}, {98, 99, 100, 101, 102, 103, 104}}
        };
        EXPECT_EQ(a, py_ax2);

        a = py_a0;
        view(a, all(), range(0, 2), all()) = -1;
        // py_ax4
        xarray<long> py_ax4 = {
            {{-1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1}, {14, 15, 16, 17, 18, 19, 20}},

            {{-1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1}, {35, 36, 37, 38, 39, 40, 41}},

            {{-1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1}, {56, 57, 58, 59, 60, 61, 62}},

            {{-1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1}, {77, 78, 79, 80, 81, 82, 83}},

            {{-1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1}, {98, 99, 100, 101, 102, 103, 104}}
        };
        EXPECT_EQ(a, py_ax4);

        a = py_a0;
        view(a, 1, range(0, 2, 2), all()) = -1;
        // py_ax3
        xarray<long> py_ax3 = {
            {{0, 1, 2, 3, 4, 5, 6}, {7, 8, 9, 10, 11, 12, 13}, {14, 15, 16, 17, 18, 19, 20}},

            {{-1, -1, -1, -1, -1, -1, -1}, {28, 29, 30, 31, 32, 33, 34}, {35, 36, 37, 38, 39, 40, 41}},

            {{42, 43, 44, 45, 46, 47, 48}, {49, 50, 51, 52, 53, 54, 55}, {56, 57, 58, 59, 60, 61, 62}},

            {{63, 64, 65, 66, 67, 68, 69}, {70, 71, 72, 73, 74, 75, 76}, {77, 78, 79, 80, 81, 82, 83}},

            {{84, 85, 86, 87, 88, 89, 90}, {91, 92, 93, 94, 95, 96, 97}, {98, 99, 100, 101, 102, 103, 104}}
        };
        EXPECT_EQ(a, py_ax3);
    }

    /*py
    a0 = np.arange(2 * 3 * 4).reshape(2, 3, 4)
    a1 = np.arange(3 * 4).reshape(3, 4)
    a2 = np.arange(2 * 4).reshape(2, 1, 4)
    a3 = np.arange(4).reshape(1, 1, 4)
    a4 = np.arange(3 * 1).reshape(3, 1)
    # test 1
    a0_cp1 = np.copy(a0)
    a0_cp1[0:2, :, :] = a0 * 2 + a4
    a0_cp2 = np.copy(a0_cp1)
    a0_cp2[0, :, :] *= a1 * 7 + a4

    x0 = np.arange(3 * 3 * 2).reshape(3, 3, 2)
    a0_cp3 = np.copy(a0_cp2)
    a0_cp3[0, :, ::2] = x0[1, :, :]
    */
    TEST(xtest_extended, broadcast_funcs_view)
    {
        // py_a0
        xarray<long> py_a0 = {
            {{0, 1, 2, 3}, {4, 5, 6, 7}, {8, 9, 10, 11}},

            {{12, 13, 14, 15}, {16, 17, 18, 19}, {20, 21, 22, 23}}
        };
        // py_a1
        xarray<long> py_a1 = {{0, 1, 2, 3}, {4, 5, 6, 7}, {8, 9, 10, 11}};
        // py_a2
        xarray<long> py_a2 = {
            {{0, 1, 2, 3}},

            {{4, 5, 6, 7}}
        };
        // py_a3
        xarray<long> py_a3 = {{{0, 1, 2, 3}}};
        xt::xarray<long> py_a4 = {0, 1, 2};
        py_a4.reshape({3, 1});

        xt::xarray<long> a = py_a0;
        xt::view(a, range(0, 2), all(), all()) = py_a0 * 2 + py_a4;
        // py_a0_cp1
        xarray<long> py_a0_cp1 = {
            {{0, 2, 4, 6}, {9, 11, 13, 15}, {18, 20, 22, 24}},

            {{24, 26, 28, 30}, {33, 35, 37, 39}, {42, 44, 46, 48}}
        };
        EXPECT_EQ(py_a0_cp1, a);

        // py_a0_cp2
        xarray<long> py_a0_cp2 = {
            {{0, 14, 56, 126}, {261, 396, 559, 750}, {1044, 1300, 1584, 1896}},

            {{24, 26, 28, 30}, {33, 35, 37, 39}, {42, 44, 46, 48}}
        };
        xt::view(a, 0, all(), all()) *= py_a1 * 7 + py_a4;
        EXPECT_EQ(py_a0_cp2, a);

        // py_x0
        xarray<long> py_x0 = {
            {{0, 1}, {2, 3}, {4, 5}},

            {{6, 7}, {8, 9}, {10, 11}},

            {{12, 13}, {14, 15}, {16, 17}}
        };
        // py_a0_cp3
        xarray<long> py_a0_cp3 = {
            {{6, 14, 7, 126}, {8, 396, 9, 750}, {10, 1300, 11, 1896}},

            {{24, 26, 28, 30}, {33, 35, 37, 39}, {42, 44, 46, 48}}
        };
        xt::view(a, 0, all(), range(_, _, 2)) = xt::view(py_x0, 1, all(), all());
        EXPECT_EQ(a, py_a0_cp3);

        xt::view(a, 0, all(), all()) = xt::view((py_a0 * py_a0 + 3), 0, all(), all());
        // py_x1 = (a0 * a0 + 3)[0, :, :]
        xarray<long> py_x1 = {{3, 4, 7, 12}, {19, 28, 39, 52}, {67, 84, 103, 124}};
        EXPECT_EQ(py_x1, view(a, 0, all(), all()));
    }
}
