; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=simplifycfg -simplifycfg-require-and-preserve-domtree=1 -S %s | FileCheck %s
; Make sure we don't speculate loads under AddressSanitizer.
@g = global i32 0, align 4

define i32 @TestNoAsan(i32 %cond) nounwind readonly uwtable {
; CHECK-LABEL: @TestNoAsan(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp eq i32 [[COND:%.*]], 0
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr @g, align 4
; CHECK-NEXT:    [[SPEC_SELECT:%.*]] = select i1 [[TOBOOL]], i32 0, i32 [[TMP0]]
; CHECK-NEXT:    ret i32 [[SPEC_SELECT]]
;
entry:
  %tobool = icmp eq i32 %cond, 0
  br i1 %tobool, label %return, label %if.then

if.then:                                          ; preds = %entry
  %0 = load i32, ptr @g, align 4
  br label %return

return:                                           ; preds = %entry, %if.then
  %retval = phi i32 [ %0, %if.then ], [ 0, %entry ]
  ret i32 %retval
}

define i32 @TestAsan(i32 %cond) nounwind readonly uwtable sanitize_address {
; CHECK-LABEL: @TestAsan(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp eq i32 [[COND:%.*]], 0
; CHECK-NEXT:    br i1 [[TOBOOL]], label [[RETURN:%.*]], label [[IF_THEN:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr @g, align 4
; CHECK-NEXT:    br label [[RETURN]]
; CHECK:       return:
; CHECK-NEXT:    [[RETVAL:%.*]] = phi i32 [ [[TMP0]], [[IF_THEN]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i32 [[RETVAL]]
;
entry:
  %tobool = icmp eq i32 %cond, 0
  br i1 %tobool, label %return, label %if.then

if.then:                                          ; preds = %entry
  %0 = load i32, ptr @g, align 4
  br label %return

return:                                           ; preds = %entry, %if.then
  %retval = phi i32 [ %0, %if.then ], [ 0, %entry ]
  ret i32 %retval
}

define i32 @TestHWAsan(i32 %cond) nounwind readonly uwtable sanitize_hwaddress {
; CHECK-LABEL: @TestHWAsan(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp eq i32 [[COND:%.*]], 0
; CHECK-NEXT:    br i1 [[TOBOOL]], label [[RETURN:%.*]], label [[IF_THEN:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr @g, align 4
; CHECK-NEXT:    br label [[RETURN]]
; CHECK:       return:
; CHECK-NEXT:    [[RETVAL:%.*]] = phi i32 [ [[TMP0]], [[IF_THEN]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i32 [[RETVAL]]
;
entry:
  %tobool = icmp eq i32 %cond, 0
  br i1 %tobool, label %return, label %if.then

if.then:                                          ; preds = %entry
  %0 = load i32, ptr @g, align 4
  br label %return

return:                                           ; preds = %entry, %if.then
  %retval = phi i32 [ %0, %if.then ], [ 0, %entry ]
  ret i32 %retval
}
