; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=powerpc64le-unknown-linux-gnu -global-isel -o - \
; RUN:   -ppc-vsr-nums-as-vr -ppc-asm-full-reg-names < %s | FileCheck %s

;; Note that SETUEQ, SETOGE, SETOLE, SETONE, SETULT and SETUGT should be
;; expanded by DAG legalizer for floating-point types f32 and f64, so there are
;; no patterns defined in PPCInstrInfo.td file for these setcc patterns for now.

define i1 @fcmp_false(float %a, float %b) {
; CHECK-LABEL: fcmp_false:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li r3, 0
; CHECK-NEXT:    blr
  %cmp = fcmp false float %a, %b
  ret i1 %cmp
}

define i1 @fcmp_oeq(float %a, float %b) {
; CHECK-LABEL: fcmp_oeq:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcmpu cr0, f1, f2
; CHECK-NEXT:    li r3, 0
; CHECK-NEXT:    li r4, 1
; CHECK-NEXT:    iseleq r3, r4, r3
; CHECK-NEXT:    blr
  %cmp = fcmp oeq float %a, %b
  ret i1 %cmp
}

define i1 @fcmp_ogt(float %a, float %b) {
; CHECK-LABEL: fcmp_ogt:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcmpu cr0, f1, f2
; CHECK-NEXT:    li r3, 0
; CHECK-NEXT:    li r4, 1
; CHECK-NEXT:    iselgt r3, r4, r3
; CHECK-NEXT:    blr
  %cmp = fcmp ogt float %a, %b
  ret i1 %cmp
}

define i1 @fcmp_olt(float %a, float %b) {
; CHECK-LABEL: fcmp_olt:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcmpu cr0, f1, f2
; CHECK-NEXT:    li r3, 0
; CHECK-NEXT:    li r4, 1
; CHECK-NEXT:    isellt r3, r4, r3
; CHECK-NEXT:    blr
  %cmp = fcmp olt float %a, %b
  ret i1 %cmp
}

define i1 @fcmp_ord(float %a, float %b) {
; CHECK-LABEL: fcmp_ord:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcmpu cr0, f1, f2
; CHECK-NEXT:    li r3, 0
; CHECK-NEXT:    li r4, 1
; CHECK-NEXT:    crnot 4*cr5+lt, un
; CHECK-NEXT:    isel r3, r4, r3, 4*cr5+lt
; CHECK-NEXT:    blr
  %cmp = fcmp ord float %a, %b
  ret i1 %cmp
}

define i1 @fcmp_uge(float %a, float %b) {
; CHECK-LABEL: fcmp_uge:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcmpu cr0, f1, f2
; CHECK-NEXT:    li r3, 0
; CHECK-NEXT:    li r4, 1
; CHECK-NEXT:    crnot 4*cr5+lt, lt
; CHECK-NEXT:    isel r3, r4, r3, 4*cr5+lt
; CHECK-NEXT:    blr
  %cmp = fcmp uge float %a, %b
  ret i1 %cmp
}

define i1 @fcmp_ule(float %a, float %b) {
; CHECK-LABEL: fcmp_ule:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcmpu cr0, f1, f2
; CHECK-NEXT:    li r3, 0
; CHECK-NEXT:    li r4, 1
; CHECK-NEXT:    crnot 4*cr5+lt, gt
; CHECK-NEXT:    isel r3, r4, r3, 4*cr5+lt
; CHECK-NEXT:    blr
  %cmp = fcmp ule float %a, %b
  ret i1 %cmp
}

define i1 @fcmp_une(float %a, float %b) {
; CHECK-LABEL: fcmp_une:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcmpu cr0, f1, f2
; CHECK-NEXT:    li r3, 0
; CHECK-NEXT:    li r4, 1
; CHECK-NEXT:    crnot 4*cr5+lt, eq
; CHECK-NEXT:    isel r3, r4, r3, 4*cr5+lt
; CHECK-NEXT:    blr
  %cmp = fcmp une float %a, %b
  ret i1 %cmp
}

define i1 @fcmp_uno(float %a, float %b) {
; CHECK-LABEL: fcmp_uno:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcmpu cr0, f1, f2
; CHECK-NEXT:    li r3, 0
; CHECK-NEXT:    li r4, 1
; CHECK-NEXT:    isel r3, r4, r3, un
; CHECK-NEXT:    blr
  %cmp = fcmp uno float %a, %b
  ret i1 %cmp
}

define i1 @fcmp_true(float %a, float %b) {
; CHECK-LABEL: fcmp_true:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li r3, 1
; CHECK-NEXT:    blr
  %cmp = fcmp true float %a, %b
  ret i1 %cmp
}

define i1 @fcmp_false_double(double %a, double %b) {
; CHECK-LABEL: fcmp_false_double:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li r3, 0
; CHECK-NEXT:    blr
  %cmp = fcmp false double %a, %b
  ret i1 %cmp
}

define i1 @fcmp_oeq_double(double %a, double %b) {
; CHECK-LABEL: fcmp_oeq_double:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcmpu cr0, f1, f2
; CHECK-NEXT:    li r3, 0
; CHECK-NEXT:    li r4, 1
; CHECK-NEXT:    iseleq r3, r4, r3
; CHECK-NEXT:    blr
  %cmp = fcmp oeq double %a, %b
  ret i1 %cmp
}

define i1 @fcmp_ogt_double(double %a, double %b) {
; CHECK-LABEL: fcmp_ogt_double:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcmpu cr0, f1, f2
; CHECK-NEXT:    li r3, 0
; CHECK-NEXT:    li r4, 1
; CHECK-NEXT:    iselgt r3, r4, r3
; CHECK-NEXT:    blr
  %cmp = fcmp ogt double %a, %b
  ret i1 %cmp
}

define i1 @fcmp_olt_double(double %a, double %b) {
; CHECK-LABEL: fcmp_olt_double:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcmpu cr0, f1, f2
; CHECK-NEXT:    li r3, 0
; CHECK-NEXT:    li r4, 1
; CHECK-NEXT:    isellt r3, r4, r3
; CHECK-NEXT:    blr
  %cmp = fcmp olt double %a, %b
  ret i1 %cmp
}

define i1 @fcmp_ord_double(double %a, double %b) {
; CHECK-LABEL: fcmp_ord_double:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcmpu cr0, f1, f2
; CHECK-NEXT:    li r3, 0
; CHECK-NEXT:    li r4, 1
; CHECK-NEXT:    crnot 4*cr5+lt, un
; CHECK-NEXT:    isel r3, r4, r3, 4*cr5+lt
; CHECK-NEXT:    blr
  %cmp = fcmp ord double %a, %b
  ret i1 %cmp
}

define i1 @fcmp_uge_double(double %a, double %b) {
; CHECK-LABEL: fcmp_uge_double:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcmpu cr0, f1, f2
; CHECK-NEXT:    li r3, 0
; CHECK-NEXT:    li r4, 1
; CHECK-NEXT:    crnot 4*cr5+lt, lt
; CHECK-NEXT:    isel r3, r4, r3, 4*cr5+lt
; CHECK-NEXT:    blr
  %cmp = fcmp uge double %a, %b
  ret i1 %cmp
}

define i1 @fcmp_ule_double(double %a, double %b) {
; CHECK-LABEL: fcmp_ule_double:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcmpu cr0, f1, f2
; CHECK-NEXT:    li r3, 0
; CHECK-NEXT:    li r4, 1
; CHECK-NEXT:    crnot 4*cr5+lt, gt
; CHECK-NEXT:    isel r3, r4, r3, 4*cr5+lt
; CHECK-NEXT:    blr
  %cmp = fcmp ule double %a, %b
  ret i1 %cmp
}

define i1 @fcmp_une_double(double %a, double %b) {
; CHECK-LABEL: fcmp_une_double:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcmpu cr0, f1, f2
; CHECK-NEXT:    li r3, 0
; CHECK-NEXT:    li r4, 1
; CHECK-NEXT:    crnot 4*cr5+lt, eq
; CHECK-NEXT:    isel r3, r4, r3, 4*cr5+lt
; CHECK-NEXT:    blr
  %cmp = fcmp une double %a, %b
  ret i1 %cmp
}

define i1 @fcmp_uno_double(double %a, double %b) {
; CHECK-LABEL: fcmp_uno_double:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcmpu cr0, f1, f2
; CHECK-NEXT:    li r3, 0
; CHECK-NEXT:    li r4, 1
; CHECK-NEXT:    isel r3, r4, r3, un
; CHECK-NEXT:    blr
  %cmp = fcmp uno double %a, %b
  ret i1 %cmp
}

define i1 @fcmp_true_double(double %a, double %b) {
; CHECK-LABEL: fcmp_true_double:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li r3, 1
; CHECK-NEXT:    blr
  %cmp = fcmp true double %a, %b
  ret i1 %cmp
}
