; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc --mtriple=loongarch64 --mattr=+lsx < %s | FileCheck %s

define <16 x i8> @widen_shuffle_mask_v16i8_to_v8i16(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: widen_shuffle_mask_v16i8_to_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pcalau12i $a0, %pc_hi20(.LCPI0_0)
; CHECK-NEXT:    vld $vr2, $a0, %pc_lo12(.LCPI0_0)
; CHECK-NEXT:    vshuf.h $vr2, $vr1, $vr0
; CHECK-NEXT:    vori.b $vr0, $vr2, 0
; CHECK-NEXT:    ret
    %r = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 0, i32 1, i32 24, i32 25, i32 26, i32 27, i32 8, i32 9, i32 10, i32 11, i32 16, i32 17, i32 18, i32 19, i32 2, i32 3>
    ret <16 x i8> %r
}

define <16 x i8> @widen_shuffle_mask_v16i8_to_v4i32(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: widen_shuffle_mask_v16i8_to_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pcalau12i $a0, %pc_hi20(.LCPI1_0)
; CHECK-NEXT:    vld $vr2, $a0, %pc_lo12(.LCPI1_0)
; CHECK-NEXT:    vshuf.w $vr2, $vr1, $vr0
; CHECK-NEXT:    vori.b $vr0, $vr2, 0
; CHECK-NEXT:    ret
    %r = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 24, i32 25, i32 26, i32 27, i32 8, i32 9, i32 10, i32 11, i32 16, i32 17, i32 18, i32 19>
    ret <16 x i8> %r
}

define <16 x i8> @widen_shuffle_mask_v16i8_to_v2i64(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: widen_shuffle_mask_v16i8_to_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vshuf4i.d $vr0, $vr1, 12
; CHECK-NEXT:    ret
    %r = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
    ret <16 x i8> %r
}

define <8 x i16> @widen_shuffle_mask_v8i16_to_v4i32(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: widen_shuffle_mask_v8i16_to_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pcalau12i $a0, %pc_hi20(.LCPI3_0)
; CHECK-NEXT:    vld $vr2, $a0, %pc_lo12(.LCPI3_0)
; CHECK-NEXT:    vshuf.w $vr2, $vr1, $vr0
; CHECK-NEXT:    vori.b $vr0, $vr2, 0
; CHECK-NEXT:    ret
    %r = shufflevector <8 x i16> %a, <8 x i16> %b, <8 x i32> <i32 0, i32 1, i32 12, i32 13, i32 14, i32 15, i32 2, i32 3>
    ret <8 x i16> %r
}

define <8 x i16> @widen_shuffle_mask_v8i16_to_v2i64(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: widen_shuffle_mask_v8i16_to_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vshuf4i.d $vr0, $vr1, 12
; CHECK-NEXT:    ret
    %r = shufflevector <8 x i16> %a, <8 x i16> %b, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 12, i32 13, i32 14, i32 15>
    ret <8 x i16> %r
}

define <4 x i32> @widen_shuffle_mask_v4i32_to_v2i64(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: widen_shuffle_mask_v4i32_to_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vshuf4i.d $vr0, $vr1, 12
; CHECK-NEXT:    ret
    %r = shufflevector <4 x i32> %a, <4 x i32> %b, <4 x i32> <i32 0, i32 1, i32 6, i32 7>
    ret <4 x i32> %r
}

define <16 x i8> @widen_shuffle_mask_v16i8_to_vpackev_h(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: widen_shuffle_mask_v16i8_to_vpackev_h:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpackev.h $vr0, $vr1, $vr0
; CHECK-NEXT:    ret
    %r = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 0, i32 1, i32 16, i32 17, i32 4, i32 5, i32 20, i32 21, i32 8, i32 9, i32 24, i32 25, i32 12, i32 13, i32 28, i32 29>
    ret <16 x i8> %r
}

define <16 x i8> @widen_shuffle_mask_v16i8_to_vpackod_h(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: widen_shuffle_mask_v16i8_to_vpackod_h:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpackod.h $vr0, $vr1, $vr0
; CHECK-NEXT:    ret
    %r = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 2, i32 3, i32 18, i32 19, i32 6, i32 7, i32 22, i32 23, i32 10, i32 11, i32 26, i32 27, i32 14, i32 15, i32 30, i32 31>
    ret <16 x i8> %r
}

define <16 x i8> @widen_shuffle_mask_v16i8_to_vpickev_h(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: widen_shuffle_mask_v16i8_to_vpickev_h:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpickev.h $vr0, $vr1, $vr0
; CHECK-NEXT:    ret
    %r = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 0, i32 1, i32 4, i32 5, i32 8, i32 9, i32 12, i32 13, i32 16, i32 17, i32 20, i32 21, i32 24, i32 25, i32 28, i32 29>
    ret <16 x i8> %r
}

define <16 x i8> @widen_shuffle_mask_v16i8_to_vpickod_h(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: widen_shuffle_mask_v16i8_to_vpickod_h:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpickod.h $vr0, $vr1, $vr0
; CHECK-NEXT:    ret
    %r = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 2, i32 3, i32 6, i32 7, i32 10, i32 11, i32 14, i32 15, i32 18, i32 19, i32 22, i32 23, i32 26, i32 27, i32 30, i32 31>
    ret <16 x i8> %r
}

define <16 x i8> @widen_shuffle_mask_v16i8_to_vilvl_h(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: widen_shuffle_mask_v16i8_to_vilvl_h:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vilvl.h $vr0, $vr1, $vr0
; CHECK-NEXT:    ret
    %r = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 0, i32 1, i32 16, i32 17, i32 2, i32 3, i32 18, i32 19, i32 4, i32 5, i32 20, i32 21, i32 6, i32 7, i32 22, i32 23>
    ret <16 x i8> %r
}

define <16 x i8> @widen_shuffle_mask_v16i8_to_vilvh_h(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: widen_shuffle_mask_v16i8_to_vilvh_h:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vilvh.h $vr0, $vr1, $vr0
; CHECK-NEXT:    ret
    %r = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 8, i32 9, i32 24, i32 25, i32 10, i32 11, i32 26, i32 27, i32 12, i32 13, i32 28, i32 29, i32 14, i32 15, i32 30, i32 31>
    ret <16 x i8> %r
}
