;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.

;; RUN: foreach %s %t wasm-opt -all --closed-world --gto --preserve-type-order -S -o - | filecheck %s

(module
  (rec
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $struct (descriptor $desc (struct (field i32))))
    (type $struct (descriptor $desc (struct (field i32))))
    ;; CHECK:       (type $desc (describes $struct (struct)))
    (type $desc (describes $struct (struct)))
    ;; CHECK:       (type $pair (struct))
    (type $pair (struct (field (ref $struct)) (field (ref $struct))))
    ;; CHECK:       (type $used-pair (struct (field (ref $struct)) (field (ref $struct))))
    (type $used-pair (struct (field (ref $struct)) (field (ref $struct))))
  )

  ;; CHECK:       (type $4 (func (param (ref $struct) (ref $used-pair))))

  ;; CHECK:       (type $5 (func (param (ref $struct))))

  ;; CHECK:      (global $nullable-desc (ref null (exact $desc)) (struct.new_default $desc))
  (global $nullable-desc (ref null (exact $desc)) (struct.new $desc))

  ;; Check that we generate fresh names for added globals.
  ;; CHECK:      (global $gto-removed-1 nullref (ref.null none))
  (global $gto-removed-1 nullref (ref.null none))

  ;; CHECK:      (global $second-traps (ref $pair) (struct.new_default $pair))
  (global $second-traps (ref $pair)
    ;; Both fields will be removed, but only the second can trap, so only the
    ;; second will be moved to a new global.
    (struct.new $pair
      (struct.new $struct
        (i32.const 0)
        (struct.new $desc)
      )
      (struct.new $struct
        (i32.const 1)
        (ref.null none)
      )
    )
  )

  ;; CHECK:      (global $first-traps (ref $pair) (struct.new_default $pair))
  (global $first-traps (ref $pair)
    ;; Same as above, but now the first traps (or at least we assume it can
    ;; based on its type).
    (struct.new $pair
      (struct.new $struct
        (i32.const 2)
        (global.get $nullable-desc)
      )
      (struct.new $struct
        (i32.const 3)
        (struct.new $desc)
      )
    )
  )

  ;; CHECK:      (global $used-traps (ref $used-pair) (struct.new $used-pair
  ;; CHECK-NEXT:  (struct.new $struct
  ;; CHECK-NEXT:   (i32.const 4)
  ;; CHECK-NEXT:   (ref.null none)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (struct.new $struct
  ;; CHECK-NEXT:   (i32.const 5)
  ;; CHECK-NEXT:   (ref.null none)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: ))
  (global $used-traps (ref $used-pair)
    ;; Now both trap, but they are also used, so they will not be removed and no
    ;; globals will be created.
    (struct.new $used-pair
      (struct.new $struct
        (i32.const 4)
        (ref.null none)
      )
      (struct.new $struct
        (i32.const 5)
        (ref.null none)
      )
    )
  )

  ;; CHECK:      (global $gto-removed-0 (ref (exact $struct)) (struct.new $struct
  ;; CHECK-NEXT:  (i32.const 1)
  ;; CHECK-NEXT:  (ref.null none)
  ;; CHECK-NEXT: ))

  ;; CHECK:      (global $gto-removed-1_6 (ref (exact $struct)) (struct.new $struct
  ;; CHECK-NEXT:  (i32.const 2)
  ;; CHECK-NEXT:  (global.get $nullable-desc)
  ;; CHECK-NEXT: ))

  ;; CHECK:      (func $use-struct-fields (type $4) (param $0 (ref $struct)) (param $1 (ref $used-pair))
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.get $struct 0
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.get $used-pair 0
  ;; CHECK-NEXT:    (local.get $1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.get $used-pair 1
  ;; CHECK-NEXT:    (local.get $1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $use-struct-fields (param (ref $struct)) (param (ref $used-pair))
    ;; Prevent the i32s in the initializers from being removed.
    (drop
      (struct.get $struct 0
        (local.get 0)
      )
    )
    ;; Prevent the fields in used-pair from being removed.
    (drop
      (struct.get $used-pair 0
        (local.get 1)
      )
    )
    (drop
      (struct.get $used-pair 1
        (local.get 1)
      )
    )
  )

  ;; CHECK:      (func $use-desc (type $5) (param $struct (ref $struct))
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (ref.get_desc $struct
  ;; CHECK-NEXT:    (local.get $struct)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $use-desc (param $struct (ref $struct))
    ;; Use the descriptor, so this test is not trivial.
    (drop
      (ref.get_desc $struct
        (local.get $struct)
      )
    )
  )
)

;; The descriptor here is not needed.
(module
  (rec
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $A (struct))
    (type $A (descriptor $B (struct)))
    ;; CHECK:       (type $B (struct))
    (type $B (describes $A (struct)))
  )

  ;; CHECK:       (type $2 (func))

  ;; CHECK:      (func $test (type $2)
  ;; CHECK-NEXT:  (local $A (ref $A))
  ;; CHECK-NEXT:  (local $B (ref $B))
  ;; CHECK-NEXT: )
  (func $test
    (local $A (ref $A))
    (local $B (ref $B))
  )
)

;; As above, but even creating the type does not force us to keep the
;; descriptor, if it is never used.
(module
  (rec
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $A (struct))
    (type $A (descriptor $B (struct)))
    ;; CHECK:       (type $B (struct))
    (type $B (describes $A (struct)))
  )

  ;; CHECK:       (type $2 (func))

  ;; CHECK:      (func $test (type $2)
  ;; CHECK-NEXT:  (local $A (ref $A))
  ;; CHECK-NEXT:  (local $B (ref $B))
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.new_default $A)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $test
    (local $A (ref $A))
    (local $B (ref $B))
    (drop
      (struct.new $A
        (struct.new $B)
      )
    )
  )
)

;; As above, with the creation in the global scope.
(module
  (rec
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $A (struct))
    (type $A (descriptor $B (struct)))
    ;; CHECK:       (type $B (struct))
    (type $B (describes $A (struct)))
  )


  ;; CHECK:       (type $2 (func))

  ;; CHECK:      (global $g anyref (struct.new_default $A))
  (global $g anyref (struct.new $A
    (struct.new $B)
  ))

  ;; CHECK:      (func $test (type $2)
  ;; CHECK-NEXT:  (local $A (ref $A))
  ;; CHECK-NEXT:  (local $B (ref $B))
  ;; CHECK-NEXT: )
  (func $test
    (local $A (ref $A))
    (local $B (ref $B))
  )
)

;; Both descriptors in this chain are unneeded.
(module
  (rec
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $A (struct))
    (type $A (descriptor $B (struct)))
    ;; CHECK:       (type $B (struct))
    (type $B (describes $A (descriptor $C (struct))))
    ;; CHECK:       (type $C (struct))
    (type $C (describes $B (struct)))
  )

  ;; CHECK:       (type $3 (func))

  ;; CHECK:      (func $test (type $3)
  ;; CHECK-NEXT:  (local $A (ref $A))
  ;; CHECK-NEXT:  (local $B (ref $B))
  ;; CHECK-NEXT:  (local $C (ref $C))
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.new_default $A)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $test
    (local $A (ref $A))
    (local $B (ref $B))
    (local $C (ref $C))
    (drop
      (struct.new $A
        (struct.new $B
          (struct.new $C)
        )
      )
    )
  )
)

;; ref.get_desc keeps the descriptor.
(module
  (rec
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $A (descriptor $B (struct)))
    (type $A (descriptor $B (struct)))
    ;; CHECK:       (type $B (describes $A (struct)))
    (type $B (describes $A (struct)))
  )

  ;; CHECK:      (type $2 (func))

  ;; CHECK:      (func $test (type $2)
  ;; CHECK-NEXT:  (local $A (ref $A))
  ;; CHECK-NEXT:  (local $B (ref $B))
  ;; CHECK-NEXT:  (local.set $A
  ;; CHECK-NEXT:   (struct.new_default $A
  ;; CHECK-NEXT:    (struct.new_default $B)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (ref.get_desc $A
  ;; CHECK-NEXT:    (local.get $A)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $test
    (local $A (ref $A))
    (local $B (ref $B))
    (local.set $A
      (struct.new $A
        (struct.new $B)
      )
    )
    (drop
      (ref.get_desc $A
        (local.get $A)
      )
    )
  )
)

;; ref.cast_desc keeps the descriptor.
(module
  (rec
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $A (descriptor $B (struct)))
    (type $A (descriptor $B (struct)))
    ;; CHECK:       (type $B (describes $A (struct)))
    (type $B (describes $A (struct)))
  )

  ;; CHECK:      (type $2 (func))

  ;; CHECK:      (func $test (type $2)
  ;; CHECK-NEXT:  (local $A (ref $A))
  ;; CHECK-NEXT:  (local $B (ref $B))
  ;; CHECK-NEXT:  (local.set $A
  ;; CHECK-NEXT:   (struct.new_default $A
  ;; CHECK-NEXT:    (struct.new_default $B)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (ref.cast_desc (ref (exact $A))
  ;; CHECK-NEXT:    (local.get $A)
  ;; CHECK-NEXT:    (struct.new_default $B)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $test
    (local $A (ref $A))
    (local $B (ref $B))
    (local.set $A
      (struct.new $A
        (struct.new $B)
      )
    )
    (drop
      (ref.cast_desc (ref null (exact $A))
        (local.get $A)
        (struct.new $B)
      )
    )
  )
)

;; br_on_cast_desc keeps the descriptor.
(module
  (rec
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $A (descriptor $B (struct)))
    (type $A (descriptor $B (struct)))
    ;; CHECK:       (type $B (describes $A (struct)))
    (type $B (describes $A (struct)))
  )

  ;; CHECK:      (type $2 (func))

  ;; CHECK:      (func $test (type $2)
  ;; CHECK-NEXT:  (local $A (ref $A))
  ;; CHECK-NEXT:  (local $B (ref $B))
  ;; CHECK-NEXT:  (local.set $A
  ;; CHECK-NEXT:   (struct.new_default $A
  ;; CHECK-NEXT:    (struct.new_default $B)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (block $l (result (ref null $A))
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (br_on_cast_desc $l (ref $A) (ref (exact $A))
  ;; CHECK-NEXT:      (local.get $A)
  ;; CHECK-NEXT:      (struct.new_default $B)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (unreachable)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $test
    (local $A (ref $A))
    (local $B (ref $B))
    (local.set $A
      (struct.new $A
        (struct.new $B)
      )
    )
    (drop
      (block $l (result (ref null $A))
        (br_on_cast_desc $l anyref (ref null $A)
          (local.get $A)
          (struct.new $B)
        )
        (unreachable)
      )
    )
  )
)

;; br_on_cast_desc_fail keeps the descriptor.
(module
  (rec
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $A (descriptor $B (struct)))
    (type $A (descriptor $B (struct)))
    ;; CHECK:       (type $B (describes $A (struct)))
    (type $B (describes $A (struct)))
  )

  ;; CHECK:      (type $2 (func))

  ;; CHECK:      (func $test (type $2)
  ;; CHECK-NEXT:  (local $A (ref $A))
  ;; CHECK-NEXT:  (local $B (ref $B))
  ;; CHECK-NEXT:  (local.set $A
  ;; CHECK-NEXT:   (struct.new_default $A
  ;; CHECK-NEXT:    (struct.new_default $B)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (block $l (result (ref null $A))
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (br_on_cast_desc_fail $l (ref $A) (ref (exact $A))
  ;; CHECK-NEXT:      (local.get $A)
  ;; CHECK-NEXT:      (struct.new_default $B)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (unreachable)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $test
    (local $A (ref $A))
    (local $B (ref $B))
    (local.set $A
      (struct.new $A
        (struct.new $B)
      )
    )
    (drop
      (block $l (result (ref null $A))
        (br_on_cast_desc_fail $l anyref (ref null $A)
          (local.get $A)
          (struct.new $B)
        )
        (unreachable)
      )
    )
  )
)

;; The descriptor can be removed, but its effects must be preserved.
(module
  (rec
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $A (struct))
    (type $A (descriptor $B (struct)))
    ;; CHECK:       (type $B (struct))
    (type $B (describes $A (struct)))
  )

  ;; CHECK:       (type $2 (func))

  ;; CHECK:      (func $test (type $2)
  ;; CHECK-NEXT:  (local $A (ref $A))
  ;; CHECK-NEXT:  (local $B (ref (exact $B)))
  ;; CHECK-NEXT:  (local $2 (ref (exact $B)))
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (block (result (ref (exact $A)))
  ;; CHECK-NEXT:    (local.set $2
  ;; CHECK-NEXT:     (local.tee $B
  ;; CHECK-NEXT:      (struct.new_default $B)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (struct.new_default $A)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $test
    (local $A (ref $A))
    (local $B (ref (exact $B)))
    (drop
      (struct.new $A
        (local.tee $B
          (struct.new $B)
        )
      )
    )
  )
)

;; Test removing indexes /immutability as well as removing a descriptor.
(module
  (rec
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $A (struct (field $c i32)))
    (type $A (descriptor $B (struct (field $a (mut i32)) (field $b (mut i32)) (field $c (mut i32)))))
    ;; CHECK:       (type $B (struct))
    (type $B (describes $A (struct (field (mut i32)))))
  )

  ;; CHECK:       (type $2 (func))

  ;; CHECK:      (func $test (type $2)
  ;; CHECK-NEXT:  (local $A (ref $A))
  ;; CHECK-NEXT:  (local $B (ref (exact $B)))
  ;; CHECK-NEXT:  (local $2 (ref (exact $B)))
  ;; CHECK-NEXT:  (local.set $A
  ;; CHECK-NEXT:   (block (result (ref (exact $A)))
  ;; CHECK-NEXT:    (local.set $2
  ;; CHECK-NEXT:     (local.tee $B
  ;; CHECK-NEXT:      (struct.new_default $B)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (struct.new $A
  ;; CHECK-NEXT:     (i32.const 30)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (ref.as_non_null
  ;; CHECK-NEXT:    (block (result (ref $A))
  ;; CHECK-NEXT:     (drop
  ;; CHECK-NEXT:      (i32.const 42)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (local.get $A)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.get $A $c
  ;; CHECK-NEXT:    (local.get $A)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (ref.as_non_null
  ;; CHECK-NEXT:    (block (result (ref (exact $B)))
  ;; CHECK-NEXT:     (drop
  ;; CHECK-NEXT:      (i32.const 9999)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (local.get $B)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $test
    (local $A (ref $A))
    (local $B (ref (exact $B)))
    (local.set $A
      (struct.new $A
        (i32.const 10)
        (i32.const 20)
        (i32.const 30)
        (local.tee $B
          (struct.new $B
            (i32.const 1337)
          )
        )
      )
    )
    ;; Write only the middle field (we can remove it as write-only).
    (struct.set $A $b
      (local.get $A)
      (i32.const 42)
    )
    ;; Read only the last field. We can make it immutable.
    (drop
      (struct.get $A $c
        (local.get $A)
      )
    )
    ;; Also mutate the field in the descriptor, which should not bother us.
    (struct.set $B 0
      (local.get $B)
      (i32.const 9999)
    )
  )
)

;; As above, but with struct.new_default.
(module
  (rec
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $A (struct (field i32)))
    (type $A (descriptor $B (struct (field (mut i32)) (field (mut i32)) (field (mut i32)))))
    ;; CHECK:       (type $B (struct))
    (type $B (describes $A (struct (field (mut i32)))))
  )

  ;; CHECK:       (type $2 (func))

  ;; CHECK:      (func $test (type $2)
  ;; CHECK-NEXT:  (local $A (ref $A))
  ;; CHECK-NEXT:  (local $B (ref (exact $B)))
  ;; CHECK-NEXT:  (local $2 (ref (exact $B)))
  ;; CHECK-NEXT:  (local.set $A
  ;; CHECK-NEXT:   (block (result (ref (exact $A)))
  ;; CHECK-NEXT:    (local.set $2
  ;; CHECK-NEXT:     (local.tee $B
  ;; CHECK-NEXT:      (struct.new_default $B)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (struct.new_default $A)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (ref.as_non_null
  ;; CHECK-NEXT:    (block (result (ref $A))
  ;; CHECK-NEXT:     (drop
  ;; CHECK-NEXT:      (i32.const 42)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (local.get $A)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.get $A 0
  ;; CHECK-NEXT:    (local.get $A)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (ref.as_non_null
  ;; CHECK-NEXT:    (block (result (ref (exact $B)))
  ;; CHECK-NEXT:     (drop
  ;; CHECK-NEXT:      (i32.const 9999)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (local.get $B)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $test
    (local $A (ref $A))
    (local $B (ref (exact $B)))
    (local.set $A
      (struct.new_default $A
        (local.tee $B
          (struct.new $B
            (i32.const 1337)
          )
        )
      )
    )
    (struct.set $A 1
      (local.get $A)
      (i32.const 42)
    )
    (drop
      (struct.get $A 2
        (local.get $A)
      )
    )
    (struct.set $B 0
      (local.get $B)
      (i32.const 9999)
    )
  )
)

;; Multiple types with descriptors, only one of whom can be removed.
(module
  (rec
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $A (struct))
    (type $A (descriptor $B (struct)))
    ;; CHECK:       (type $B (struct))
    (type $B (describes $A (struct)))

    ;; CHECK:       (type $C (descriptor $D (struct)))
    (type $C (descriptor $D (struct)))
    ;; CHECK:       (type $D (describes $C (struct)))
    (type $D (describes $C (struct)))
  )

  ;; CHECK:       (type $4 (func))

  ;; CHECK:      (func $test (type $4)
  ;; CHECK-NEXT:  (local $A (ref $A))
  ;; CHECK-NEXT:  (local $C (ref $C))
  ;; CHECK-NEXT:  (local.set $A
  ;; CHECK-NEXT:   (struct.new_default $A)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $C
  ;; CHECK-NEXT:   (struct.new_default $C
  ;; CHECK-NEXT:    (struct.new_default $D)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (ref.get_desc $C
  ;; CHECK-NEXT:    (local.get $C)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $test
    (local $A (ref $A))
    (local $C (ref $C))
    (local.set $A
      (struct.new $A
        (struct.new $B)
      )
    )
    (local.set $C
      (struct.new $C
        (struct.new $D)
      )
    )
    ;; Use the descriptor in $C but not $A.
    (drop
      (ref.get_desc $C
        (local.get $C)
      )
    )
  )
)

;; Subtyping. All these descriptors can be optimized away.
(module
  (rec
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $A (sub (struct)))
    (type $A (sub (descriptor $A.desc (struct))))
    ;; CHECK:       (type $A.desc (sub (struct)))
    (type $A.desc (sub (describes $A (struct))))

    ;; CHECK:       (type $B (sub $A (struct)))
    (type $B (sub $A (descriptor $B.desc (struct))))
    ;; CHECK:       (type $B.desc (sub $A.desc (struct)))
    (type $B.desc (sub $A.desc (describes $B (struct))))

    ;; CHECK:       (type $C (sub $B (struct)))
    (type $C (sub $B (descriptor $C.desc (struct))))
    ;; CHECK:       (type $C.desc (sub $B.desc (struct)))
    (type $C.desc (sub $B.desc (describes $C (struct))))
  )

  ;; CHECK:       (type $6 (func))

  ;; CHECK:      (func $test (type $6)
  ;; CHECK-NEXT:  (local $A (ref $A))
  ;; CHECK-NEXT:  (local $A.desc (ref $A.desc))
  ;; CHECK-NEXT:  (local $B (ref $B))
  ;; CHECK-NEXT:  (local $B.desc (ref $B.desc))
  ;; CHECK-NEXT:  (local $C (ref $C))
  ;; CHECK-NEXT:  (local $C.desc (ref $C.desc))
  ;; CHECK-NEXT:  (local.set $A
  ;; CHECK-NEXT:   (struct.new_default $A)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $B
  ;; CHECK-NEXT:   (struct.new_default $B)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $C
  ;; CHECK-NEXT:   (struct.new_default $C)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $test
    (local $A (ref $A))
    (local $A.desc (ref $A.desc))
    (local $B (ref $B))
    (local $B.desc (ref $B.desc))
    (local $C (ref $C))
    (local $C.desc (ref $C.desc))
    (local.set $A
      (struct.new $A
        (struct.new $A.desc)
      )
    )
    (local.set $B
      (struct.new $B
        (struct.new $B.desc)
      )
    )
    (local.set $C
      (struct.new $C
        (struct.new $C.desc)
      )
    )
  )
)

;; As above, but add a use of $A's descriptor. We cannot remove a descriptor
;; without removing it from supertypes, so we cannot optimize anything.
(module
  (rec
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $A (sub (descriptor $A.desc (struct))))
    (type $A (sub (descriptor $A.desc (struct))))
    ;; CHECK:       (type $A.desc (sub (describes $A (struct))))
    (type $A.desc (sub (describes $A (struct))))

    ;; CHECK:       (type $B (sub $A (descriptor $B.desc (struct))))
    (type $B (sub $A (descriptor $B.desc (struct))))
    ;; CHECK:       (type $B.desc (sub $A.desc (describes $B (struct))))
    (type $B.desc (sub $A.desc (describes $B (struct))))

    ;; CHECK:       (type $C (sub $B (descriptor $C.desc (struct))))
    (type $C (sub $B (descriptor $C.desc (struct))))
    ;; CHECK:       (type $C.desc (sub $B.desc (describes $C (struct))))
    (type $C.desc (sub $B.desc (describes $C (struct))))
  )

  ;; CHECK:      (type $6 (func))

  ;; CHECK:      (func $test (type $6)
  ;; CHECK-NEXT:  (local $A (ref $A))
  ;; CHECK-NEXT:  (local $A.desc (ref $A.desc))
  ;; CHECK-NEXT:  (local $B (ref $B))
  ;; CHECK-NEXT:  (local $B.desc (ref $B.desc))
  ;; CHECK-NEXT:  (local $C (ref $C))
  ;; CHECK-NEXT:  (local $C.desc (ref $C.desc))
  ;; CHECK-NEXT:  (local.set $A
  ;; CHECK-NEXT:   (struct.new_default $A
  ;; CHECK-NEXT:    (struct.new_default $A.desc)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $B
  ;; CHECK-NEXT:   (struct.new_default $B
  ;; CHECK-NEXT:    (struct.new_default $B.desc)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $C
  ;; CHECK-NEXT:   (struct.new_default $C
  ;; CHECK-NEXT:    (struct.new_default $C.desc)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (ref.get_desc $A
  ;; CHECK-NEXT:    (local.get $A)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $test
    (local $A (ref $A))
    (local $A.desc (ref $A.desc))
    (local $B (ref $B))
    (local $B.desc (ref $B.desc))
    (local $C (ref $C))
    (local $C.desc (ref $C.desc))
    (local.set $A
      (struct.new $A
        (struct.new $A.desc)
      )
    )
    (local.set $B
      (struct.new $B
        (struct.new $B.desc)
      )
    )
    (local.set $C
      (struct.new $C
        (struct.new $C.desc)
      )
    )
    ;; This is new.
    (drop
      (ref.get_desc $A
        (local.get $A)
      )
    )
  )
)

;; As above, but use $B's. Now we can optimize $A's descriptor, but we need to
;; give it a placeholder type to describe.
(module
  (rec
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $A (sub (struct)))
    (type $A (sub (descriptor $A.desc (struct))))
    ;; CHECK:       (type $1 (sub (descriptor $A.desc (struct))))

    ;; CHECK:       (type $A.desc (sub (describes $1 (struct))))
    (type $A.desc (sub (describes $A (struct))))

    ;; CHECK:       (type $B (sub $A (descriptor $B.desc (struct))))
    (type $B (sub $A (descriptor $B.desc (struct))))
    ;; CHECK:       (type $B.desc (sub $A.desc (describes $B (struct))))
    (type $B.desc (sub $A.desc (describes $B (struct))))

    ;; CHECK:       (type $C (sub $B (descriptor $C.desc (struct))))
    (type $C (sub $B (descriptor $C.desc (struct))))
    ;; CHECK:       (type $C.desc (sub $B.desc (describes $C (struct))))
    (type $C.desc (sub $B.desc (describes $C (struct))))
  )

  ;; CHECK:       (type $7 (func))

  ;; CHECK:      (func $test (type $7)
  ;; CHECK-NEXT:  (local $A (ref $A))
  ;; CHECK-NEXT:  (local $A.desc (ref $A.desc))
  ;; CHECK-NEXT:  (local $B (ref $B))
  ;; CHECK-NEXT:  (local $B.desc (ref $B.desc))
  ;; CHECK-NEXT:  (local $C (ref $C))
  ;; CHECK-NEXT:  (local $C.desc (ref $C.desc))
  ;; CHECK-NEXT:  (local.set $A
  ;; CHECK-NEXT:   (struct.new_default $A)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $B
  ;; CHECK-NEXT:   (struct.new_default $B
  ;; CHECK-NEXT:    (struct.new_default $B.desc)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $C
  ;; CHECK-NEXT:   (struct.new_default $C
  ;; CHECK-NEXT:    (struct.new_default $C.desc)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (ref.get_desc $B
  ;; CHECK-NEXT:    (local.get $B)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $test
    (local $A (ref $A))
    (local $A.desc (ref $A.desc))
    (local $B (ref $B))
    (local $B.desc (ref $B.desc))
    (local $C (ref $C))
    (local $C.desc (ref $C.desc))
    (local.set $A
      (struct.new $A
        (struct.new $A.desc)
      )
    )
    (local.set $B
      (struct.new $B
        (struct.new $B.desc)
      )
    )
    (local.set $C
      (struct.new $C
        (struct.new $C.desc)
      )
    )
    ;; This changed.
    (drop
      (ref.get_desc $B
        (local.get $B)
      )
    )
  )
)

;; As above, with $C. Now we optimize $A and $B with placeholders.
(module
  (rec
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $A (sub (struct)))
    (type $A (sub (descriptor $A.desc (struct))))
    ;; CHECK:       (type $1 (sub (descriptor $A.desc (struct))))

    ;; CHECK:       (type $A.desc (sub (describes $1 (struct))))
    (type $A.desc (sub (describes $A (struct))))

    ;; CHECK:       (type $B (sub $A (struct)))
    (type $B (sub $A (descriptor $B.desc (struct))))
    ;; CHECK:       (type $4 (sub (descriptor $B.desc (struct))))

    ;; CHECK:       (type $B.desc (sub $A.desc (describes $4 (struct))))
    (type $B.desc (sub $A.desc (describes $B (struct))))

    ;; CHECK:       (type $C (sub $B (descriptor $C.desc (struct))))
    (type $C (sub $B (descriptor $C.desc (struct))))
    ;; CHECK:       (type $C.desc (sub $B.desc (describes $C (struct))))
    (type $C.desc (sub $B.desc (describes $C (struct))))
  )

  ;; CHECK:       (type $8 (func))

  ;; CHECK:      (func $test (type $8)
  ;; CHECK-NEXT:  (local $A (ref $A))
  ;; CHECK-NEXT:  (local $A.desc (ref $A.desc))
  ;; CHECK-NEXT:  (local $B (ref $B))
  ;; CHECK-NEXT:  (local $B.desc (ref $B.desc))
  ;; CHECK-NEXT:  (local $C (ref $C))
  ;; CHECK-NEXT:  (local $C.desc (ref $C.desc))
  ;; CHECK-NEXT:  (local.set $A
  ;; CHECK-NEXT:   (struct.new_default $A)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $B
  ;; CHECK-NEXT:   (struct.new_default $B)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $C
  ;; CHECK-NEXT:   (struct.new_default $C
  ;; CHECK-NEXT:    (struct.new_default $C.desc)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (ref.get_desc $C
  ;; CHECK-NEXT:    (local.get $C)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $test
    (local $A (ref $A))
    (local $A.desc (ref $A.desc))
    (local $B (ref $B))
    (local $B.desc (ref $B.desc))
    (local $C (ref $C))
    (local $C.desc (ref $C.desc))
    (local.set $A
      (struct.new $A
        (struct.new $A.desc)
      )
    )
    (local.set $B
      (struct.new $B
        (struct.new $B.desc)
      )
    )
    (local.set $C
      (struct.new $C
        (struct.new $C.desc)
      )
    )
    ;; This changed.
    (drop
      (ref.get_desc $C
        (local.get $C)
      )
    )
  )
)

;; Here we cannot optimize with placeholders because the public supertype needs
;; to keep its descriptor and its subtypes therefore need to keep their related
;; descriptors.
(module
  (rec
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $public (sub (descriptor $public.desc (struct))))
    (type $public (sub (descriptor $public.desc (struct))))
    ;; CHECK:       (type $public.desc (sub (describes $public (struct))))
    (type $public.desc (sub (describes $public (struct))))
  )
  (rec
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $unused (sub $public (descriptor $unused.desc (struct))))
    (type $unused (sub $public (descriptor $unused.desc (struct))))
    ;; CHECK:       (type $unused.desc (sub $public.desc (describes $unused (struct))))
    (type $unused.desc (sub $public.desc (describes $unused (struct))))

    ;; CHECK:       (type $used (sub $unused (descriptor $used.desc (struct))))
    (type $used (sub $unused (descriptor $used.desc (struct))))
    ;; CHECK:       (type $used.desc (sub $unused.desc (describes $used (struct))))
    (type $used.desc (sub $unused.desc (describes $used (struct))))
  )

  ;; CHECK:      (type $6 (func (param (ref $used)) (result (ref $used.desc))))

  ;; CHECK:      (global $public (ref null $public) (ref.null none))
  (global $public (export "public") (ref null $public) (ref.null none))

  ;; CHECK:      (export "public" (global $public))

  ;; CHECK:      (func $use (type $6) (param $used (ref $used)) (result (ref $used.desc))
  ;; CHECK-NEXT:  (ref.get_desc $used
  ;; CHECK-NEXT:   (local.get $used)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $use (param $used (ref $used)) (result (ref $used.desc))
    (ref.get_desc $used
      (local.get $used)
    )
  )
)

;; Now the public supertype does not have a descriptor, so we can still
;; optimize.
(module
  (rec
    ;; CHECK:      (type $public (sub (struct)))
    (type $public (sub (struct)))
  )
  (rec
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $unused (sub $public (struct)))
    (type $unused (sub $public (descriptor $unused.desc (struct))))
    ;; CHECK:       (type $2 (sub (descriptor $unused.desc (struct))))

    ;; CHECK:       (type $unused.desc (sub (describes $2 (struct))))
    (type $unused.desc (sub (describes $unused (struct))))

    ;; CHECK:       (type $used (sub $unused (descriptor $used.desc (struct))))
    (type $used (sub $unused (descriptor $used.desc (struct))))
    ;; CHECK:       (type $used.desc (sub $unused.desc (describes $used (struct))))
    (type $used.desc (sub $unused.desc (describes $used (struct))))
  )

  ;; CHECK:       (type $6 (func (param (ref $used)) (result (ref $used.desc))))

  ;; CHECK:      (global $public (ref null $public) (ref.null none))
  (global $public (export "public") (ref null $public) (ref.null none))

  ;; CHECK:      (export "public" (global $public))

  ;; CHECK:      (func $use (type $6) (param $used (ref $used)) (result (ref $used.desc))
  ;; CHECK-NEXT:  (ref.get_desc $used
  ;; CHECK-NEXT:   (local.get $used)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $use (param $used (ref $used)) (result (ref $used.desc))
    (ref.get_desc $used
      (local.get $used)
    )
  )
)

;; Now we can optimize $A with a placeholder, but the placeholder must be
;; shared.
(module
  (rec
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $A (sub (shared (struct))))
    (type $A (sub (shared (descriptor $A.desc (struct)))))
    ;; CHECK:       (type $1 (sub (shared (descriptor $A.desc (struct)))))

    ;; CHECK:       (type $A.desc (sub (shared (describes $1 (struct)))))
    (type $A.desc (sub (shared (describes $A (struct)))))

    ;; CHECK:       (type $B (sub $A (shared (descriptor $B.desc (struct)))))
    (type $B (sub $A (shared (descriptor $B.desc (struct)))))
    ;; CHECK:       (type $B.desc (sub $A.desc (shared (describes $B (struct)))))
    (type $B.desc (sub $A.desc (shared (describes $B (struct)))))
  )

  ;; CHECK:       (type $5 (func))

  ;; CHECK:      (func $test (type $5)
  ;; CHECK-NEXT:  (local $A (ref $A))
  ;; CHECK-NEXT:  (local $A.desc (ref $A.desc))
  ;; CHECK-NEXT:  (local $B (ref $B))
  ;; CHECK-NEXT:  (local $B.desc (ref $B.desc))
  ;; CHECK-NEXT:  (local.set $A
  ;; CHECK-NEXT:   (struct.new_default $A)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $B
  ;; CHECK-NEXT:   (struct.new_default $B
  ;; CHECK-NEXT:    (struct.new_default $B.desc)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (ref.get_desc $B
  ;; CHECK-NEXT:    (local.get $B)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $test
    (local $A (ref $A))
    (local $A.desc (ref $A.desc))
    (local $B (ref $B))
    (local $B.desc (ref $B.desc))
    (local.set $A
      (struct.new $A
        (struct.new $A.desc)
      )
    )
    (local.set $B
      (struct.new $B
        (struct.new $B.desc)
      )
    )
    (drop
      (ref.get_desc $B
        (local.get $B)
      )
    )
  )
)

;; Here we would optimize $unused with a placeholder, except that we don't
;; include it in the output at all because it is unused. We should not get
;; confused and try to emit a placeholder for it anyway.
(module
  (rec
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $public (sub (descriptor $public.desc (struct))))
    (type $public (sub (descriptor $public.desc (struct))))
    ;; CHECK:       (type $public.desc (sub (describes $public (struct))))
    (type $public.desc (sub (describes $public (struct))))
  )
  (rec
    (type $unused (descriptor $unused.desc (struct)))
    (type $unused.desc (sub $public.desc (describes $unused (struct))))
    ;; CHECK:      (type $private (struct))
    (type $private (struct))
  )

  ;; CHECK:      (global $public (ref null $public) (ref.null none))
  (global $public (export "public") (ref null $public) (ref.null none))
  ;; CHECK:      (global $private (ref null $private) (ref.null none))
  (global $private (ref null $private) (ref.null none))
)

;; Regression test for a bug where we accidentally replaced empty struct types
;; with placeholders.
;; CHECK:      (export "public" (global $public))
(module
  ;; CHECK:      (type $public (struct))
  (type $public (struct))
  (rec
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $super (sub (struct)))
    (type $super (sub (descriptor $super.desc (struct))))
    ;; CHECK:       (type $2 (sub (descriptor $super.desc (struct))))

    ;; CHECK:       (type $super.desc (sub (describes $2 (struct))))
    (type $super.desc (sub (describes $super (struct))))
    ;; CHECK:       (type $sub (sub $super (descriptor $sub.desc (struct))))
    (type $sub (sub $super (descriptor $sub.desc (struct))))
    ;; CHECK:       (type $sub.desc (sub $super.desc (describes $sub (struct))))
    (type $sub.desc (sub $super.desc (describes $sub (struct))))
  )

  ;; CHECK:       (type $6 (func (param (ref $sub))))

  ;; CHECK:      (global $public (ref null $public) (ref.null none))
  (global $public (export "public") (ref null $public) (ref.null none))

  ;; CHECK:      (export "public" (global $public))

  ;; CHECK:      (func $test (type $6) (param $sub (ref $sub))
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (ref.get_desc $sub
  ;; CHECK-NEXT:    (local.get $sub)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.new_default $public)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $test (param $sub (ref $sub))
    ;; Use $sub's descriptor to keep it a descriptor. This forces $super.desc to
    ;; describe a placeholder.
    (drop
      (ref.get_desc $sub
        (local.get $sub)
      )
    )
    ;; We should not accidentally replace this trivial struct with the
    ;; placeholder, which would cause a validation failure because we do not
    ;; supply a descriptor in this allocation.
    (drop
      (struct.new_default $public)
    )
  )
)

;; Regression test for a bug where a placeholder was not set up to be described
;; by its intended descriptor if that intended descriptor also happened to have
;; its own unneeded descriptor.
(module
 (rec
  ;; CHECK:      (rec
  ;; CHECK-NEXT:  (type $public (descriptor $public.desc (struct)))
  (type $public (descriptor $public.desc (struct)))
  ;; CHECK:       (type $public.desc (sub (describes $public (struct))))
  (type $public.desc (sub (describes $public (struct))))
 )
 (rec
  ;; CHECK:      (rec
  ;; CHECK-NEXT:  (type $private (struct))
  (type $private (descriptor $private.desc (struct)))
  ;; CHECK:       (type $3 (sub (descriptor $private.desc (struct))))

  ;; CHECK:       (type $private.desc (sub $public.desc (describes $3 (struct))))
  (type $private.desc (sub $public.desc (describes $private (descriptor $private.meta (struct)))))
  ;; CHECK:       (type $private.meta (struct))
  (type $private.meta (describes $private.desc (struct)))
 )

 ;; Force $private.desc to remain a descriptor.
 ;; CHECK:      (global $public (ref null $public) (ref.null none))
 (global $public (export "public") (ref null $public) (ref.null none))

 ;; CHECK:      (global $private (ref null $private) (ref.null none))
 (global $private (ref null $private) (ref.null none))
)

;; Sibling types $A and $B. The supertype that connects them should not stop us
;; from optimizing $B here, even though $A cannot be optimized.
;; CHECK:      (export "public" (global $public))
(module
  (rec
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $super (sub (struct)))
    (type $super (sub (struct)))

    ;; CHECK:       (type $A (sub $super (descriptor $A.desc (struct))))
    (type $A (sub $super (descriptor $A.desc (struct))))
    ;; CHECK:       (type $A.desc (describes $A (struct)))
    (type $A.desc (describes $A (struct)))

    ;; CHECK:       (type $B (sub $super (struct)))
    (type $B (sub $super (descriptor $B.desc (struct))))
    ;; CHECK:       (type $B.desc (struct))
    (type $B.desc (describes $B (struct)))
  )

  ;; CHECK:       (type $5 (func (param (ref $A))))

  ;; CHECK:      (func $test (type $5) (param $A (ref $A))
  ;; CHECK-NEXT:  (local $B (ref $B))
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (ref.get_desc $A
  ;; CHECK-NEXT:    (local.get $A)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $test (param $A (ref $A))
    (local $B (ref $B))
    (drop
      (ref.get_desc $A
        (local.get $A)
      )
    )
  )
)

;; As above, but now with a cast of the supertype. We can still optimize $B but
;; not $A.
(module
  (rec
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $super (sub (struct)))
    (type $super (sub (struct)))

    ;; CHECK:       (type $A (sub $super (descriptor $A.desc (struct))))
    (type $A (sub $super (descriptor $A.desc (struct))))
    ;; CHECK:       (type $A.desc (describes $A (struct)))
    (type $A.desc (describes $A (struct)))

    ;; CHECK:       (type $B (sub $super (struct)))
    (type $B (sub $super (descriptor $B.desc (struct))))
    ;; CHECK:       (type $B.desc (struct))
    (type $B.desc (describes $B (struct)))
  )

  ;; CHECK:       (type $5 (func (param (ref $super) (ref (exact $A.desc))) (result anyref)))

  ;; CHECK:      (func $test (type $5) (param $ref (ref $super)) (param $desc (ref (exact $A.desc))) (result anyref)
  ;; CHECK-NEXT:  (local $B (ref $B))
  ;; CHECK-NEXT:  (ref.cast_desc (ref (exact $A))
  ;; CHECK-NEXT:   (local.get $ref)
  ;; CHECK-NEXT:   (local.get $desc)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $test (param $ref (ref $super)) (param $desc (ref (exact $A.desc))) (result anyref)
    (local $B (ref $B))
    (ref.cast_desc (ref (exact $A))
      (local.get $ref)
      (local.get $desc)
    )
  )
)

;; As above, but now with a cast of a basic type. We can still optimize $B but
;; not $A.
(module
  (rec
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $A (sub (descriptor $A.desc (struct))))
    (type $A (sub (descriptor $A.desc (struct))))
    ;; CHECK:       (type $A.desc (sub (describes $A (struct))))
    (type $A.desc (sub (describes $A (struct))))

    ;; CHECK:       (type $B (sub (struct)))
    (type $B (sub (descriptor $B.desc (struct))))
    ;; CHECK:       (type $B.desc (sub (struct)))
    (type $B.desc (sub (describes $B (struct))))
  )

  ;; CHECK:       (type $4 (func (param anyref (ref (exact $A.desc))) (result (ref (exact $A)))))

  ;; CHECK:      (func $cast_anyref (type $4) (param $ref anyref) (param $desc (ref (exact $A.desc))) (result (ref (exact $A)))
  ;; CHECK-NEXT:  (local $B (ref $B))
  ;; CHECK-NEXT:  (ref.cast_desc (ref (exact $A))
  ;; CHECK-NEXT:   (local.get $ref)
  ;; CHECK-NEXT:   (local.get $desc)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $cast_anyref (param $ref anyref) (param $desc (ref (exact $A.desc))) (result (ref (exact $A)))
    (local $B (ref $B))
    ;; The cast input is anyref. That means any struct could be sent in, but we
    ;; only need to prevent optimization of $A, who is the cast output. $B can
    ;; still be optimized.
    (ref.cast_desc (ref (exact $A))
      (local.get $ref)
      (local.get $desc)
    )
  )
)

;; We can optimize away the descriptor since its only use is unreachable, but
;; we must update that use to remain valid despite being unreachable.
(module
  (rec
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $struct (sub (struct)))
    (type $struct (sub (descriptor $desc (struct))))
    ;; CHECK:       (type $desc (sub (struct)))
    (type $desc (sub (describes $struct (struct))))
  )
  ;; CHECK:       (type $2 (func))

  ;; CHECK:      (func $test (type $2)
  ;; CHECK-NEXT:  (local $struct (ref $struct))
  ;; CHECK-NEXT:  (local $desc (ref $desc))
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $test
    (local $struct (ref $struct))
    (local $desc (ref $desc))
    (drop
      (ref.cast_desc (ref $struct)
        (unreachable)
        (struct.new $desc)
      )
    )
  )
)

