from _typeshed import ReadableBuffer
from typing import Literal

__all__ = [
    "aes_cbc_decrypt",
    "aes_cbc_decrypt_bytes",
    "aes_cbc_encrypt",
    "aes_cbc_encrypt_bytes",
    "aes_ctr_decrypt",
    "aes_ctr_encrypt",
    "aes_decrypt",
    "aes_decrypt_text",
    "aes_ecb_decrypt",
    "aes_ecb_encrypt",
    "aes_encrypt",
    "aes_gcm_decrypt_and_verify",
    "aes_gcm_decrypt_and_verify_bytes",
    "key_expansion",
    "pad_block",
    "pkcs7_padding",
    "unpad_pkcs7",
]

def aes_cbc_decrypt_bytes(data: bytes, key: bytes, iv: bytes) -> bytes: ...
def aes_gcm_decrypt_and_verify_bytes(data: bytes, key: bytes, tag: bytes, nonce: bytes) -> bytes: ...
def aes_cbc_encrypt_bytes(
    data: bytes, key: bytes, iv: bytes, *, padding_mode: Literal["pkcs7", "iso7816", "whitespace", "zero"]
) -> bytes: ...
def unpad_pkcs7(data: list[int]) -> list[int]: ...
def pkcs7_padding(data: list[int]) -> list[int]: ...
def pad_block(block: list[int], padding_mode: Literal["pkcs7", "iso7816", "whitespace", "zero"]) -> list[int]: ...
def aes_ecb_encrypt(data: list[int], key: list[int], iv: list[int] | None = None) -> list[int]: ...
def aes_ecb_decrypt(data: list[int], key: list[int], iv: list[int] | None = None) -> list[int]: ...
def aes_ctr_decrypt(data: list[int], key: list[int], iv: list[int]) -> list[int]: ...
def aes_ctr_encrypt(data: list[int], key: list[int], iv: list[int]) -> list[int]: ...
def aes_cbc_decrypt(data: list[int], key: list[int], iv: list[int]) -> list[int]: ...
def aes_cbc_encrypt(data: list[int], key: list[int], iv: list[int], *, padding_mode: str = "pkcs7") -> list[int]: ...
def aes_gcm_decrypt_and_verify(data: list[int], key: list[int], tag: list[int], nonce: list[int]) -> list[int]: ...
def aes_encrypt(data: list[int], expanded_key: list[int]) -> list[int]: ...
def aes_decrypt(data: list[int], expanded_key: list[int]) -> list[int]: ...
def aes_decrypt_text(data: str | ReadableBuffer, password: str, key_size_bytes: int) -> str: ...
def key_expansion(data: list[int]) -> list[int]: ...
