%feature("docstring") OT::LeastSquaresMetaModelSelection
"Least squares metamodel selection factory.

Adaptative sparse selection, as proposed in [blatman2009]_.

See also
--------
ApproximationAlgorithm, PenalizedLeastSquaresAlgorithm

Notes
-----
The LeastSquaresMetaModelSelection is built from a :class:`~openturns.LeastSquaresMetaModelSelectionFactory`.
The stopping criteria for the model selection is defined through the following entries of the
:class:`~openturns.ResourceMap`: 

- *LeastSquaresMetaModelSelection-ErrorThreshold*: if the error computed by cross validation is lesser than this threshold,
   then the exploration is stopped. The default value is 0: this criteria is not activated by default.
- *LeastSquaresMetaModelSelection-MaximumError*: if the error computed by cross validation is greater than this threshold,
   then the exploration is stopped (the error first decreases then increases when the basis complexity increases). The best
   approximation obtained so far is returned. The default value is 0.5.
- *LeastSquaresMetaModelSelection-alpha*: through the exploration, the minimum error :math:`e_{min}` is stored. If the
   current error is greater than :math:`\\alpha \\times e_{min}`, then the exploration is stopped. The best approximation
   obtained so far
   is returned. The default value is 2. This value allows one to filter little fluctuations in the error computation.

"

// ---------------------------------------------------------------------

%feature("docstring") OT::LeastSquaresMetaModelSelection::getBasisSequenceFactory
"Accessor to the basis sequence factory.

Returns
-------
basisSequenceFactory : :class:`~openturns.BasisSequenceFactory`
    Basis sequence factory."

// ---------------------------------------------------------------------

%feature("docstring") OT::LeastSquaresMetaModelSelection::setBasisSequenceFactory
"Set the basis sequence factory.

Parameters
----------
basisSequenceFactory : :class:`~openturns.BasisSequenceFactory`
    Basis sequence factory."

// ---------------------------------------------------------------------

%feature("docstring") OT::LeastSquaresMetaModelSelection::getFittingAlgorithm
"Accessor to the fitting algorithm.

Returns
-------
fittingAlgorithm : :class:`~openturns.FittingAlgorithm`
    Fitting algorithm."

// ---------------------------------------------------------------------

%feature("docstring") OT::LeastSquaresMetaModelSelection::setFittingAlgorithm
"Set the fitting algorithm.

Parameters
----------
fittingAlgorithm : :class:`~openturns.FittingAlgorithm`
    Fitting algorithm."
