%feature("docstring") OT::Beta
"Beta distribution.

Its probability density function is defined as:

.. math::

    f_X(x) = \\frac{(x - a)^{\\alpha - 1} (b - x)^{\\beta - 1}}
                  {(b - a)^{\\alpha + \\beta - 1} {\\rm B}(\\alpha, \\beta)},
                  \\quad x \\in [a, b]

with :math:`\\alpha, \\beta > 0` and :math:`a < b` and where :math:`\\rm B` denotes
Euler's beta function :meth:`~openturns.SpecFunc.Beta`.

Its first moments are:

.. math::
    :nowrap:

    \\begin{eqnarray*}
        \\Expect{X} & = & a + (b - a)\\frac{\\alpha}{\\alpha + \\beta} \\\\
        \\Var{X} & = & (b - a)^2 \\frac{\\alpha \\beta}{(\\alpha + \\beta)^2(\\alpha + \\beta + 1)}
    \\end{eqnarray*}

Parameters
----------
alpha : float
    Shape parameter :math:`\\alpha > 0`.

    Default value is 2.0.
beta : float
    Shape parameter :math:`\\beta > 0`.

    Default value is 2.0.
a : float
    Lower bound.

    Default value is -1.0.
b : float, :math:`b > a`
    Upper bound.

    Default value is 1.0.

Notes
-----
It is possible to create a Beta distribution from the alternative parametrization :math:`(\\mu, \\sigma, a, b)`: see  :class:`~openturns.BetaMuSigma`. In that case, all the results are presented in that new parametrization.

In order to use the alternative parametrization :math:`(\\mu, \\sigma, a, b)` only to create the distribution, see the example below: all the results will be presented in the native parametrization :math:`(\\alpha, \\beta, a, b)`.

Examples
--------
Create a distribution from its native parameters :math:`(\\alpha, \\beta, a, b)`:

>>> import openturns as ot
>>> myDist = ot.Beta(1.0, 2.0, 1.0, 5.0)

Create it from the alternative parametrization :math:`(\\mu, \\sigma, a, b)`:

>>> myDist2 = ot.Beta()
>>> myDist2.setParameter(ot.BetaMuSigma()([3.0, 1.15, 1.0, 5.0]))

Create it from :math:`(\\mu, \\sigma, a, b)` and keep that parametrization for the remaining study: 

>>> myParam = ot.BetaMuSigma(3.0, 1.15, 1.0, 5.0)
>>> myDist3 = ot.ParametrizedDistribution(myParam)

Draw a sample:

>>> sample = myDist.getSample(5)"

// ---------------------------------------------------------------------

%feature("docstring") OT::Beta::getAlpha
"Accessor to the distribution's shape parameter :math:`\\alpha`.

Returns
-------
alpha : float
    Shape parameter :math:`\\alpha`."

// ---------------------------------------------------------------------

%feature("docstring") OT::Beta::getBeta
"Accessor to the distribution's shape parameter :math:`\\beta`.

Returns
-------
beta : float
    Shape parameter :math:`\\beta`."

// ---------------------------------------------------------------------

%feature("docstring") OT::Beta::getA
"Accessor to the distribution's lower bound.

Returns
-------
a : float
    Lower bound."

// ---------------------------------------------------------------------

%feature("docstring") OT::Beta::getB
"Accessor to the distribution's upper bound.

Returns
-------
b : float
    Upper bound."

// ---------------------------------------------------------------------

%feature("docstring") OT::Beta::getMu
"Accessor to the distribution's mean.

Returns
-------
mu : float
    Mean."

// ---------------------------------------------------------------------

%feature("docstring") OT::Beta::getSigma
"Accessor to the distribution's standard deviation.

Returns
-------
sigma : float, :math:`\\sigma > 0`
    Standard deviation."

// ---------------------------------------------------------------------

%feature("docstring") OT::Beta::setAlpha
"Accessor to the distribution's shape parameter :math:`\\alpha`.

Parameters
----------
alpha : float, :math:`\\alpha > 0`
    Shape parameter :math:`\\alpha`."

// ---------------------------------------------------------------------

%feature("docstring") OT::Beta::setBeta
"Accessor to the distribution's shape parameter :math:`\\beta`.

Parameters
----------
beta : float, :math:`\\beta > 0`
    Shape parameter :math:`\\beta`."

// ---------------------------------------------------------------------

%feature("docstring") OT::Beta::setA
"Accessor to the distribution's lower bound.

Parameters
----------
a : float, :math:`a < b`
    Lower bound."

// ---------------------------------------------------------------------

%feature("docstring") OT::Beta::setB
"Accessor to the distribution's upper bound.

Parameters
----------
b : float, :math:`b > a`
    Upper bound."

// ---------------------------------------------------------------------

%feature("docstring") OT::Beta::setMuSigma
"Accessor to the distribution's mean and standard deviation.

Parameters
----------
mu : float
    Mean.
sigma : float, :math:`\\sigma > 0`
    Standard deviation."

// ---------------------------------------------------------------------

%feature("docstring") OT::Beta::isElliptical
"Test whether the distribution is elliptical.

Returns
-------
test : bool
    Answer.
    
Notes
-----
The Beta distribution is elliptical if :math:`\\alpha = \\beta`.
"
