/* json-glib.h: Main header
 *
 * This file is part of JSON-GLib
 *
 * SPDX-FileCopyrightText: 2007  OpenedHand Ltd.
 * SPDX-FileCopyrightText: 2009  Intel Corp.
 * SPDX-License-Identifier: LGPL-2.1-or-later
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 *
 * Author:
 *   Emmanuele Bassi  <ebassi@linux.intel.com>
 */
#pragma once

#define __JSON_GLIB_INSIDE__

#include <json-glib/json-types.h>

#include <json-glib/json-builder.h>
#include <json-glib/json-generator.h>
#include <json-glib/json-parser.h>
#include <json-glib/json-path.h>
#include <json-glib/json-reader.h>
#include <json-glib/json-utils.h>
#include <json-glib/json-version.h>
#include <json-glib/json-version-macros.h>

#include <json-glib/json-enum-types.h>

#include <json-glib/json-gobject.h>

#include <json-glib/json-gvariant.h>

#undef __JSON_GLIB_INSIDE__
