/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimppainttools_pdb.h
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#if !defined (__GIMP_H_INSIDE__) && !defined (GIMP_COMPILATION)
#error "Only <libgimp/gimp.h> can be included directly."
#endif

#ifndef __GIMP_PAINT_TOOLS_PDB_H__
#define __GIMP_PAINT_TOOLS_PDB_H__

G_BEGIN_DECLS

/* For information look into the C source or the html documentation */


gboolean gimp_airbrush           (GimpDrawable             *drawable,
                                  gdouble                   pressure,
                                  gsize                     num_strokes,
                                  const gdouble            *strokes);
gboolean gimp_airbrush_default   (GimpDrawable             *drawable,
                                  gsize                     num_strokes,
                                  const gdouble            *strokes);
gboolean gimp_clone              (GimpDrawable             *drawable,
                                  GimpDrawable             *src_drawable,
                                  GimpCloneType             clone_type,
                                  gdouble                   src_x,
                                  gdouble                   src_y,
                                  gsize                     num_strokes,
                                  const gdouble            *strokes);
gboolean gimp_clone_default      (GimpDrawable             *drawable,
                                  gsize                     num_strokes,
                                  const gdouble            *strokes);
gboolean gimp_convolve           (GimpDrawable             *drawable,
                                  gdouble                   pressure,
                                  GimpConvolveType          convolve_type,
                                  gsize                     num_strokes,
                                  const gdouble            *strokes);
gboolean gimp_convolve_default   (GimpDrawable             *drawable,
                                  gsize                     num_strokes,
                                  const gdouble            *strokes);
gboolean gimp_dodgeburn          (GimpDrawable             *drawable,
                                  gdouble                   exposure,
                                  GimpDodgeBurnType         dodgeburn_type,
                                  GimpTransferMode          dodgeburn_mode,
                                  gsize                     num_strokes,
                                  const gdouble            *strokes);
gboolean gimp_dodgeburn_default  (GimpDrawable             *drawable,
                                  gsize                     num_strokes,
                                  const gdouble            *strokes);
gboolean gimp_eraser             (GimpDrawable             *drawable,
                                  gsize                     num_strokes,
                                  const gdouble            *strokes,
                                  GimpBrushApplicationMode  hardness,
                                  GimpPaintApplicationMode  method);
gboolean gimp_eraser_default     (GimpDrawable             *drawable,
                                  gsize                     num_strokes,
                                  const gdouble            *strokes);
gboolean gimp_heal               (GimpDrawable             *drawable,
                                  GimpDrawable             *src_drawable,
                                  gdouble                   src_x,
                                  gdouble                   src_y,
                                  gsize                     num_strokes,
                                  const gdouble            *strokes);
gboolean gimp_heal_default       (GimpDrawable             *drawable,
                                  gsize                     num_strokes,
                                  const gdouble            *strokes);
gboolean gimp_paintbrush         (GimpDrawable             *drawable,
                                  gdouble                   fade_out,
                                  gsize                     num_strokes,
                                  const gdouble            *strokes,
                                  GimpPaintApplicationMode  method,
                                  gdouble                   gradient_length);
gboolean gimp_paintbrush_default (GimpDrawable             *drawable,
                                  gsize                     num_strokes,
                                  const gdouble            *strokes);
gboolean gimp_pencil             (GimpDrawable             *drawable,
                                  gsize                     num_strokes,
                                  const gdouble            *strokes);
gboolean gimp_smudge             (GimpDrawable             *drawable,
                                  gdouble                   pressure,
                                  gsize                     num_strokes,
                                  const gdouble            *strokes);
gboolean gimp_smudge_default     (GimpDrawable             *drawable,
                                  gsize                     num_strokes,
                                  const gdouble            *strokes);


G_END_DECLS

#endif /* __GIMP_PAINT_TOOLS_PDB_H__ */
