// C++/WinRT v2.0.250303.1

// SPDX-License-Identifier: MIT OR Apache-2.0
// SPDX-FileCopyrightText: Copyright (c) Microsoft Corporation
//
// Generated using .winmd files from https://github.com/microsoft/windows-rs
//

#pragma once
#ifndef WINRT_Windows_Security_DataProtection_H
#define WINRT_Windows_Security_DataProtection_H
#include "winrt/base.h"
static_assert(winrt::check_version(CPPWINRT_VERSION, "2.0.250303.1"), "Mismatched C++/WinRT headers.");
#define CPPWINRT_VERSION "2.0.250303.1"
#include "winrt/impl/Windows.Foundation.2.h"
#include "winrt/impl/Windows.Storage.2.h"
#include "winrt/impl/Windows.Storage.Streams.2.h"
#include "winrt/impl/Windows.System.2.h"
#include "winrt/impl/Windows.Security.DataProtection.2.h"
namespace winrt::impl
{
    template <typename D> auto consume_Windows_Security_DataProtection_IUserDataAvailabilityStateChangedEventArgs<D>::GetDeferral() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Security::DataProtection::IUserDataAvailabilityStateChangedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Security::DataProtection::IUserDataAvailabilityStateChangedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Security::DataProtection::IUserDataAvailabilityStateChangedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetDeferral(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Security::DataProtection::IUserDataAvailabilityStateChangedEventArgs>**)this;
            check_hresult(_winrt_abi_type->GetDeferral(&result));
        }
        return winrt::Windows::Foundation::Deferral{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Security_DataProtection_IUserDataBufferUnprotectResult<D>::Status() const
    {
        winrt::Windows::Security::DataProtection::UserDataBufferUnprotectStatus value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Security::DataProtection::IUserDataBufferUnprotectResult>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Security::DataProtection::IUserDataBufferUnprotectResult, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Security::DataProtection::IUserDataBufferUnprotectResult>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Status(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Security::DataProtection::IUserDataBufferUnprotectResult>**)this;
            check_hresult(_winrt_abi_type->get_Status(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Security_DataProtection_IUserDataBufferUnprotectResult<D>::UnprotectedBuffer() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Security::DataProtection::IUserDataBufferUnprotectResult>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Security::DataProtection::IUserDataBufferUnprotectResult, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Security::DataProtection::IUserDataBufferUnprotectResult>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_UnprotectedBuffer(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Security::DataProtection::IUserDataBufferUnprotectResult>**)this;
            check_hresult(_winrt_abi_type->get_UnprotectedBuffer(&value));
        }
        return winrt::Windows::Storage::Streams::IBuffer{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Security_DataProtection_IUserDataProtectionManager<D>::ProtectStorageItemAsync(winrt::Windows::Storage::IStorageItem const& storageItem, winrt::Windows::Security::DataProtection::UserDataAvailability const& availability) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Security::DataProtection::IUserDataProtectionManager>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Security::DataProtection::IUserDataProtectionManager, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Security::DataProtection::IUserDataProtectionManager>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ProtectStorageItemAsync(*(void**)(&storageItem), static_cast<int32_t>(availability), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Security::DataProtection::IUserDataProtectionManager>**)this;
            check_hresult(_winrt_abi_type->ProtectStorageItemAsync(*(void**)(&storageItem), static_cast<int32_t>(availability), &result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Security::DataProtection::UserDataStorageItemProtectionStatus>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Security_DataProtection_IUserDataProtectionManager<D>::GetStorageItemProtectionInfoAsync(winrt::Windows::Storage::IStorageItem const& storageItem) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Security::DataProtection::IUserDataProtectionManager>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Security::DataProtection::IUserDataProtectionManager, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Security::DataProtection::IUserDataProtectionManager>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetStorageItemProtectionInfoAsync(*(void**)(&storageItem), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Security::DataProtection::IUserDataProtectionManager>**)this;
            check_hresult(_winrt_abi_type->GetStorageItemProtectionInfoAsync(*(void**)(&storageItem), &result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Security::DataProtection::UserDataStorageItemProtectionInfo>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Security_DataProtection_IUserDataProtectionManager<D>::ProtectBufferAsync(winrt::Windows::Storage::Streams::IBuffer const& unprotectedBuffer, winrt::Windows::Security::DataProtection::UserDataAvailability const& availability) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Security::DataProtection::IUserDataProtectionManager>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Security::DataProtection::IUserDataProtectionManager, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Security::DataProtection::IUserDataProtectionManager>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ProtectBufferAsync(*(void**)(&unprotectedBuffer), static_cast<int32_t>(availability), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Security::DataProtection::IUserDataProtectionManager>**)this;
            check_hresult(_winrt_abi_type->ProtectBufferAsync(*(void**)(&unprotectedBuffer), static_cast<int32_t>(availability), &result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::Streams::IBuffer>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Security_DataProtection_IUserDataProtectionManager<D>::UnprotectBufferAsync(winrt::Windows::Storage::Streams::IBuffer const& protectedBuffer) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Security::DataProtection::IUserDataProtectionManager>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Security::DataProtection::IUserDataProtectionManager, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Security::DataProtection::IUserDataProtectionManager>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->UnprotectBufferAsync(*(void**)(&protectedBuffer), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Security::DataProtection::IUserDataProtectionManager>**)this;
            check_hresult(_winrt_abi_type->UnprotectBufferAsync(*(void**)(&protectedBuffer), &result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Security::DataProtection::UserDataBufferUnprotectResult>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Security_DataProtection_IUserDataProtectionManager<D>::IsContinuedDataAvailabilityExpected(winrt::Windows::Security::DataProtection::UserDataAvailability const& availability) const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Security::DataProtection::IUserDataProtectionManager>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Security::DataProtection::IUserDataProtectionManager, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Security::DataProtection::IUserDataProtectionManager>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->IsContinuedDataAvailabilityExpected(static_cast<int32_t>(availability), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Security::DataProtection::IUserDataProtectionManager>**)this;
            check_hresult(_winrt_abi_type->IsContinuedDataAvailabilityExpected(static_cast<int32_t>(availability), &value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Security_DataProtection_IUserDataProtectionManager<D>::DataAvailabilityStateChanged(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Security::DataProtection::UserDataProtectionManager, winrt::Windows::Security::DataProtection::UserDataAvailabilityStateChangedEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Security::DataProtection::IUserDataProtectionManager>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Security::DataProtection::IUserDataProtectionManager, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Security::DataProtection::IUserDataProtectionManager>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_DataAvailabilityStateChanged(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Security::DataProtection::IUserDataProtectionManager>**)this;
            check_hresult(_winrt_abi_type->add_DataAvailabilityStateChanged(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_Security_DataProtection_IUserDataProtectionManager<D>::DataAvailabilityStateChanged(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Security::DataProtection::UserDataProtectionManager, winrt::Windows::Security::DataProtection::UserDataAvailabilityStateChangedEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, DataAvailabilityStateChanged_revoker>(this, DataAvailabilityStateChanged(handler));
    }
    template <typename D> auto consume_Windows_Security_DataProtection_IUserDataProtectionManager<D>::DataAvailabilityStateChanged(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Security::DataProtection::IUserDataProtectionManager>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Security::DataProtection::IUserDataProtectionManager, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Security::DataProtection::IUserDataProtectionManager>**)&_winrt_casted_result;
            _winrt_abi_type->remove_DataAvailabilityStateChanged(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Security::DataProtection::IUserDataProtectionManager>**)this;
            _winrt_abi_type->remove_DataAvailabilityStateChanged(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_Security_DataProtection_IUserDataProtectionManagerStatics<D>::TryGetDefault() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Security::DataProtection::IUserDataProtectionManagerStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Security::DataProtection::IUserDataProtectionManagerStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Security::DataProtection::IUserDataProtectionManagerStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TryGetDefault(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Security::DataProtection::IUserDataProtectionManagerStatics>**)this;
            check_hresult(_winrt_abi_type->TryGetDefault(&result));
        }
        return winrt::Windows::Security::DataProtection::UserDataProtectionManager{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Security_DataProtection_IUserDataProtectionManagerStatics<D>::TryGetForUser(winrt::Windows::System::User const& user) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Security::DataProtection::IUserDataProtectionManagerStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Security::DataProtection::IUserDataProtectionManagerStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Security::DataProtection::IUserDataProtectionManagerStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TryGetForUser(*(void**)(&user), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Security::DataProtection::IUserDataProtectionManagerStatics>**)this;
            check_hresult(_winrt_abi_type->TryGetForUser(*(void**)(&user), &result));
        }
        return winrt::Windows::Security::DataProtection::UserDataProtectionManager{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Security_DataProtection_IUserDataStorageItemProtectionInfo<D>::Availability() const
    {
        winrt::Windows::Security::DataProtection::UserDataAvailability value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Security::DataProtection::IUserDataStorageItemProtectionInfo>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Security::DataProtection::IUserDataStorageItemProtectionInfo, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Security::DataProtection::IUserDataStorageItemProtectionInfo>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Availability(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Security::DataProtection::IUserDataStorageItemProtectionInfo>**)this;
            check_hresult(_winrt_abi_type->get_Availability(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Security::DataProtection::IUserDataAvailabilityStateChangedEventArgs> : produce_base<D, winrt::Windows::Security::DataProtection::IUserDataAvailabilityStateChangedEventArgs>
    {
        int32_t __stdcall GetDeferral(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::Deferral>(this->shim().GetDeferral());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Security::DataProtection::IUserDataBufferUnprotectResult> : produce_base<D, winrt::Windows::Security::DataProtection::IUserDataBufferUnprotectResult>
    {
        int32_t __stdcall get_Status(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Security::DataProtection::UserDataBufferUnprotectStatus>(this->shim().Status());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_UnprotectedBuffer(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::Streams::IBuffer>(this->shim().UnprotectedBuffer());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Security::DataProtection::IUserDataProtectionManager> : produce_base<D, winrt::Windows::Security::DataProtection::IUserDataProtectionManager>
    {
        int32_t __stdcall ProtectStorageItemAsync(void* storageItem, int32_t availability, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Security::DataProtection::UserDataStorageItemProtectionStatus>>(this->shim().ProtectStorageItemAsync(*reinterpret_cast<winrt::Windows::Storage::IStorageItem const*>(&storageItem), *reinterpret_cast<winrt::Windows::Security::DataProtection::UserDataAvailability const*>(&availability)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetStorageItemProtectionInfoAsync(void* storageItem, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Security::DataProtection::UserDataStorageItemProtectionInfo>>(this->shim().GetStorageItemProtectionInfoAsync(*reinterpret_cast<winrt::Windows::Storage::IStorageItem const*>(&storageItem)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ProtectBufferAsync(void* unprotectedBuffer, int32_t availability, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Storage::Streams::IBuffer>>(this->shim().ProtectBufferAsync(*reinterpret_cast<winrt::Windows::Storage::Streams::IBuffer const*>(&unprotectedBuffer), *reinterpret_cast<winrt::Windows::Security::DataProtection::UserDataAvailability const*>(&availability)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall UnprotectBufferAsync(void* protectedBuffer, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Security::DataProtection::UserDataBufferUnprotectResult>>(this->shim().UnprotectBufferAsync(*reinterpret_cast<winrt::Windows::Storage::Streams::IBuffer const*>(&protectedBuffer)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall IsContinuedDataAvailabilityExpected(int32_t availability, bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsContinuedDataAvailabilityExpected(*reinterpret_cast<winrt::Windows::Security::DataProtection::UserDataAvailability const*>(&availability)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall add_DataAvailabilityStateChanged(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().DataAvailabilityStateChanged(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Security::DataProtection::UserDataProtectionManager, winrt::Windows::Security::DataProtection::UserDataAvailabilityStateChangedEventArgs> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_DataAvailabilityStateChanged(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().DataAvailabilityStateChanged(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Security::DataProtection::IUserDataProtectionManagerStatics> : produce_base<D, winrt::Windows::Security::DataProtection::IUserDataProtectionManagerStatics>
    {
        int32_t __stdcall TryGetDefault(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Security::DataProtection::UserDataProtectionManager>(this->shim().TryGetDefault());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall TryGetForUser(void* user, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Security::DataProtection::UserDataProtectionManager>(this->shim().TryGetForUser(*reinterpret_cast<winrt::Windows::System::User const*>(&user)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Security::DataProtection::IUserDataStorageItemProtectionInfo> : produce_base<D, winrt::Windows::Security::DataProtection::IUserDataStorageItemProtectionInfo>
    {
        int32_t __stdcall get_Availability(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Security::DataProtection::UserDataAvailability>(this->shim().Availability());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
}
WINRT_EXPORT namespace winrt::Windows::Security::DataProtection
{
    inline auto UserDataProtectionManager::TryGetDefault()
    {
        return impl::call_factory_cast<winrt::Windows::Security::DataProtection::UserDataProtectionManager(*)(IUserDataProtectionManagerStatics const&), UserDataProtectionManager, IUserDataProtectionManagerStatics>([](IUserDataProtectionManagerStatics const& f) { return f.TryGetDefault(); });
    }
    inline auto UserDataProtectionManager::TryGetForUser(winrt::Windows::System::User const& user)
    {
        return impl::call_factory<UserDataProtectionManager, IUserDataProtectionManagerStatics>([&](IUserDataProtectionManagerStatics const& f) { return f.TryGetForUser(user); });
    }
}
namespace std
{
#ifndef WINRT_LEAN_AND_MEAN
    template<> struct hash<winrt::Windows::Security::DataProtection::IUserDataAvailabilityStateChangedEventArgs> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Security::DataProtection::IUserDataBufferUnprotectResult> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Security::DataProtection::IUserDataProtectionManager> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Security::DataProtection::IUserDataProtectionManagerStatics> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Security::DataProtection::IUserDataStorageItemProtectionInfo> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Security::DataProtection::UserDataAvailabilityStateChangedEventArgs> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Security::DataProtection::UserDataBufferUnprotectResult> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Security::DataProtection::UserDataProtectionManager> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Security::DataProtection::UserDataStorageItemProtectionInfo> : winrt::impl::hash_base {};
#endif
#ifdef __cpp_lib_format
#endif
}
#endif
