// C++/WinRT v2.0.250303.1

// SPDX-License-Identifier: MIT OR Apache-2.0
// SPDX-FileCopyrightText: Copyright (c) Microsoft Corporation
//
// Generated using .winmd files from https://github.com/microsoft/windows-rs
//

#pragma once
#ifndef WINRT_Windows_Devices_Spi_H
#define WINRT_Windows_Devices_Spi_H
#include "winrt/base.h"
static_assert(winrt::check_version(CPPWINRT_VERSION, "2.0.250303.1"), "Mismatched C++/WinRT headers.");
#define CPPWINRT_VERSION "2.0.250303.1"
#include "winrt/Windows.Devices.h"
#include "winrt/impl/Windows.Devices.Spi.Provider.2.h"
#include "winrt/impl/Windows.Foundation.2.h"
#include "winrt/impl/Windows.Foundation.Collections.2.h"
#include "winrt/impl/Windows.Devices.Spi.2.h"
namespace winrt::impl
{
    template <typename D> auto consume_Windows_Devices_Spi_ISpiBusInfo<D>::ChipSelectLineCount() const
    {
        int32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::Spi::ISpiBusInfo>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::Spi::ISpiBusInfo, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiBusInfo>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ChipSelectLineCount(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiBusInfo>**)this;
            check_hresult(_winrt_abi_type->get_ChipSelectLineCount(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_Spi_ISpiBusInfo<D>::MinClockFrequency() const
    {
        int32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::Spi::ISpiBusInfo>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::Spi::ISpiBusInfo, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiBusInfo>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MinClockFrequency(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiBusInfo>**)this;
            check_hresult(_winrt_abi_type->get_MinClockFrequency(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_Spi_ISpiBusInfo<D>::MaxClockFrequency() const
    {
        int32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::Spi::ISpiBusInfo>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::Spi::ISpiBusInfo, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiBusInfo>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MaxClockFrequency(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiBusInfo>**)this;
            check_hresult(_winrt_abi_type->get_MaxClockFrequency(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_Spi_ISpiBusInfo<D>::SupportedDataBitLengths() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::Spi::ISpiBusInfo>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::Spi::ISpiBusInfo, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiBusInfo>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SupportedDataBitLengths(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiBusInfo>**)this;
            check_hresult(_winrt_abi_type->get_SupportedDataBitLengths(&value));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<int32_t>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_Spi_ISpiConnectionSettings<D>::ChipSelectLine() const
    {
        int32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::Spi::ISpiConnectionSettings>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::Spi::ISpiConnectionSettings, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiConnectionSettings>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ChipSelectLine(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiConnectionSettings>**)this;
            check_hresult(_winrt_abi_type->get_ChipSelectLine(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_Spi_ISpiConnectionSettings<D>::ChipSelectLine(int32_t value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::Spi::ISpiConnectionSettings>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::Spi::ISpiConnectionSettings, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiConnectionSettings>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_ChipSelectLine(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiConnectionSettings>**)this;
            check_hresult(_winrt_abi_type->put_ChipSelectLine(value));
        }
    }
    template <typename D> auto consume_Windows_Devices_Spi_ISpiConnectionSettings<D>::Mode() const
    {
        winrt::Windows::Devices::Spi::SpiMode value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::Spi::ISpiConnectionSettings>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::Spi::ISpiConnectionSettings, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiConnectionSettings>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Mode(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiConnectionSettings>**)this;
            check_hresult(_winrt_abi_type->get_Mode(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_Spi_ISpiConnectionSettings<D>::Mode(winrt::Windows::Devices::Spi::SpiMode const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::Spi::ISpiConnectionSettings>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::Spi::ISpiConnectionSettings, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiConnectionSettings>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Mode(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiConnectionSettings>**)this;
            check_hresult(_winrt_abi_type->put_Mode(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_Devices_Spi_ISpiConnectionSettings<D>::DataBitLength() const
    {
        int32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::Spi::ISpiConnectionSettings>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::Spi::ISpiConnectionSettings, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiConnectionSettings>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DataBitLength(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiConnectionSettings>**)this;
            check_hresult(_winrt_abi_type->get_DataBitLength(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_Spi_ISpiConnectionSettings<D>::DataBitLength(int32_t value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::Spi::ISpiConnectionSettings>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::Spi::ISpiConnectionSettings, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiConnectionSettings>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_DataBitLength(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiConnectionSettings>**)this;
            check_hresult(_winrt_abi_type->put_DataBitLength(value));
        }
    }
    template <typename D> auto consume_Windows_Devices_Spi_ISpiConnectionSettings<D>::ClockFrequency() const
    {
        int32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::Spi::ISpiConnectionSettings>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::Spi::ISpiConnectionSettings, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiConnectionSettings>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ClockFrequency(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiConnectionSettings>**)this;
            check_hresult(_winrt_abi_type->get_ClockFrequency(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_Spi_ISpiConnectionSettings<D>::ClockFrequency(int32_t value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::Spi::ISpiConnectionSettings>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::Spi::ISpiConnectionSettings, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiConnectionSettings>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_ClockFrequency(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiConnectionSettings>**)this;
            check_hresult(_winrt_abi_type->put_ClockFrequency(value));
        }
    }
    template <typename D> auto consume_Windows_Devices_Spi_ISpiConnectionSettings<D>::SharingMode() const
    {
        winrt::Windows::Devices::Spi::SpiSharingMode value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::Spi::ISpiConnectionSettings>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::Spi::ISpiConnectionSettings, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiConnectionSettings>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SharingMode(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiConnectionSettings>**)this;
            check_hresult(_winrt_abi_type->get_SharingMode(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_Spi_ISpiConnectionSettings<D>::SharingMode(winrt::Windows::Devices::Spi::SpiSharingMode const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::Spi::ISpiConnectionSettings>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::Spi::ISpiConnectionSettings, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiConnectionSettings>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_SharingMode(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiConnectionSettings>**)this;
            check_hresult(_winrt_abi_type->put_SharingMode(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_Devices_Spi_ISpiConnectionSettingsFactory<D>::Create(int32_t chipSelectLine) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::Spi::ISpiConnectionSettingsFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::Spi::ISpiConnectionSettingsFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiConnectionSettingsFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Create(chipSelectLine, &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiConnectionSettingsFactory>**)this;
            check_hresult(_winrt_abi_type->Create(chipSelectLine, &value));
        }
        return winrt::Windows::Devices::Spi::SpiConnectionSettings{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_Spi_ISpiController<D>::GetDevice(winrt::Windows::Devices::Spi::SpiConnectionSettings const& settings) const
    {
        void* device{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::Spi::ISpiController>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::Spi::ISpiController, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiController>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetDevice(*(void**)(&settings), &device));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiController>**)this;
            check_hresult(_winrt_abi_type->GetDevice(*(void**)(&settings), &device));
        }
        return winrt::Windows::Devices::Spi::SpiDevice{ device, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_Spi_ISpiControllerStatics<D>::GetDefaultAsync() const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::Spi::ISpiControllerStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::Spi::ISpiControllerStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiControllerStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetDefaultAsync(&operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiControllerStatics>**)this;
            check_hresult(_winrt_abi_type->GetDefaultAsync(&operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::Spi::SpiController>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_Spi_ISpiControllerStatics<D>::GetControllersAsync(winrt::Windows::Devices::Spi::Provider::ISpiProvider const& provider) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::Spi::ISpiControllerStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::Spi::ISpiControllerStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiControllerStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetControllersAsync(*(void**)(&provider), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiControllerStatics>**)this;
            check_hresult(_winrt_abi_type->GetControllersAsync(*(void**)(&provider), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Devices::Spi::SpiController>>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_Spi_ISpiDevice<D>::DeviceId() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::Spi::ISpiDevice>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::Spi::ISpiDevice, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiDevice>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DeviceId(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiDevice>**)this;
            check_hresult(_winrt_abi_type->get_DeviceId(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_Spi_ISpiDevice<D>::ConnectionSettings() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::Spi::ISpiDevice>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::Spi::ISpiDevice, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiDevice>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ConnectionSettings(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiDevice>**)this;
            check_hresult(_winrt_abi_type->get_ConnectionSettings(&value));
        }
        return winrt::Windows::Devices::Spi::SpiConnectionSettings{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_Spi_ISpiDevice<D>::Write(array_view<uint8_t const> buffer) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::Spi::ISpiDevice>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::Spi::ISpiDevice, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiDevice>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Write(buffer.size(), get_abi(buffer)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiDevice>**)this;
            check_hresult(_winrt_abi_type->Write(buffer.size(), get_abi(buffer)));
        }
    }
    template <typename D> auto consume_Windows_Devices_Spi_ISpiDevice<D>::Read(array_view<uint8_t> buffer) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::Spi::ISpiDevice>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::Spi::ISpiDevice, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiDevice>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Read(buffer.size(), put_abi(buffer)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiDevice>**)this;
            check_hresult(_winrt_abi_type->Read(buffer.size(), put_abi(buffer)));
        }
    }
    template <typename D> auto consume_Windows_Devices_Spi_ISpiDevice<D>::TransferSequential(array_view<uint8_t const> writeBuffer, array_view<uint8_t> readBuffer) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::Spi::ISpiDevice>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::Spi::ISpiDevice, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiDevice>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TransferSequential(writeBuffer.size(), get_abi(writeBuffer), readBuffer.size(), put_abi(readBuffer)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiDevice>**)this;
            check_hresult(_winrt_abi_type->TransferSequential(writeBuffer.size(), get_abi(writeBuffer), readBuffer.size(), put_abi(readBuffer)));
        }
    }
    template <typename D> auto consume_Windows_Devices_Spi_ISpiDevice<D>::TransferFullDuplex(array_view<uint8_t const> writeBuffer, array_view<uint8_t> readBuffer) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::Spi::ISpiDevice>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::Spi::ISpiDevice, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiDevice>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TransferFullDuplex(writeBuffer.size(), get_abi(writeBuffer), readBuffer.size(), put_abi(readBuffer)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiDevice>**)this;
            check_hresult(_winrt_abi_type->TransferFullDuplex(writeBuffer.size(), get_abi(writeBuffer), readBuffer.size(), put_abi(readBuffer)));
        }
    }
    template <typename D> auto consume_Windows_Devices_Spi_ISpiDeviceStatics<D>::GetDeviceSelector() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::Spi::ISpiDeviceStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::Spi::ISpiDeviceStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiDeviceStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetDeviceSelector(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiDeviceStatics>**)this;
            check_hresult(_winrt_abi_type->GetDeviceSelector(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_Spi_ISpiDeviceStatics<D>::GetDeviceSelector(param::hstring const& friendlyName) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::Spi::ISpiDeviceStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::Spi::ISpiDeviceStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiDeviceStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetDeviceSelectorFromFriendlyName(*(void**)(&friendlyName), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiDeviceStatics>**)this;
            check_hresult(_winrt_abi_type->GetDeviceSelectorFromFriendlyName(*(void**)(&friendlyName), &value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_Spi_ISpiDeviceStatics<D>::GetBusInfo(param::hstring const& busId) const
    {
        void* busInfo{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::Spi::ISpiDeviceStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::Spi::ISpiDeviceStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiDeviceStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetBusInfo(*(void**)(&busId), &busInfo));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiDeviceStatics>**)this;
            check_hresult(_winrt_abi_type->GetBusInfo(*(void**)(&busId), &busInfo));
        }
        return winrt::Windows::Devices::Spi::SpiBusInfo{ busInfo, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Devices_Spi_ISpiDeviceStatics<D>::FromIdAsync(param::hstring const& busId, winrt::Windows::Devices::Spi::SpiConnectionSettings const& settings) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::Spi::ISpiDeviceStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::Spi::ISpiDeviceStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiDeviceStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->FromIdAsync(*(void**)(&busId), *(void**)(&settings), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Spi::ISpiDeviceStatics>**)this;
            check_hresult(_winrt_abi_type->FromIdAsync(*(void**)(&busId), *(void**)(&settings), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::Spi::SpiDevice>{ operation, take_ownership_from_abi };
    }
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::Spi::ISpiBusInfo> : produce_base<D, winrt::Windows::Devices::Spi::ISpiBusInfo>
    {
        int32_t __stdcall get_ChipSelectLineCount(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<int32_t>(this->shim().ChipSelectLineCount());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_MinClockFrequency(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<int32_t>(this->shim().MinClockFrequency());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_MaxClockFrequency(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<int32_t>(this->shim().MaxClockFrequency());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_SupportedDataBitLengths(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IVectorView<int32_t>>(this->shim().SupportedDataBitLengths());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::Spi::ISpiConnectionSettings> : produce_base<D, winrt::Windows::Devices::Spi::ISpiConnectionSettings>
    {
        int32_t __stdcall get_ChipSelectLine(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<int32_t>(this->shim().ChipSelectLine());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_ChipSelectLine(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ChipSelectLine(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Mode(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::Spi::SpiMode>(this->shim().Mode());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Mode(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Mode(*reinterpret_cast<winrt::Windows::Devices::Spi::SpiMode const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_DataBitLength(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<int32_t>(this->shim().DataBitLength());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_DataBitLength(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().DataBitLength(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ClockFrequency(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<int32_t>(this->shim().ClockFrequency());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_ClockFrequency(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ClockFrequency(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_SharingMode(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::Spi::SpiSharingMode>(this->shim().SharingMode());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_SharingMode(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SharingMode(*reinterpret_cast<winrt::Windows::Devices::Spi::SpiSharingMode const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::Spi::ISpiConnectionSettingsFactory> : produce_base<D, winrt::Windows::Devices::Spi::ISpiConnectionSettingsFactory>
    {
        int32_t __stdcall Create(int32_t chipSelectLine, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::Spi::SpiConnectionSettings>(this->shim().Create(chipSelectLine));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::Spi::ISpiController> : produce_base<D, winrt::Windows::Devices::Spi::ISpiController>
    {
        int32_t __stdcall GetDevice(void* settings, void** device) noexcept final try
        {
            clear_abi(device);
            typename D::abi_guard guard(this->shim());
            *device = detach_from<winrt::Windows::Devices::Spi::SpiDevice>(this->shim().GetDevice(*reinterpret_cast<winrt::Windows::Devices::Spi::SpiConnectionSettings const*>(&settings)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::Spi::ISpiControllerStatics> : produce_base<D, winrt::Windows::Devices::Spi::ISpiControllerStatics>
    {
        int32_t __stdcall GetDefaultAsync(void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::Spi::SpiController>>(this->shim().GetDefaultAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetControllersAsync(void* provider, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Devices::Spi::SpiController>>>(this->shim().GetControllersAsync(*reinterpret_cast<winrt::Windows::Devices::Spi::Provider::ISpiProvider const*>(&provider)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Devices::Spi::ISpiDevice> : produce_base<D, winrt::Windows::Devices::Spi::ISpiDevice>
    {
        int32_t __stdcall get_DeviceId(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().DeviceId());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ConnectionSettings(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::Spi::SpiConnectionSettings>(this->shim().ConnectionSettings());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall Write(uint32_t __bufferSize, uint8_t* buffer) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Write(array_view<uint8_t const>(reinterpret_cast<uint8_t const *>(buffer), reinterpret_cast<uint8_t const *>(buffer) + __bufferSize));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall Read(uint32_t __bufferSize, uint8_t* buffer) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Read(array_view<uint8_t>(reinterpret_cast<uint8_t*>(buffer), reinterpret_cast<uint8_t*>(buffer) + __bufferSize));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall TransferSequential(uint32_t __writeBufferSize, uint8_t* writeBuffer, uint32_t __readBufferSize, uint8_t* readBuffer) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().TransferSequential(array_view<uint8_t const>(reinterpret_cast<uint8_t const *>(writeBuffer), reinterpret_cast<uint8_t const *>(writeBuffer) + __writeBufferSize), array_view<uint8_t>(reinterpret_cast<uint8_t*>(readBuffer), reinterpret_cast<uint8_t*>(readBuffer) + __readBufferSize));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall TransferFullDuplex(uint32_t __writeBufferSize, uint8_t* writeBuffer, uint32_t __readBufferSize, uint8_t* readBuffer) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().TransferFullDuplex(array_view<uint8_t const>(reinterpret_cast<uint8_t const *>(writeBuffer), reinterpret_cast<uint8_t const *>(writeBuffer) + __writeBufferSize), array_view<uint8_t>(reinterpret_cast<uint8_t*>(readBuffer), reinterpret_cast<uint8_t*>(readBuffer) + __readBufferSize));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
    template <typename D>
    struct produce<D, winrt::Windows::Devices::Spi::ISpiDeviceStatics> : produce_base<D, winrt::Windows::Devices::Spi::ISpiDeviceStatics>
    {
        int32_t __stdcall GetDeviceSelector(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().GetDeviceSelector());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetDeviceSelectorFromFriendlyName(void* friendlyName, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().GetDeviceSelector(*reinterpret_cast<hstring const*>(&friendlyName)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetBusInfo(void* busId, void** busInfo) noexcept final try
        {
            clear_abi(busInfo);
            typename D::abi_guard guard(this->shim());
            *busInfo = detach_from<winrt::Windows::Devices::Spi::SpiBusInfo>(this->shim().GetBusInfo(*reinterpret_cast<hstring const*>(&busId)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall FromIdAsync(void* busId, void* settings, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::Spi::SpiDevice>>(this->shim().FromIdAsync(*reinterpret_cast<hstring const*>(&busId), *reinterpret_cast<winrt::Windows::Devices::Spi::SpiConnectionSettings const*>(&settings)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
}
WINRT_EXPORT namespace winrt::Windows::Devices::Spi
{
    inline SpiConnectionSettings::SpiConnectionSettings(int32_t chipSelectLine) :
        SpiConnectionSettings(impl::call_factory<SpiConnectionSettings, ISpiConnectionSettingsFactory>([&](ISpiConnectionSettingsFactory const& f) { return f.Create(chipSelectLine); }))
    {
    }
    inline auto SpiController::GetDefaultAsync()
    {
        return impl::call_factory_cast<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Devices::Spi::SpiController>(*)(ISpiControllerStatics const&), SpiController, ISpiControllerStatics>([](ISpiControllerStatics const& f) { return f.GetDefaultAsync(); });
    }
    inline auto SpiController::GetControllersAsync(winrt::Windows::Devices::Spi::Provider::ISpiProvider const& provider)
    {
        return impl::call_factory<SpiController, ISpiControllerStatics>([&](ISpiControllerStatics const& f) { return f.GetControllersAsync(provider); });
    }
    inline auto SpiDevice::GetDeviceSelector()
    {
        return impl::call_factory_cast<hstring(*)(ISpiDeviceStatics const&), SpiDevice, ISpiDeviceStatics>([](ISpiDeviceStatics const& f) { return f.GetDeviceSelector(); });
    }
    inline auto SpiDevice::GetDeviceSelector(param::hstring const& friendlyName)
    {
        return impl::call_factory<SpiDevice, ISpiDeviceStatics>([&](ISpiDeviceStatics const& f) { return f.GetDeviceSelector(friendlyName); });
    }
    inline auto SpiDevice::GetBusInfo(param::hstring const& busId)
    {
        return impl::call_factory<SpiDevice, ISpiDeviceStatics>([&](ISpiDeviceStatics const& f) { return f.GetBusInfo(busId); });
    }
    inline auto SpiDevice::FromIdAsync(param::hstring const& busId, winrt::Windows::Devices::Spi::SpiConnectionSettings const& settings)
    {
        return impl::call_factory<SpiDevice, ISpiDeviceStatics>([&](ISpiDeviceStatics const& f) { return f.FromIdAsync(busId, settings); });
    }
}
namespace std
{
#ifndef WINRT_LEAN_AND_MEAN
    template<> struct hash<winrt::Windows::Devices::Spi::ISpiBusInfo> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Devices::Spi::ISpiConnectionSettings> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Devices::Spi::ISpiConnectionSettingsFactory> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Devices::Spi::ISpiController> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Devices::Spi::ISpiControllerStatics> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Devices::Spi::ISpiDevice> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Devices::Spi::ISpiDeviceStatics> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Devices::Spi::SpiBusInfo> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Devices::Spi::SpiConnectionSettings> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Devices::Spi::SpiController> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Devices::Spi::SpiDevice> : winrt::impl::hash_base {};
#endif
#ifdef __cpp_lib_format
#endif
}
#endif
