/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.util.concurrent.ScheduledExecutorService;
import org.apache.catalina.util.RateLimiterBase;
import org.apache.catalina.util.TimeBucketCounterBase;

public class ExactRateLimiter
extends RateLimiterBase {
    @Override
    protected String getDefaultPolicyName() {
        return "exact";
    }

    @Override
    protected TimeBucketCounterBase newCounterInstance(int n, ScheduledExecutorService scheduledExecutorService) {
        return new ExactTimeBucketCounter(n, scheduledExecutorService);
    }

    static class ExactTimeBucketCounter
    extends TimeBucketCounterBase {
        ExactTimeBucketCounter(int n, ScheduledExecutorService scheduledExecutorService) {
            super(n, scheduledExecutorService);
        }

        @Override
        public long getBucketIndex(long l) {
            return l / 1000L / (long)this.getBucketDuration();
        }

        @Override
        public double getRatio() {
            return 1.0;
        }

        @Override
        public long getMillisUntilNextBucket() {
            long l = System.currentTimeMillis();
            long l2 = (this.getBucketIndex(l) + 1L) * (long)this.getBucketDuration() * 1000L;
            return l2 - l;
        }
    }
}

