/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.upgrade;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import java.io.IOException;
import org.apache.coyote.Request;
import org.apache.coyote.http11.upgrade.UpgradeInfo;
import org.apache.coyote.http11.upgrade.UpgradeProcessorBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.net.DispatchType;
import org.apache.tomcat.util.net.SocketWrapperBase;
import org.apache.tomcat.util.res.StringManager;

public class UpgradeServletOutputStream
extends ServletOutputStream {
    private static final Log log = LogFactory.getLog(UpgradeServletOutputStream.class);
    private static final StringManager sm = StringManager.getManager(UpgradeServletOutputStream.class);
    private final UpgradeProcessorBase processor;
    private final SocketWrapperBase<?> socketWrapper;
    private final UpgradeInfo upgradeInfo;
    private final Object registeredLock = new Object();
    private final Object writeLock = new Object();
    private volatile boolean flushing = false;
    private volatile boolean closed = false;
    private volatile WriteListener listener = null;
    private boolean registered = false;

    public UpgradeServletOutputStream(UpgradeProcessorBase upgradeProcessorBase, SocketWrapperBase<?> socketWrapperBase, UpgradeInfo upgradeInfo) {
        this.processor = upgradeProcessorBase;
        this.socketWrapper = socketWrapperBase;
        this.upgradeInfo = upgradeInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isReady() {
        if (this.listener == null) {
            throw new IllegalStateException(sm.getString("upgrade.sos.canWrite.ise"));
        }
        if (this.closed) {
            return false;
        }
        Object object = this.registeredLock;
        synchronized (object) {
            if (this.flushing) {
                this.registered = true;
                return false;
            }
            if (this.registered) {
                return false;
            }
            boolean bl = this.socketWrapper.isReadyForWrite();
            this.registered = !bl;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setWriteListener(WriteListener writeListener) {
        if (writeListener == null) {
            throw new IllegalArgumentException(sm.getString("upgrade.sos.writeListener.null"));
        }
        if (this.listener != null) {
            throw new IllegalArgumentException(sm.getString("upgrade.sos.writeListener.set"));
        }
        if (this.closed) {
            throw new IllegalStateException(sm.getString("upgrade.sos.write.closed"));
        }
        this.listener = writeListener;
        Object object = this.registeredLock;
        synchronized (object) {
            this.registered = true;
            Request request = this.processor.getRequest();
            if (request != null && request.isRequestThread()) {
                this.processor.addDispatch(DispatchType.NON_BLOCKING_WRITE);
            } else {
                this.socketWrapper.registerWriteInterest();
            }
        }
    }

    final boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int n) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            this.preWriteChecks();
            this.writeInternal(new byte[]{(byte)n}, 0, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] byArray, int n, int n2) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            this.preWriteChecks();
            this.writeInternal(byArray, n, n2);
        }
    }

    public void flush() throws IOException {
        this.preWriteChecks();
        this.flushInternal(this.listener == null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushInternal(boolean bl, boolean bl2) throws IOException {
        try {
            Object object = this.writeLock;
            synchronized (object) {
                if (bl2) {
                    this.flushing = this.socketWrapper.flush(bl);
                    if (this.flushing) {
                        this.socketWrapper.registerWriteInterest();
                    }
                } else {
                    this.socketWrapper.flush(bl);
                }
            }
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            this.onError(throwable);
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw new IOException(throwable);
        }
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.flushInternal(this.listener == null, false);
    }

    private void preWriteChecks() {
        if (this.listener != null && !this.socketWrapper.canWrite()) {
            throw new IllegalStateException(sm.getString("upgrade.sos.write.ise"));
        }
        if (this.closed) {
            throw new IllegalStateException(sm.getString("upgrade.sos.write.closed"));
        }
    }

    private void writeInternal(byte[] byArray, int n, int n2) throws IOException {
        this.socketWrapper.write(this.listener == null, byArray, n, n2);
        this.upgradeInfo.addBytesSent(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onWritePossible() {
        try {
            if (this.flushing) {
                this.flushInternal(false, true);
                if (this.flushing) {
                    return;
                }
            } else {
                this.flushInternal(false, false);
            }
        }
        catch (IOException iOException) {
            this.onError(iOException);
            return;
        }
        boolean bl = false;
        Object object = this.registeredLock;
        synchronized (object) {
            if (this.socketWrapper.isReadyForWrite()) {
                this.registered = false;
                bl = true;
            } else {
                this.registered = true;
            }
        }
        if (bl) {
            object = this.processor.getUpgradeToken().getContextBind().bind(false, null);
            try {
                this.listener.onWritePossible();
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                this.onError(throwable);
            }
            finally {
                this.processor.getUpgradeToken().getContextBind().unbind(false, (ClassLoader)object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onError(Throwable throwable) {
        block9: {
            if (this.listener == null) {
                return;
            }
            ClassLoader classLoader = this.processor.getUpgradeToken().getContextBind().bind(false, null);
            try {
                this.listener.onError(throwable);
            }
            catch (Throwable throwable2) {
                ExceptionUtils.handleThrowable((Throwable)throwable2);
                log.warn((Object)sm.getString("upgrade.sos.onErrorFail"), throwable2);
            }
            finally {
                this.processor.getUpgradeToken().getContextBind().unbind(false, classLoader);
            }
            try {
                this.close();
            }
            catch (IOException iOException) {
                if (!log.isDebugEnabled()) break block9;
                log.debug((Object)sm.getString("upgrade.sos.errorCloseFail"), (Throwable)iOException);
            }
        }
    }
}

