/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.coyote.ActionCode;
import org.apache.coyote.CloseNowException;
import org.apache.coyote.Response;
import org.apache.coyote.http11.Constants;
import org.apache.coyote.http11.HeadersTooLargeException;
import org.apache.coyote.http11.HttpOutputBuffer;
import org.apache.coyote.http11.OutputFilter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.net.SocketWrapperBase;
import org.apache.tomcat.util.res.StringManager;

public class Http11OutputBuffer
implements HttpOutputBuffer {
    protected static final StringManager sm = StringManager.getManager(Http11OutputBuffer.class);
    protected final Response response;
    private volatile boolean ackSent = false;
    protected boolean responseFinished;
    protected final ByteBuffer headerBuffer;
    protected OutputFilter[] filterLibrary;
    protected OutputFilter[] activeFilters;
    protected int lastActiveFilter;
    protected HttpOutputBuffer outputStreamOutputBuffer;
    protected SocketWrapperBase<?> socketWrapper;
    protected long byteCount = 0L;

    protected Http11OutputBuffer(Response response, int n) {
        this.response = response;
        this.headerBuffer = ByteBuffer.allocate(n);
        this.filterLibrary = new OutputFilter[0];
        this.activeFilters = new OutputFilter[0];
        this.lastActiveFilter = -1;
        this.responseFinished = false;
        this.outputStreamOutputBuffer = new SocketOutputBuffer();
    }

    public void addFilter(OutputFilter outputFilter) {
        OutputFilter[] outputFilterArray = Arrays.copyOf(this.filterLibrary, this.filterLibrary.length + 1);
        outputFilterArray[this.filterLibrary.length] = outputFilter;
        this.filterLibrary = outputFilterArray;
        this.activeFilters = new OutputFilter[this.filterLibrary.length];
    }

    public OutputFilter[] getFilters() {
        return this.filterLibrary;
    }

    public void addActiveFilter(OutputFilter outputFilter) {
        if (this.lastActiveFilter == -1) {
            outputFilter.setBuffer(this.outputStreamOutputBuffer);
        } else {
            for (int i = 0; i <= this.lastActiveFilter; ++i) {
                if (this.activeFilters[i] != outputFilter) continue;
                return;
            }
            outputFilter.setBuffer(this.activeFilters[this.lastActiveFilter]);
        }
        this.activeFilters[++this.lastActiveFilter] = outputFilter;
        outputFilter.setResponse(this.response);
    }

    @Override
    public int doWrite(ByteBuffer byteBuffer) throws IOException {
        if (!this.response.isCommitted()) {
            this.response.action(ActionCode.COMMIT, null);
        }
        if (this.lastActiveFilter == -1) {
            return this.outputStreamOutputBuffer.doWrite(byteBuffer);
        }
        return this.activeFilters[this.lastActiveFilter].doWrite(byteBuffer);
    }

    @Override
    public long getBytesWritten() {
        if (this.lastActiveFilter == -1) {
            return this.outputStreamOutputBuffer.getBytesWritten();
        }
        return this.activeFilters[this.lastActiveFilter].getBytesWritten();
    }

    @Override
    public void flush() throws IOException {
        if (this.lastActiveFilter == -1) {
            this.outputStreamOutputBuffer.flush();
        } else {
            this.activeFilters[this.lastActiveFilter].flush();
        }
    }

    @Override
    public void end() throws IOException {
        if (this.responseFinished) {
            return;
        }
        if (this.lastActiveFilter == -1) {
            this.outputStreamOutputBuffer.end();
        } else {
            this.activeFilters[this.lastActiveFilter].end();
        }
        this.responseFinished = true;
    }

    void resetHeaderBuffer() {
        this.headerBuffer.position(0).limit(this.headerBuffer.capacity());
    }

    public void recycle() {
        this.nextRequest();
        this.socketWrapper = null;
    }

    public void nextRequest() {
        for (int i = 0; i <= this.lastActiveFilter; ++i) {
            this.activeFilters[i].recycle();
        }
        this.response.recycle();
        this.headerBuffer.position(0).limit(this.headerBuffer.capacity());
        this.lastActiveFilter = -1;
        this.ackSent = false;
        this.responseFinished = false;
        this.byteCount = 0L;
    }

    public void init(SocketWrapperBase<?> socketWrapperBase) {
        this.socketWrapper = socketWrapperBase;
    }

    public void sendAck() throws IOException {
        if (!this.response.isCommitted() && !this.ackSent) {
            this.ackSent = true;
            this.socketWrapper.write(this.isBlocking(), Constants.ACK_BYTES, 0, Constants.ACK_BYTES.length);
            if (this.flushBuffer(true)) {
                throw new IOException(sm.getString("iob.failedwrite.ack"));
            }
        }
    }

    protected void commit() throws IOException {
        this.response.setCommitted(true);
        this.writeHeaders();
    }

    protected void writeHeaders() throws IOException {
        block5: {
            if (this.headerBuffer.position() > 0) {
                this.headerBuffer.flip();
                try {
                    SocketWrapperBase<?> socketWrapperBase = this.socketWrapper;
                    if (socketWrapperBase != null) {
                        socketWrapperBase.write(this.isBlocking(), this.headerBuffer);
                        break block5;
                    }
                    throw new CloseNowException(sm.getString("iob.failedwrite"));
                }
                finally {
                    this.headerBuffer.position(0).limit(this.headerBuffer.capacity());
                }
            }
        }
    }

    @Deprecated
    public void sendStatus() {
        this.sendStatus(this.response.getStatus());
    }

    public void sendStatus(int n) {
        this.write(Constants.HTTP_11_BYTES);
        this.headerBuffer.put((byte)32);
        switch (n) {
            case 200: {
                this.write(Constants._200_BYTES);
                break;
            }
            case 400: {
                this.write(Constants._400_BYTES);
                break;
            }
            case 404: {
                this.write(Constants._404_BYTES);
                break;
            }
            default: {
                this.write(n);
            }
        }
        this.headerBuffer.put((byte)32);
        this.headerBuffer.put((byte)13).put((byte)10);
    }

    public void sendHeader(MessageBytes messageBytes, MessageBytes messageBytes2) {
        this.write(messageBytes);
        this.headerBuffer.put((byte)58).put((byte)32);
        this.write(messageBytes2);
        this.headerBuffer.put((byte)13).put((byte)10);
    }

    public void endHeaders() {
        this.headerBuffer.put((byte)13).put((byte)10);
    }

    private void write(MessageBytes messageBytes) {
        if (messageBytes.getType() != 2) {
            messageBytes.toBytes();
            ByteChunk byteChunk = messageBytes.getByteChunk();
            byte[] byArray = byteChunk.getBuffer();
            for (int i = byteChunk.getStart(); i < byteChunk.getLength(); ++i) {
                if ((byArray[i] <= -1 || byArray[i] > 31 || byArray[i] == 9) && byArray[i] != 127) continue;
                byArray[i] = 32;
            }
        }
        this.write(messageBytes.getByteChunk());
    }

    private void write(ByteChunk byteChunk) {
        int n = byteChunk.getLength();
        this.checkLengthBeforeWrite(n);
        this.headerBuffer.put(byteChunk.getBytes(), byteChunk.getStart(), n);
    }

    public void write(byte[] byArray) {
        this.checkLengthBeforeWrite(byArray.length);
        this.headerBuffer.put(byArray);
    }

    private void write(int n) {
        String string = Integer.toString(n);
        int n2 = string.length();
        this.checkLengthBeforeWrite(n2);
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            this.headerBuffer.put((byte)c);
        }
    }

    private void checkLengthBeforeWrite(int n) {
        if (this.headerBuffer.position() + n + 4 > this.headerBuffer.capacity()) {
            throw new HeadersTooLargeException(sm.getString("iob.responseheadertoolarge.error"));
        }
    }

    protected boolean flushBuffer(boolean bl) throws IOException {
        return this.socketWrapper.flush(bl);
    }

    protected final boolean isBlocking() {
        return this.response.getWriteListener() == null;
    }

    protected final boolean isReady() {
        boolean bl;
        boolean bl2 = bl = !this.hasDataToWrite();
        if (!bl) {
            this.socketWrapper.registerWriteInterest();
        }
        return bl;
    }

    public boolean hasDataToWrite() {
        return this.socketWrapper.hasDataToWrite();
    }

    public void registerWriteInterest() {
        this.socketWrapper.registerWriteInterest();
    }

    boolean isChunking() {
        for (int i = 0; i < this.lastActiveFilter; ++i) {
            if (this.activeFilters[i] != this.filterLibrary[1]) continue;
            return true;
        }
        return false;
    }

    protected class SocketOutputBuffer
    implements HttpOutputBuffer {
        protected SocketOutputBuffer() {
        }

        @Override
        public int doWrite(ByteBuffer byteBuffer) throws IOException {
            try {
                int n = byteBuffer.remaining();
                SocketWrapperBase<?> socketWrapperBase = Http11OutputBuffer.this.socketWrapper;
                if (socketWrapperBase == null) {
                    throw new CloseNowException(sm.getString("iob.failedwrite"));
                }
                socketWrapperBase.write(Http11OutputBuffer.this.isBlocking(), byteBuffer);
                Http11OutputBuffer.this.byteCount += (long)(n -= byteBuffer.remaining());
                return n;
            }
            catch (IOException iOException) {
                Http11OutputBuffer.this.response.action(ActionCode.CLOSE_NOW, iOException);
                throw iOException;
            }
        }

        @Override
        public long getBytesWritten() {
            return Http11OutputBuffer.this.byteCount;
        }

        @Override
        public void end() throws IOException {
            Http11OutputBuffer.this.socketWrapper.flush(true);
        }

        @Override
        public void flush() throws IOException {
            Http11OutputBuffer.this.socketWrapper.flush(Http11OutputBuffer.this.isBlocking());
        }
    }
}

