/*
 * Decompiled with CFR 0.152.
 */
package org.apache.el.parser;

import org.apache.el.parser.Token;

public class ParseException
extends Exception {
    private static final long serialVersionUID = 1L;
    protected static String EOL = System.getProperty("line.separator", "\n");
    public Token currentToken;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;

    public ParseException(Token token, int[][] nArray, String[] stringArray) {
        super(ParseException.initialise(token, nArray, stringArray));
        this.currentToken = token;
        this.expectedTokenSequences = nArray;
        this.tokenImage = stringArray;
    }

    public ParseException() {
    }

    public ParseException(String string) {
        super(string);
    }

    private static String initialise(Token token, int[][] nArray, String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (n < nArray[i].length) {
                n = nArray[i].length;
            }
            for (int j = 0; j < nArray[i].length; ++j) {
                stringBuilder.append(stringArray[nArray[i][j]]).append(' ');
            }
            if (nArray[i][nArray[i].length - 1] != 0) {
                stringBuilder.append("...");
            }
            stringBuilder.append(EOL).append("    ");
        }
        Object object = "Encountered \"";
        Token token2 = token.next;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                object = (String)object + " ";
            }
            if (token2.kind == 0) {
                object = (String)object + stringArray[0];
                break;
            }
            object = (String)object + " " + stringArray[token2.kind];
            object = (String)object + " \"";
            object = (String)object + ParseException.add_escapes(token2.image);
            object = (String)object + " \"";
            token2 = token2.next;
        }
        if (token.next != null) {
            object = (String)object + "\" at line " + token.next.beginLine + ", column " + token.next.beginColumn;
        }
        object = (String)object + "." + EOL;
        if (nArray.length != 0) {
            object = nArray.length == 1 ? (String)object + "Was expecting:" + EOL + "    " : (String)object + "Was expecting one of:" + EOL + "    ";
            object = (String)object + stringBuilder.toString();
        }
        return object;
    }

    static String add_escapes(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        block10: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '\b': {
                    stringBuilder.append("\\b");
                    continue block10;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block10;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block10;
                }
                case '\f': {
                    stringBuilder.append("\\f");
                    continue block10;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block10;
                }
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block10;
                }
                case '\'': {
                    stringBuilder.append("\\'");
                    continue block10;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block10;
                }
                default: {
                    char c = string.charAt(i);
                    if (c < ' ' || c > '~') {
                        String string2 = "0000" + Integer.toString(c, 16);
                        stringBuilder.append("\\u" + string2.substring(string2.length() - 4));
                        continue block10;
                    }
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }
}

