/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.data.handlers;

import com.ibm.db2.cmx.runtime.generator.ParameterHandler;
import com.ibm.db2.cmx.runtime.internal.metadata.StatementDescriptorImpl;
import com.ibm.db2.jcc.DBTimestamp;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class SimpleParamMarkerParameterHandler
implements ParameterHandler {
    int[] parameterTypes_;
    ParameterMetaData metadata_;
    StatementDescriptorImpl statementDescriptor_;

    public SimpleParamMarkerParameterHandler() {
    }

    public SimpleParamMarkerParameterHandler(int[] nArray) {
        this.parameterTypes_ = nArray;
    }

    public SimpleParamMarkerParameterHandler(StatementDescriptorImpl statementDescriptorImpl) {
        this.statementDescriptor_ = statementDescriptorImpl;
    }

    @Override
    public void handleParameters(PreparedStatement preparedStatement, Object ... objectArray) throws SQLException {
        if (objectArray == null) {
            return;
        }
        int n2 = 0;
        n2 = this.statementDescriptor_ != null ? this.statementDescriptor_.getMethodInfoArray().getSqlParameterInfo().size() : objectArray.length;
        for (int i10 = 0; i10 < n2; ++i10) {
            this.setParameterX(preparedStatement, i10 + 1, objectArray[i10]);
        }
    }

    void setParameterX(PreparedStatement preparedStatement, int n2, Object object) throws SQLException {
        if (object != null) {
            this.setParameterValueUsingCorrectSetterMethod(preparedStatement, n2, object);
        } else {
            this.setParameterWhenValueIsNull(preparedStatement, n2);
        }
    }

    private void setParameterValueUsingCorrectSetterMethod(PreparedStatement preparedStatement, int n2, Object object) throws SQLException {
        if (object instanceof String) {
            preparedStatement.setString(n2, (String)object);
        } else if (object instanceof Integer) {
            preparedStatement.setInt(n2, (Integer)object);
        } else if (object instanceof Long) {
            preparedStatement.setLong(n2, (Long)object);
        } else if (object instanceof Double) {
            preparedStatement.setDouble(n2, (Double)object);
        } else if (object instanceof Float) {
            preparedStatement.setFloat(n2, ((Float)object).floatValue());
        } else if (object instanceof byte[]) {
            preparedStatement.setBytes(n2, (byte[])object);
        } else if (object instanceof Date) {
            preparedStatement.setDate(n2, (Date)object);
        } else if (object instanceof Time) {
            preparedStatement.setTime(n2, (Time)object);
        } else if (object instanceof DBTimestamp) {
            preparedStatement.setObject(n2, (DBTimestamp)object);
        } else if (object instanceof Timestamp) {
            preparedStatement.setTimestamp(n2, (Timestamp)object);
        } else if (object instanceof BigDecimal) {
            preparedStatement.setBigDecimal(n2, (BigDecimal)object);
        } else if (object instanceof Clob) {
            preparedStatement.setClob(n2, (Clob)object);
        } else if (object instanceof Blob) {
            preparedStatement.setBlob(n2, (Blob)object);
        } else if (object instanceof Boolean) {
            preparedStatement.setBoolean(n2, (Boolean)object);
        } else if (object instanceof Short) {
            preparedStatement.setShort(n2, (Short)object);
        } else if (object instanceof Character) {
            preparedStatement.setString(n2, ((Character)object).toString());
        } else if (object instanceof Byte) {
            preparedStatement.setByte(n2, (Byte)object);
        } else {
            preparedStatement.setObject(n2, object);
        }
    }

    private void setParameterWhenValueIsNull(PreparedStatement preparedStatement, int n2) throws SQLException {
        try {
            preparedStatement.setObject(n2, null);
        }
        catch (SQLException sQLException) {
            if (this.parameterTypes_ != null) {
                preparedStatement.setNull(n2, this.parameterTypes_[n2 - 1]);
            }
            if (this.metadata_ == null) {
                this.metadata_ = preparedStatement.getParameterMetaData();
            }
            preparedStatement.setNull(n2, this.metadata_.getParameterType(n2));
        }
    }
}

