/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.core.util;

import tools.jackson.core.JsonGenerator;
import tools.jackson.core.TokenStreamContext;
import tools.jackson.core.exc.StreamWriteException;
import tools.jackson.core.json.DupDetector;

public final class SimpleStreamWriteContext
extends TokenStreamContext {
    protected final SimpleStreamWriteContext _parent;
    protected DupDetector _dups;
    protected SimpleStreamWriteContext _childToRecycle;
    protected String _currentName;
    protected Object _currentValue;
    protected boolean _gotPropertyId;

    protected SimpleStreamWriteContext(int type, SimpleStreamWriteContext parent, int nestingDepth, DupDetector dups, Object currentValue) {
        this._type = type;
        this._parent = parent;
        this._nestingDepth = nestingDepth;
        this._dups = dups;
        this._index = -1;
        this._currentValue = currentValue;
    }

    private SimpleStreamWriteContext reset(int type, Object currentValue) {
        this._type = type;
        this._index = -1;
        this._currentName = null;
        this._gotPropertyId = false;
        this._currentValue = currentValue;
        if (this._dups != null) {
            this._dups.reset();
        }
        return this;
    }

    public SimpleStreamWriteContext withDupDetector(DupDetector dups) {
        this._dups = dups;
        return this;
    }

    @Override
    public Object currentValue() {
        return this._currentValue;
    }

    @Override
    public void assignCurrentValue(Object v) {
        this._currentValue = v;
    }

    public static SimpleStreamWriteContext createRootContext(DupDetector dd) {
        return new SimpleStreamWriteContext(0, null, 0, dd, null);
    }

    public SimpleStreamWriteContext createChildArrayContext(Object currentValue) {
        SimpleStreamWriteContext ctxt = this._childToRecycle;
        if (ctxt == null) {
            this._childToRecycle = ctxt = new SimpleStreamWriteContext(1, this, this._nestingDepth + 1, this._dups == null ? null : this._dups.child(), currentValue);
            return ctxt;
        }
        return ctxt.reset(1, currentValue);
    }

    public SimpleStreamWriteContext createChildObjectContext(Object currentValue) {
        SimpleStreamWriteContext ctxt = this._childToRecycle;
        if (ctxt == null) {
            this._childToRecycle = ctxt = new SimpleStreamWriteContext(2, this, this._nestingDepth + 1, this._dups == null ? null : this._dups.child(), currentValue);
            return ctxt;
        }
        return ctxt.reset(2, currentValue);
    }

    @Override
    public final SimpleStreamWriteContext getParent() {
        return this._parent;
    }

    @Override
    public final String currentName() {
        return this._currentName;
    }

    @Override
    public boolean hasCurrentName() {
        return this._gotPropertyId;
    }

    public SimpleStreamWriteContext clearAndGetParent() {
        this._currentValue = null;
        return this._parent;
    }

    public DupDetector getDupDetector() {
        return this._dups;
    }

    public boolean writeName(String name) throws StreamWriteException {
        if (this._type != 2 || this._gotPropertyId) {
            return false;
        }
        this._gotPropertyId = true;
        this._currentName = name;
        if (this._dups != null) {
            this._checkDup(this._dups, name);
        }
        return true;
    }

    private final void _checkDup(DupDetector dd, String name) throws StreamWriteException {
        if (dd.isDup(name)) {
            Object src = dd.getSource();
            throw new StreamWriteException(src instanceof JsonGenerator ? (JsonGenerator)src : null, "Duplicate Object property \"" + name + "\"");
        }
    }

    public boolean writeValue() {
        if (this._type == 2) {
            if (!this._gotPropertyId) {
                return false;
            }
            this._gotPropertyId = false;
        }
        ++this._index;
        return true;
    }
}

