/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.telemetryOOB;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.jdbc.SnowflakeConnectString;
import net.snowflake.client.jdbc.internal.apache.http.client.config.RequestConfig;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.CloseableHttpResponse;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpPost;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpRequestBase;
import net.snowflake.client.jdbc.internal.apache.http.entity.StringEntity;
import net.snowflake.client.jdbc.internal.apache.http.impl.client.CloseableHttpClient;
import net.snowflake.client.jdbc.internal.apache.http.impl.client.HttpClientBuilder;
import net.snowflake.client.jdbc.internal.apache.http.util.EntityUtils;
import net.snowflake.client.jdbc.internal.net.minidev.json.JSONArray;
import net.snowflake.client.jdbc.internal.net.minidev.json.JSONObject;
import net.snowflake.client.jdbc.telemetryOOB.TelemetryEvent;
import net.snowflake.client.jdbc.telemetryOOB.TelemetryThreadPool;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;
import net.snowflake.client.util.SecretDetector;
import net.snowflake.client.util.Stopwatch;

public class TelemetryService {
    private static final SFLogger logger = SFLoggerFactory.getLogger(TelemetryService.class);
    private static ThreadLocal<TelemetryService> _threadLocal = new ThreadLocal<TelemetryService>(){

        @Override
        protected TelemetryService initialValue() {
            return new TelemetryService();
        }
    };
    private static final String TELEMETRY_SERVER_URL_PATTERN = "https://(sfcdev\\.|sfctest\\.|)?client-telemetry\\.[a-z0-9\\.\\-]*snowflake[computing]?\\.com/enqueue";
    private static HashSet<String> ENABLED_DEPLOYMENT = new HashSet<String>(Arrays.asList(TELEMETRY_SERVER_DEPLOYMENT.access$000(TELEMETRY_SERVER_DEPLOYMENT.DEV), TELEMETRY_SERVER_DEPLOYMENT.access$000(TELEMETRY_SERVER_DEPLOYMENT.REG), TELEMETRY_SERVER_DEPLOYMENT.access$000(TELEMETRY_SERVER_DEPLOYMENT.QA1), TELEMETRY_SERVER_DEPLOYMENT.access$000(TELEMETRY_SERVER_DEPLOYMENT.PREPROD3), TELEMETRY_SERVER_DEPLOYMENT.access$000(TELEMETRY_SERVER_DEPLOYMENT.PROD), TELEMETRY_SERVER_DEPLOYMENT.access$000(TELEMETRY_SERVER_DEPLOYMENT.K8TEST)));
    private String connStr = "";
    private SnowflakeConnectString sfConnStr;
    private static final int DEFAULT_NUM_OF_RETRY_TO_TRIGGER_TELEMETRY = 10;
    private int numOfRetryToTriggerTelemetry = 10;
    private JSONObject context;
    private TELEMETRY_SERVER_DEPLOYMENT serverDeployment = TELEMETRY_SERVER_DEPLOYMENT.PROD;
    private static boolean enabled = true;
    private static boolean htapEnabled = false;
    private static final Object enableLock = new Object();
    private static final Object enableHTAPLock = new Object();
    private AtomicInteger eventCnt = new AtomicInteger();
    private AtomicInteger clientFailureCnt = new AtomicInteger();
    private AtomicInteger serverFailureCnt = new AtomicInteger();
    private String lastClientError = "";

    public static TelemetryService getInstance() {
        return _threadLocal.get();
    }

    public void resetNumOfRetryToTriggerTelemetry() {
        this.numOfRetryToTriggerTelemetry = 10;
    }

    public int getNumOfRetryToTriggerTelemetry() {
        return this.numOfRetryToTriggerTelemetry;
    }

    public void setNumOfRetryToTriggerTelemetry(int num) {
        this.numOfRetryToTriggerTelemetry = num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enable() {
        Object object = enableLock;
        synchronized (object) {
            logger.debug("Enabling out-of-band telemetry", false);
            enabled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disable() {
        Object object = enableLock;
        synchronized (object) {
            logger.debug("Disabling out-of-band telemetry", false);
            enabled = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enableHTAP() {
        Object object = enableHTAPLock;
        synchronized (object) {
            logger.debug("Enabling out-of-band HTAP telemetry", new Object[0]);
            htapEnabled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disableHTAP() {
        Object object = enableHTAPLock;
        synchronized (object) {
            logger.debug("Disabling out-of-band HTAP telemetry", new Object[0]);
            htapEnabled = false;
        }
    }

    @SnowflakeJdbcInternalApi
    public static void disableOOBTelemetry() {
        TelemetryService.disable();
        TelemetryService.disableHTAP();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled() {
        Object object = enableLock;
        synchronized (object) {
            return enabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHTAPEnabled() {
        Object object = enableHTAPLock;
        synchronized (object) {
            return htapEnabled;
        }
    }

    public JSONObject getContext() {
        return this.context;
    }

    public void updateContextForIT(Map<String, String> params) {
        Properties info = new Properties();
        for (String key : params.keySet()) {
            String val = params.get(key);
            if (val == null) continue;
            info.put(key, val);
        }
        SnowflakeConnectString conStr = SnowflakeConnectString.parse(params.get("uri"), info);
        this.updateContext(conStr);
    }

    public void updateContext(SnowflakeConnectString conStr) {
        if (conStr != null) {
            this.sfConnStr = conStr;
            this.configureDeployment(conStr);
            this.context = new JSONObject();
            for (Map.Entry<String, Object> entry : conStr.getParameters().entrySet()) {
                String k = entry.getKey();
                Object v = entry.getValue();
                if (SecretDetector.isSensitive(k)) continue;
                this.context.put(k, v);
            }
        }
    }

    private TELEMETRY_SERVER_DEPLOYMENT manuallyConfigureDeployment(String dep) {
        switch (dep) {
            case "K8TEST": {
                return TELEMETRY_SERVER_DEPLOYMENT.K8TEST;
            }
            case "REG": {
                return TELEMETRY_SERVER_DEPLOYMENT.REG;
            }
            case "DEV": {
                return TELEMETRY_SERVER_DEPLOYMENT.DEV;
            }
            case "QA1": {
                return TELEMETRY_SERVER_DEPLOYMENT.QA1;
            }
            case "PREPROD": {
                return TELEMETRY_SERVER_DEPLOYMENT.PREPROD3;
            }
            case "PROD": {
                return TELEMETRY_SERVER_DEPLOYMENT.PROD;
            }
        }
        return null;
    }

    private void configureDeployment(SnowflakeConnectString conStr) {
        String conDeployment;
        if (!conStr.isValid()) {
            return;
        }
        this.connStr = conStr.toString();
        String account = conStr.getAccount();
        int port = conStr.getPort();
        TELEMETRY_SERVER_DEPLOYMENT deployment = TELEMETRY_SERVER_DEPLOYMENT.PROD;
        Map<String, Object> conParams = conStr.getParameters();
        if (conParams.containsKey("TELEMETRYDEPLOYMENT") && (deployment = this.manuallyConfigureDeployment(conDeployment = String.valueOf(conParams.get("TELEMETRYDEPLOYMENT")).trim().toUpperCase())) != null) {
            this.setDeployment(deployment);
            return;
        }
        if (conStr.getHost().contains("reg") || conStr.getHost().contains("local")) {
            deployment = TELEMETRY_SERVER_DEPLOYMENT.REG;
            if (port == 8080) {
                deployment = TELEMETRY_SERVER_DEPLOYMENT.DEV;
            }
        } else if (conStr.getHost().contains("qa1") || account.contains("qa1")) {
            deployment = TELEMETRY_SERVER_DEPLOYMENT.QA1;
        } else if (conStr.getHost().contains("preprod3")) {
            deployment = TELEMETRY_SERVER_DEPLOYMENT.PREPROD3;
        } else if (conStr.getHost().contains("snowflake.temptest")) {
            deployment = TELEMETRY_SERVER_DEPLOYMENT.QA1;
        }
        this.setDeployment(deployment);
    }

    public boolean isDeploymentEnabled() {
        return ENABLED_DEPLOYMENT.contains(this.serverDeployment.name);
    }

    public String getDriverConnectionString() {
        return this.connStr;
    }

    public SnowflakeConnectString getSnowflakeConnectionString() {
        return this.sfConnStr;
    }

    public void setDeployment(TELEMETRY_SERVER_DEPLOYMENT deployment) {
        logger.debug("Setting out-of-band telemetry sever deployment to {}", new Object[]{deployment});
        this.serverDeployment = deployment;
    }

    public String getServerDeploymentName() {
        return this.serverDeployment.name;
    }

    public int getEventCount() {
        return this.eventCnt.get();
    }

    public int getClientFailureCount() {
        return this.clientFailureCnt.get();
    }

    public int getServerFailureCount() {
        return this.serverFailureCnt.get();
    }

    public String getLastClientError() {
        return this.lastClientError;
    }

    public void count() {
        this.eventCnt.incrementAndGet();
    }

    public void report(TelemetryEvent event) {
        this.reportChooseEvent(event, false);
    }

    public void reportChooseEvent(TelemetryEvent event, boolean isHTAP) {
        if (!enabled && !isHTAP || !htapEnabled && isHTAP || event == null || event.isEmpty()) {
            return;
        }
        TelemetryUploader runUpload = new TelemetryUploader(this, this.exportQueueToString(event), this.exportQueueToLogString(event), isHTAP);
        TelemetryThreadPool.getInstance().execute(runUpload);
    }

    public String exportQueueToString(TelemetryEvent event) {
        JSONArray logs = new JSONArray();
        logs.add(event);
        return logs.toString();
    }

    public String exportQueueToLogString(TelemetryEvent event) {
        JSONArray logs = new JSONArray();
        logs.add(event);
        return JSONArray.toJSONString(logs, new SecretDetector.SecretDetectorJSONStyle());
    }

    public void logOCSPExceptionTelemetryEvent(String eventType, JSONObject telemetryData, CertificateException ex) {
        if (enabled) {
            String eventName = "OCSPException";
            TelemetryEvent.LogBuilder logBuilder = new TelemetryEvent.LogBuilder();
            if (ex != null) {
                telemetryData.put("exceptionMessage", ex.getLocalizedMessage());
                StringWriter sw = new StringWriter();
                ex.printStackTrace(new PrintWriter(sw));
                telemetryData.put("exceptionStackTrace", sw.toString());
            }
            TelemetryEvent log = ((TelemetryEvent.LogBuilder)((TelemetryEvent.LogBuilder)logBuilder.withName(eventName)).withValue(telemetryData).withTag("eventType", eventType)).build();
            this.report(log);
        }
    }

    public void logHttpRequestTelemetryEvent(String eventName, HttpRequestBase request, int injectSocketTimeout, AtomicBoolean canceling, boolean withoutCookies, boolean includeRetryParameters, boolean includeRequestGuid, CloseableHttpResponse response, Exception savedEx, String breakRetryReason, long retryTimeout, int retryCount, String sqlState, int errorCode) {
        if (enabled) {
            TelemetryEvent.LogBuilder logBuilder = new TelemetryEvent.LogBuilder();
            JSONObject value = new JSONObject();
            value.put("request", request.toString());
            value.put("injectSocketTimeout", injectSocketTimeout);
            value.put("canceling", canceling == null ? "null" : Boolean.valueOf(canceling.get()));
            value.put("withoutCookies", withoutCookies);
            value.put("includeRetryParameters", includeRetryParameters);
            value.put("includeRequestGuid", includeRequestGuid);
            value.put("breakRetryReason", breakRetryReason);
            value.put("retryTimeout", retryTimeout);
            value.put("retryCount", retryCount);
            value.put("sqlState", sqlState);
            value.put("errorCode", errorCode);
            int responseStatusCode = -1;
            if (response != null) {
                value.put("response", response.toString());
                value.put("responseStatusLine", response.getStatusLine().toString());
                if (response.getStatusLine() != null) {
                    responseStatusCode = response.getStatusLine().getStatusCode();
                    value.put("responseStatusCode", responseStatusCode);
                }
            } else {
                value.put("response", null);
            }
            if (savedEx != null) {
                value.put("exceptionMessage", savedEx.getLocalizedMessage());
                StringWriter sw = new StringWriter();
                savedEx.printStackTrace(new PrintWriter(sw));
                value.put("exceptionStackTrace", sw.toString());
            }
            TelemetryEvent log = ((TelemetryEvent.LogBuilder)((TelemetryEvent.LogBuilder)((TelemetryEvent.LogBuilder)((TelemetryEvent.LogBuilder)logBuilder.withName(eventName)).withValue(value).withTag("sqlState", sqlState)).withTag("errorCode", errorCode)).withTag("responseStatusCode", responseStatusCode)).build();
            this.report(log);
        }
    }

    public void logExecutionTimeTelemetryEvent(JSONObject telemetryData, String eventName) {
        if (htapEnabled) {
            TelemetryEvent.LogBuilder logBuilder = new TelemetryEvent.LogBuilder();
            TelemetryEvent log = ((TelemetryEvent.LogBuilder)((TelemetryEvent.LogBuilder)logBuilder.withName(eventName)).withValue(telemetryData).withTag("eventType", eventName)).build();
            this.reportChooseEvent(log, true);
        }
    }

    static class TelemetryUploader
    implements Runnable {
        private TelemetryService instance;
        private String payload;
        private String payloadLogStr;
        private boolean isHTAP;
        private static final int TIMEOUT = 5000;
        private static final RequestConfig config = RequestConfig.custom().setConnectionRequestTimeout(5000).setConnectionRequestTimeout(5000).setSocketTimeout(5000).build();

        public TelemetryUploader(TelemetryService _instance, String _payload, String _payloadLogStr, boolean _isHTAP) {
            this.instance = _instance;
            this.payload = _payload;
            this.payloadLogStr = _payloadLogStr;
            this.isHTAP = _isHTAP;
        }

        @Override
        public void run() {
            if (!this.isHTAP) {
                TelemetryUploader telemetryUploader = this;
                if (!enabled) {
                    return;
                }
            }
            if (this.isHTAP) {
                TelemetryUploader telemetryUploader = this;
                if (!htapEnabled) {
                    return;
                }
            }
            if (!this.instance.isDeploymentEnabled()) {
                logger.debug("Skip the disabled deployment: ", this.instance.serverDeployment.name);
                return;
            }
            if (!this.instance.serverDeployment.url.matches(TelemetryService.TELEMETRY_SERVER_URL_PATTERN)) {
                logger.debug("Ignore invalid url: ", this.instance.serverDeployment.url);
                return;
            }
            this.uploadPayload();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void uploadPayload() {
            Stopwatch stopwatch = new Stopwatch();
            stopwatch.start();
            logger.debugNoMask("Running out-of-band telemetry uploader. The payload is: " + this.payloadLogStr);
            Object response = null;
            boolean success = true;
            try {
                HttpPost post = new HttpPost(this.instance.serverDeployment.url);
                post.setEntity(new StringEntity(this.payload));
                post.setHeader("Content-type", "application/json");
                post.setHeader("x-api-key", this.instance.serverDeployment.getApiKey());
                try (CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();){
                    response = httpClient.execute(post);
                    int statusCode = response.getStatusLine().getStatusCode();
                    if (statusCode == 200) {
                        logger.debug("Out-of-band telemetry server request success: {}", response, true);
                        this.instance.count();
                    } else if (statusCode == 429) {
                        logger.debug("Out-of-band telemetry server request hit server cap on response: {}", response);
                        this.instance.serverFailureCnt.incrementAndGet();
                    } else {
                        logger.debug("Out-of-band telemetry server request error: {}", response, true);
                        this.instance.lastClientError = response.toString();
                        this.instance.clientFailureCnt.incrementAndGet();
                        success = false;
                    }
                    logger.debug(EntityUtils.toString(response.getEntity(), "UTF-8"), true);
                    response.close();
                }
                stopwatch.stop();
            }
            catch (Exception e) {
                try {
                    logger.debug("Out-of-band telemetry request failed, Exception response: {}, exception: {}", response, e.getMessage());
                    String res = "null";
                    if (response != null) {
                        res = response.toString();
                    }
                    this.instance.lastClientError = "Response: " + res + "; Error: " + e.getMessage();
                    this.instance.clientFailureCnt.incrementAndGet();
                    success = false;
                    stopwatch.stop();
                }
                catch (Throwable throwable) {
                    stopwatch.stop();
                    logger.debug("Out-of-band telemetry request success: {} and clean the current queue. It took {} ms. Total successful events: {}, total unsuccessful events: {} (client failures: {}, server failures: {})", success, stopwatch.elapsedMillis(), this.instance.eventCnt, this.instance.clientFailureCnt.get() + this.instance.serverFailureCnt.get(), this.instance.clientFailureCnt, this.instance.serverFailureCnt);
                    throw throwable;
                }
                logger.debug("Out-of-band telemetry request success: {} and clean the current queue. It took {} ms. Total successful events: {}, total unsuccessful events: {} (client failures: {}, server failures: {})", success, stopwatch.elapsedMillis(), this.instance.eventCnt, this.instance.clientFailureCnt.get() + this.instance.serverFailureCnt.get(), this.instance.clientFailureCnt, this.instance.serverFailureCnt);
            }
            logger.debug("Out-of-band telemetry request success: {} and clean the current queue. It took {} ms. Total successful events: {}, total unsuccessful events: {} (client failures: {}, server failures: {})", success, stopwatch.elapsedMillis(), this.instance.eventCnt, this.instance.clientFailureCnt.get() + this.instance.serverFailureCnt.get(), this.instance.clientFailureCnt, this.instance.serverFailureCnt);
        }
    }

    public static enum TELEMETRY_SERVER_DEPLOYMENT {
        DEV("dev", TELEMETRY_API.SFCDEV),
        REG("reg", TELEMETRY_API.SFCDEV),
        QA1("qa1", TELEMETRY_API.SFCDEV),
        PREPROD3("preprod3", TELEMETRY_API.SFCDEV),
        PROD("prod", TELEMETRY_API.PROD),
        K8TEST("k8test", TELEMETRY_API.K8TEST);

        private String name;
        private String url;
        private final String apiKey;

        private TELEMETRY_SERVER_DEPLOYMENT(String name, TELEMETRY_API api) {
            this.name = name;
            this.url = api.url;
            this.apiKey = api.apiKey;
        }

        public String getURL() {
            return this.url;
        }

        public String getName() {
            return this.name;
        }

        public String getApiKey() {
            return this.apiKey;
        }

        public void setURL(String url) {
            this.url = url;
        }
    }

    private static enum TELEMETRY_API {
        SFCTEST("https://sfctest.client-telemetry.snowflakecomputing.com/enqueue", "rRNY3EPNsB4U89XYuqsZKa7TSxb9QVX93yNM4tS6"),
        SFCDEV("https://sfcdev.client-telemetry.snowflakecomputing.com/enqueue", "kyTKLWpEZSaJnrzTZ63I96QXZHKsgfqbaGmAaIWf"),
        PROD("https://client-telemetry.snowflakecomputing.com/enqueue", "wLpEKqnLOW9tGNwTjab5N611YQApOb3t9xOnE1rX"),
        K8TEST("https://client-telemetry.ordevmisc1.us-west-2.aws-dev.app.snowflake.com/enqueue", "");

        private final String url;
        private final String apiKey;

        private TELEMETRY_API(String host, String key) {
            this.url = host;
            this.apiKey = key;
        }
    }
}

