/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.util.test;

import java.security.SecureRandom;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.prng.EntropySource;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.prng.EntropySourceProvider;

public class TestRandomEntropySourceProvider
implements EntropySourceProvider {
    private final SecureRandom _sr = new SecureRandom();
    private final boolean _predictionResistant;

    public TestRandomEntropySourceProvider(boolean bl) {
        this._predictionResistant = bl;
    }

    @Override
    public EntropySource get(final int n) {
        return new EntropySource(){

            @Override
            public boolean isPredictionResistant() {
                return TestRandomEntropySourceProvider.this._predictionResistant;
            }

            @Override
            public byte[] getEntropy() {
                byte[] byArray = new byte[(n + 7) / 8];
                TestRandomEntropySourceProvider.this._sr.nextBytes(byArray);
                return byArray;
            }

            @Override
            public int entropySize() {
                return n;
            }
        };
    }
}

