/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.pqc.crypto.xwing;

import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.params.X25519PrivateKeyParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.pqc.crypto.crystals.kyber.KyberParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.pqc.crypto.crystals.kyber.KyberPrivateKeyParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.pqc.crypto.xwing.XWingKeyParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.util.Arrays;

public class XWingPrivateKeyParameters
extends XWingKeyParameters {
    private final KyberPrivateKeyParameters kybPriv;
    private final X25519PrivateKeyParameters xdhPriv;

    XWingPrivateKeyParameters(AsymmetricKeyParameter asymmetricKeyParameter, AsymmetricKeyParameter asymmetricKeyParameter2) {
        super(true);
        this.kybPriv = (KyberPrivateKeyParameters)asymmetricKeyParameter;
        this.xdhPriv = (X25519PrivateKeyParameters)asymmetricKeyParameter2;
    }

    public XWingPrivateKeyParameters(byte[] byArray) {
        super(false);
        this.kybPriv = new KyberPrivateKeyParameters(KyberParameters.kyber768, Arrays.copyOfRange(byArray, 0, byArray.length - 32));
        this.xdhPriv = new X25519PrivateKeyParameters(byArray, byArray.length - 32);
    }

    KyberPrivateKeyParameters getKyberPrivateKey() {
        return this.kybPriv;
    }

    X25519PrivateKeyParameters getXDHPrivateKey() {
        return this.xdhPriv;
    }

    public byte[] getEncoded() {
        return Arrays.concatenate(this.kybPriv.getEncoded(), this.xdhPriv.getEncoded());
    }
}

