/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.math.ec.endo;

import java.math.BigInteger;
import net.snowflake.client.jdbc.internal.org.bouncycastle.math.ec.ECCurve;
import net.snowflake.client.jdbc.internal.org.bouncycastle.math.ec.ECPointMap;
import net.snowflake.client.jdbc.internal.org.bouncycastle.math.ec.ScaleYNegateXPointMap;
import net.snowflake.client.jdbc.internal.org.bouncycastle.math.ec.endo.EndoUtil;
import net.snowflake.client.jdbc.internal.org.bouncycastle.math.ec.endo.GLVEndomorphism;
import net.snowflake.client.jdbc.internal.org.bouncycastle.math.ec.endo.GLVTypeAParameters;

public class GLVTypeAEndomorphism
implements GLVEndomorphism {
    protected final GLVTypeAParameters parameters;
    protected final ECPointMap pointMap;

    public GLVTypeAEndomorphism(ECCurve eCCurve, GLVTypeAParameters gLVTypeAParameters) {
        this.parameters = gLVTypeAParameters;
        this.pointMap = new ScaleYNegateXPointMap(eCCurve.fromBigInteger(gLVTypeAParameters.getI()));
    }

    @Override
    public BigInteger[] decomposeScalar(BigInteger bigInteger) {
        return EndoUtil.decomposeScalar(this.parameters.getSplitParams(), bigInteger);
    }

    @Override
    public ECPointMap getPointMap() {
        return this.pointMap;
    }

    @Override
    public boolean hasEfficientPointMap() {
        return true;
    }
}

