/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1Set;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.BEROctetString;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.cms.ContentInfo;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.cms.EncryptedContentInfo;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.cms.EncryptedData;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cms.CMSEncryptedData;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cms.CMSEncryptedGenerator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cms.CMSException;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cms.CMSTypedData;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cms.CMSUtils;
import net.snowflake.client.jdbc.internal.org.bouncycastle.operator.OutputEncryptor;

public class CMSEncryptedDataGenerator
extends CMSEncryptedGenerator {
    private CMSEncryptedData doGenerate(CMSTypedData cMSTypedData, OutputEncryptor outputEncryptor) throws CMSException {
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            object = outputEncryptor.getOutputStream(byteArrayOutputStream);
            cMSTypedData.write((OutputStream)object);
            ((OutputStream)object).close();
        }
        catch (IOException iOException) {
            throw new CMSException("");
        }
        object = byteArrayOutputStream.toByteArray();
        AlgorithmIdentifier algorithmIdentifier = outputEncryptor.getAlgorithmIdentifier();
        BEROctetString bEROctetString = new BEROctetString((byte[])object);
        EncryptedContentInfo encryptedContentInfo = CMSUtils.getEncryptedContentInfo(cMSTypedData.getContentType(), algorithmIdentifier, (byte[])object);
        ASN1Set aSN1Set = CMSUtils.getAttrBERSet(this.unprotectedAttributeGenerator);
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.encryptedData, new EncryptedData(encryptedContentInfo, aSN1Set));
        return new CMSEncryptedData(contentInfo);
    }

    public CMSEncryptedData generate(CMSTypedData cMSTypedData, OutputEncryptor outputEncryptor) throws CMSException {
        return this.doGenerate(cMSTypedData, outputEncryptor);
    }
}

