/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opentelemetry.sdk.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;
import net.snowflake.client.jdbc.internal.opentelemetry.api.common.Attributes;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.common.InstrumentationScopeInfo;

public final class ComponentRegistry<V> {
    private final Map<String, V> componentByName = new ConcurrentHashMap<String, V>();
    private final Map<String, Map<String, V>> componentByNameAndVersion = new ConcurrentHashMap<String, Map<String, V>>();
    private final Map<String, Map<String, V>> componentByNameAndSchema = new ConcurrentHashMap<String, Map<String, V>>();
    private final Map<String, Map<String, Map<String, V>>> componentByNameVersionAndSchema = new ConcurrentHashMap<String, Map<String, Map<String, V>>>();
    private final Object lock = new Object();
    private final Set<V> allComponents = Collections.newSetFromMap(new IdentityHashMap());
    private final Function<InstrumentationScopeInfo, V> factory;

    public ComponentRegistry(Function<InstrumentationScopeInfo, V> factory) {
        this.factory = factory;
    }

    public V get(String name, @Nullable String version, @Nullable String schemaUrl, Attributes attributes) {
        if (version != null && schemaUrl != null) {
            Map componentByVersionAndSchema = this.componentByNameVersionAndSchema.computeIfAbsent(name, unused -> new ConcurrentHashMap());
            Map componentBySchema = componentByVersionAndSchema.computeIfAbsent(version, unused -> new ConcurrentHashMap());
            return (V)componentBySchema.computeIfAbsent(schemaUrl, schemaUrl1 -> this.buildComponent(InstrumentationScopeInfo.builder(name).setVersion(version).setSchemaUrl((String)schemaUrl1).setAttributes(attributes).build()));
        }
        if (version != null) {
            Map componentByVersion = this.componentByNameAndVersion.computeIfAbsent(name, unused -> new ConcurrentHashMap());
            return (V)componentByVersion.computeIfAbsent(version, version1 -> this.buildComponent(InstrumentationScopeInfo.builder(name).setVersion((String)version1).setAttributes(attributes).build()));
        }
        if (schemaUrl != null) {
            Map componentBySchema = this.componentByNameAndSchema.computeIfAbsent(name, unused -> new ConcurrentHashMap());
            return (V)componentBySchema.computeIfAbsent(schemaUrl, schemaUrl1 -> this.buildComponent(InstrumentationScopeInfo.builder(name).setSchemaUrl((String)schemaUrl1).setAttributes(attributes).build()));
        }
        return (V)this.componentByName.computeIfAbsent(name, name1 -> this.buildComponent(InstrumentationScopeInfo.builder(name1).setAttributes(attributes).build()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V buildComponent(InstrumentationScopeInfo instrumentationScopeInfo) {
        V component = this.factory.apply(instrumentationScopeInfo);
        Object object = this.lock;
        synchronized (object) {
            this.allComponents.add(component);
        }
        return component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<V> getComponents() {
        Object object = this.lock;
        synchronized (object) {
            return Collections.unmodifiableCollection(new ArrayList<V>(this.allComponents));
        }
    }
}

