/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.xds;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.snowflake.client.jdbc.internal.google.common.annotations.VisibleForTesting;
import net.snowflake.client.jdbc.internal.google.common.base.MoreObjects;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.google.common.base.Splitter;
import net.snowflake.client.jdbc.internal.google.common.collect.ImmutableCollection;
import net.snowflake.client.jdbc.internal.google.common.collect.ImmutableList;
import net.snowflake.client.jdbc.internal.google.common.collect.ImmutableSet;
import net.snowflake.client.jdbc.internal.google.common.primitives.UnsignedInteger;
import net.snowflake.client.jdbc.internal.google.protobuf.Any;
import net.snowflake.client.jdbc.internal.google.protobuf.Duration;
import net.snowflake.client.jdbc.internal.google.protobuf.GeneratedMessage;
import net.snowflake.client.jdbc.internal.google.protobuf.InvalidProtocolBufferException;
import net.snowflake.client.jdbc.internal.google.protobuf.Message;
import net.snowflake.client.jdbc.internal.google.protobuf.util.Durations;
import net.snowflake.client.jdbc.internal.google.re2j.Pattern;
import net.snowflake.client.jdbc.internal.google.re2j.PatternSyntaxException;
import net.snowflake.client.jdbc.internal.grpc.Status;
import net.snowflake.client.jdbc.internal.grpc.internal.GrpcUtil;
import net.snowflake.client.jdbc.internal.grpc.xds.ClusterSpecifierPlugin;
import net.snowflake.client.jdbc.internal.grpc.xds.ClusterSpecifierPluginRegistry;
import net.snowflake.client.jdbc.internal.grpc.xds.ConfigOrError;
import net.snowflake.client.jdbc.internal.grpc.xds.Filter;
import net.snowflake.client.jdbc.internal.grpc.xds.FilterRegistry;
import net.snowflake.client.jdbc.internal.grpc.xds.StructOrError;
import net.snowflake.client.jdbc.internal.grpc.xds.VirtualHost;
import net.snowflake.client.jdbc.internal.grpc.xds.client.XdsClient;
import net.snowflake.client.jdbc.internal.grpc.xds.client.XdsResourceType;
import net.snowflake.client.jdbc.internal.grpc.xds.internal.MatcherParser;
import net.snowflake.client.jdbc.internal.grpc.xds.internal.Matchers;
import net.snowflake.client.jdbc.internal.grpc.xds.shaded.com.github.udpa.udpa.type.v1.TypedStruct;
import net.snowflake.client.jdbc.internal.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.TypedExtensionConfig;
import net.snowflake.client.jdbc.internal.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.FilterConfig;
import net.snowflake.client.jdbc.internal.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.HeaderMatcher;
import net.snowflake.client.jdbc.internal.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.RetryPolicy;
import net.snowflake.client.jdbc.internal.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.Route;
import net.snowflake.client.jdbc.internal.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.RouteAction;
import net.snowflake.client.jdbc.internal.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.RouteConfiguration;
import net.snowflake.client.jdbc.internal.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.RouteMatch;
import net.snowflake.client.jdbc.internal.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.WeightedCluster;
import net.snowflake.client.jdbc.internal.grpc.xds.shaded.io.envoyproxy.envoy.type.v3.FractionalPercent;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;

class XdsRouteConfigureResource
extends XdsResourceType<RdsUpdate> {
    private static final String GRPC_EXPERIMENTAL_XDS_AUTHORITY_REWRITE = "GRPC_EXPERIMENTAL_XDS_AUTHORITY_REWRITE";
    @VisibleForTesting
    static boolean enableRouteLookup = GrpcUtil.getFlag("GRPC_EXPERIMENTAL_XDS_RLS_LB", true);
    static final String ADS_TYPE_URL_RDS = "type.googleapis.com/envoy.config.route.v3.RouteConfiguration";
    private static final String TYPE_URL_FILTER_CONFIG = "type.googleapis.com/envoy.config.route.v3.FilterConfig";
    @VisibleForTesting
    static final String HASH_POLICY_FILTER_STATE_KEY = "net.snowflake.client.jdbc.internal.grpc.channel_id";
    private static final Set<Status.Code> SUPPORTED_RETRYABLE_CODES = Collections.unmodifiableSet(EnumSet.of(Status.Code.CANCELLED, Status.Code.DEADLINE_EXCEEDED, Status.Code.INTERNAL, Status.Code.RESOURCE_EXHAUSTED, Status.Code.UNAVAILABLE));
    private static final XdsRouteConfigureResource instance = new XdsRouteConfigureResource();

    XdsRouteConfigureResource() {
    }

    static XdsRouteConfigureResource getInstance() {
        return instance;
    }

    @Override
    @Nullable
    protected String extractResourceName(Message unpackedResource) {
        if (!(unpackedResource instanceof RouteConfiguration)) {
            return null;
        }
        return ((RouteConfiguration)unpackedResource).getName();
    }

    @Override
    public String typeName() {
        return "RDS";
    }

    @Override
    public String typeUrl() {
        return ADS_TYPE_URL_RDS;
    }

    @Override
    public boolean shouldRetrieveResourceKeysForArgs() {
        return false;
    }

    @Override
    protected boolean isFullStateOfTheWorld() {
        return false;
    }

    @Override
    protected Class<RouteConfiguration> unpackedClassName() {
        return RouteConfiguration.class;
    }

    @Override
    protected RdsUpdate doParse(XdsResourceType.Args args, Message unpackedMessage) throws XdsResourceType.ResourceInvalidException {
        if (!(unpackedMessage instanceof RouteConfiguration)) {
            throw new XdsResourceType.ResourceInvalidException("Invalid message type: " + unpackedMessage.getClass());
        }
        return XdsRouteConfigureResource.processRouteConfiguration((RouteConfiguration)unpackedMessage, FilterRegistry.getDefaultRegistry(), args);
    }

    private static RdsUpdate processRouteConfiguration(RouteConfiguration routeConfig, FilterRegistry filterRegistry, XdsResourceType.Args args) throws XdsResourceType.ResourceInvalidException {
        return new RdsUpdate(XdsRouteConfigureResource.extractVirtualHosts(routeConfig, filterRegistry, args));
    }

    static List<VirtualHost> extractVirtualHosts(RouteConfiguration routeConfig, FilterRegistry filterRegistry, XdsResourceType.Args args) throws XdsResourceType.ResourceInvalidException {
        HashMap<String, ClusterSpecifierPlugin.PluginConfig> pluginConfigMap = new HashMap<String, ClusterSpecifierPlugin.PluginConfig>();
        ImmutableSet.Builder optionalPlugins = ImmutableSet.builder();
        if (enableRouteLookup) {
            List<net.snowflake.client.jdbc.internal.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.ClusterSpecifierPlugin> plugins = routeConfig.getClusterSpecifierPluginsList();
            for (net.snowflake.client.jdbc.internal.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.ClusterSpecifierPlugin plugin : plugins) {
                String pluginName = plugin.getExtension().getName();
                ClusterSpecifierPlugin.PluginConfig pluginConfig = XdsRouteConfigureResource.parseClusterSpecifierPlugin(plugin);
                if (pluginConfig != null) {
                    if (pluginConfigMap.put(pluginName, pluginConfig) == null) continue;
                    throw new XdsResourceType.ResourceInvalidException("Multiple ClusterSpecifierPlugins with the same name: " + pluginName);
                }
                optionalPlugins.add(pluginName);
            }
        }
        ArrayList<VirtualHost> virtualHosts = new ArrayList<VirtualHost>(routeConfig.getVirtualHostsCount());
        for (net.snowflake.client.jdbc.internal.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.VirtualHost virtualHostProto : routeConfig.getVirtualHostsList()) {
            StructOrError<VirtualHost> virtualHost = XdsRouteConfigureResource.parseVirtualHost(virtualHostProto, filterRegistry, pluginConfigMap, (Set<String>)((Object)optionalPlugins.build()), args);
            if (virtualHost.getErrorDetail() != null) {
                throw new XdsResourceType.ResourceInvalidException("RouteConfiguration contains invalid virtual host: " + virtualHost.getErrorDetail());
            }
            virtualHosts.add(virtualHost.getStruct());
        }
        return virtualHosts;
    }

    private static StructOrError<VirtualHost> parseVirtualHost(net.snowflake.client.jdbc.internal.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.VirtualHost proto, FilterRegistry filterRegistry, Map<String, ClusterSpecifierPlugin.PluginConfig> pluginConfigMap, Set<String> optionalPlugins, XdsResourceType.Args args) {
        String name = proto.getName();
        ArrayList<VirtualHost.Route> routes = new ArrayList<VirtualHost.Route>(proto.getRoutesCount());
        for (Route routeProto : proto.getRoutesList()) {
            StructOrError<VirtualHost.Route> route = XdsRouteConfigureResource.parseRoute(routeProto, filterRegistry, pluginConfigMap, optionalPlugins, args);
            if (route == null) continue;
            if (route.getErrorDetail() != null) {
                return StructOrError.fromError("Virtual host [" + name + "] contains invalid route : " + route.getErrorDetail());
            }
            routes.add(route.getStruct());
        }
        StructOrError<Map<String, Filter.FilterConfig>> overrideConfigs = XdsRouteConfigureResource.parseOverrideFilterConfigs(proto.getTypedPerFilterConfigMap(), filterRegistry);
        if (overrideConfigs.getErrorDetail() != null) {
            return StructOrError.fromError("VirtualHost [" + proto.getName() + "] contains invalid HttpFilter config: " + overrideConfigs.getErrorDetail());
        }
        return StructOrError.fromStruct(VirtualHost.create(name, proto.getDomainsList(), routes, overrideConfigs.getStruct()));
    }

    @VisibleForTesting
    static StructOrError<Map<String, Filter.FilterConfig>> parseOverrideFilterConfigs(Map<String, Any> rawFilterConfigMap, FilterRegistry filterRegistry) {
        HashMap<String, Filter.FilterConfig> overrideConfigs = new HashMap<String, Filter.FilterConfig>();
        for (String name : rawFilterConfigMap.keySet()) {
            Any anyConfig = rawFilterConfigMap.get(name);
            String typeUrl = anyConfig.getTypeUrl();
            boolean isOptional = false;
            if (typeUrl.equals(TYPE_URL_FILTER_CONFIG)) {
                FilterConfig filterConfig;
                try {
                    filterConfig = anyConfig.unpack(FilterConfig.class);
                }
                catch (InvalidProtocolBufferException e) {
                    return StructOrError.fromError("FilterConfig [" + name + "] contains invalid proto: " + e);
                }
                isOptional = filterConfig.getIsOptional();
                anyConfig = filterConfig.getConfig();
                typeUrl = anyConfig.getTypeUrl();
            }
            GeneratedMessage rawConfig = anyConfig;
            try {
                if (typeUrl.equals("type.googleapis.com/udpa.type.v1.TypedStruct")) {
                    TypedStruct typedStruct = anyConfig.unpack(TypedStruct.class);
                    typeUrl = typedStruct.getTypeUrl();
                    rawConfig = typedStruct.getValue();
                } else if (typeUrl.equals("type.googleapis.com/xds.type.v3.TypedStruct")) {
                    net.snowflake.client.jdbc.internal.grpc.xds.shaded.com.github.xds.type.v3.TypedStruct newTypedStruct = anyConfig.unpack(net.snowflake.client.jdbc.internal.grpc.xds.shaded.com.github.xds.type.v3.TypedStruct.class);
                    typeUrl = newTypedStruct.getTypeUrl();
                    rawConfig = newTypedStruct.getValue();
                }
            }
            catch (InvalidProtocolBufferException e) {
                return StructOrError.fromError("FilterConfig [" + name + "] contains invalid proto: " + e);
            }
            Filter.Provider provider = filterRegistry.get(typeUrl);
            if (provider == null) {
                if (isOptional) continue;
                return StructOrError.fromError("HttpFilter [" + name + "](" + typeUrl + ") is required but unsupported");
            }
            ConfigOrError<? extends Filter.FilterConfig> filterConfig = provider.parseFilterConfigOverride(rawConfig);
            if (filterConfig.errorDetail != null) {
                return StructOrError.fromError("Invalid filter config for HttpFilter [" + name + "]: " + filterConfig.errorDetail);
            }
            overrideConfigs.put(name, (Filter.FilterConfig)filterConfig.config);
        }
        return StructOrError.fromStruct(overrideConfigs);
    }

    @Nullable
    @VisibleForTesting
    static StructOrError<VirtualHost.Route> parseRoute(Route proto, FilterRegistry filterRegistry, Map<String, ClusterSpecifierPlugin.PluginConfig> pluginConfigMap, Set<String> optionalPlugins, XdsResourceType.Args args) {
        StructOrError<VirtualHost.Route.RouteMatch> routeMatch = XdsRouteConfigureResource.parseRouteMatch(proto.getMatch());
        if (routeMatch == null) {
            return null;
        }
        if (routeMatch.getErrorDetail() != null) {
            return StructOrError.fromError("Route [" + proto.getName() + "] contains invalid RouteMatch: " + routeMatch.getErrorDetail());
        }
        StructOrError<Map<String, Filter.FilterConfig>> overrideConfigsOrError = XdsRouteConfigureResource.parseOverrideFilterConfigs(proto.getTypedPerFilterConfigMap(), filterRegistry);
        if (overrideConfigsOrError.getErrorDetail() != null) {
            return StructOrError.fromError("Route [" + proto.getName() + "] contains invalid HttpFilter config: " + overrideConfigsOrError.getErrorDetail());
        }
        Map<String, Filter.FilterConfig> overrideConfigs = overrideConfigsOrError.getStruct();
        switch (proto.getActionCase()) {
            case ROUTE: {
                StructOrError<VirtualHost.Route.RouteAction> routeAction = XdsRouteConfigureResource.parseRouteAction(proto.getRoute(), filterRegistry, pluginConfigMap, optionalPlugins, args);
                if (routeAction == null) {
                    return null;
                }
                if (routeAction.getErrorDetail() != null) {
                    return StructOrError.fromError("Route [" + proto.getName() + "] contains invalid RouteAction: " + routeAction.getErrorDetail());
                }
                return StructOrError.fromStruct(VirtualHost.Route.forAction(routeMatch.getStruct(), routeAction.getStruct(), overrideConfigs));
            }
            case NON_FORWARDING_ACTION: {
                return StructOrError.fromStruct(VirtualHost.Route.forNonForwardingAction(routeMatch.getStruct(), overrideConfigs));
            }
        }
        return StructOrError.fromError("Route [" + proto.getName() + "] with unknown action type: " + proto.getActionCase());
    }

    @Nullable
    @VisibleForTesting
    static StructOrError<VirtualHost.Route.RouteMatch> parseRouteMatch(RouteMatch proto) {
        if (proto.getQueryParametersCount() != 0) {
            return null;
        }
        StructOrError<VirtualHost.Route.RouteMatch.PathMatcher> pathMatch = XdsRouteConfigureResource.parsePathMatcher(proto);
        if (pathMatch.getErrorDetail() != null) {
            return StructOrError.fromError(pathMatch.getErrorDetail());
        }
        Matchers.FractionMatcher fractionMatch = null;
        if (proto.hasRuntimeFraction()) {
            StructOrError<Matchers.FractionMatcher> parsedFraction = XdsRouteConfigureResource.parseFractionMatcher(proto.getRuntimeFraction().getDefaultValue());
            if (parsedFraction.getErrorDetail() != null) {
                return StructOrError.fromError(parsedFraction.getErrorDetail());
            }
            fractionMatch = parsedFraction.getStruct();
        }
        ArrayList<Matchers.HeaderMatcher> headerMatchers = new ArrayList<Matchers.HeaderMatcher>();
        for (HeaderMatcher hmProto : proto.getHeadersList()) {
            StructOrError<Matchers.HeaderMatcher> headerMatcher = XdsRouteConfigureResource.parseHeaderMatcher(hmProto);
            if (headerMatcher.getErrorDetail() != null) {
                return StructOrError.fromError(headerMatcher.getErrorDetail());
            }
            headerMatchers.add(headerMatcher.getStruct());
        }
        return StructOrError.fromStruct(VirtualHost.Route.RouteMatch.create(pathMatch.getStruct(), headerMatchers, fractionMatch));
    }

    @VisibleForTesting
    static StructOrError<VirtualHost.Route.RouteMatch.PathMatcher> parsePathMatcher(RouteMatch proto) {
        boolean caseSensitive = proto.getCaseSensitive().getValue();
        switch (proto.getPathSpecifierCase()) {
            case PREFIX: {
                return StructOrError.fromStruct(VirtualHost.Route.RouteMatch.PathMatcher.fromPrefix(proto.getPrefix(), caseSensitive));
            }
            case PATH: {
                return StructOrError.fromStruct(VirtualHost.Route.RouteMatch.PathMatcher.fromPath(proto.getPath(), caseSensitive));
            }
            case SAFE_REGEX: {
                Pattern safeRegEx;
                String rawPattern = proto.getSafeRegex().getRegex();
                try {
                    safeRegEx = Pattern.compile(rawPattern);
                }
                catch (PatternSyntaxException e) {
                    return StructOrError.fromError("Malformed safe regex pattern: " + e.getMessage());
                }
                return StructOrError.fromStruct(VirtualHost.Route.RouteMatch.PathMatcher.fromRegEx(safeRegEx));
            }
        }
        return StructOrError.fromError("Unknown path match type");
    }

    private static StructOrError<Matchers.FractionMatcher> parseFractionMatcher(FractionalPercent proto) {
        int numerator = proto.getNumerator();
        int denominator = 0;
        switch (proto.getDenominator()) {
            case HUNDRED: {
                denominator = 100;
                break;
            }
            case TEN_THOUSAND: {
                denominator = 10000;
                break;
            }
            case MILLION: {
                denominator = 1000000;
                break;
            }
            default: {
                return StructOrError.fromError("Unrecognized fractional percent denominator: " + proto.getDenominator());
            }
        }
        return StructOrError.fromStruct(Matchers.FractionMatcher.create(numerator, denominator));
    }

    @VisibleForTesting
    static StructOrError<Matchers.HeaderMatcher> parseHeaderMatcher(HeaderMatcher proto) {
        try {
            Matchers.HeaderMatcher headerMatcher = MatcherParser.parseHeaderMatcher(proto);
            return StructOrError.fromStruct(headerMatcher);
        }
        catch (IllegalArgumentException e) {
            return StructOrError.fromError(e.getMessage());
        }
    }

    @Nullable
    @VisibleForTesting
    static StructOrError<VirtualHost.Route.RouteAction> parseRouteAction(RouteAction proto, FilterRegistry filterRegistry, Map<String, ClusterSpecifierPlugin.PluginConfig> pluginConfigMap, Set<String> optionalPlugins, XdsResourceType.Args args) {
        StructOrError<VirtualHost.Route.RouteAction.RetryPolicy> retryPolicyOrError;
        Long timeoutNano = null;
        if (proto.hasMaxStreamDuration()) {
            RouteAction.MaxStreamDuration maxStreamDuration = proto.getMaxStreamDuration();
            if (maxStreamDuration.hasGrpcTimeoutHeaderMax()) {
                timeoutNano = Durations.toNanos(maxStreamDuration.getGrpcTimeoutHeaderMax());
            } else if (maxStreamDuration.hasMaxStreamDuration()) {
                timeoutNano = Durations.toNanos(maxStreamDuration.getMaxStreamDuration());
            }
        }
        VirtualHost.Route.RouteAction.RetryPolicy retryPolicy = null;
        if (proto.hasRetryPolicy() && (retryPolicyOrError = XdsRouteConfigureResource.parseRetryPolicy(proto.getRetryPolicy())) != null) {
            if (retryPolicyOrError.getErrorDetail() != null) {
                return StructOrError.fromError(retryPolicyOrError.getErrorDetail());
            }
            retryPolicy = retryPolicyOrError.getStruct();
        }
        ArrayList<VirtualHost.Route.RouteAction.HashPolicy> hashPolicies = new ArrayList<VirtualHost.Route.RouteAction.HashPolicy>();
        for (RouteAction.HashPolicy config : proto.getHashPolicyList()) {
            VirtualHost.Route.RouteAction.HashPolicy policy = null;
            boolean terminal = config.getTerminal();
            switch (config.getPolicySpecifierCase()) {
                case HEADER: {
                    RouteAction.HashPolicy.Header headerCfg = config.getHeader();
                    Pattern regEx = null;
                    String regExSubstitute = null;
                    if (headerCfg.hasRegexRewrite() && headerCfg.getRegexRewrite().hasPattern()) {
                        regEx = Pattern.compile(headerCfg.getRegexRewrite().getPattern().getRegex());
                        regExSubstitute = headerCfg.getRegexRewrite().getSubstitution();
                    }
                    policy = VirtualHost.Route.RouteAction.HashPolicy.forHeader(terminal, headerCfg.getHeaderName(), regEx, regExSubstitute);
                    break;
                }
                case FILTER_STATE: {
                    if (!config.getFilterState().getKey().equals(HASH_POLICY_FILTER_STATE_KEY)) break;
                    policy = VirtualHost.Route.RouteAction.HashPolicy.forChannelId(terminal);
                    break;
                }
            }
            if (policy == null) continue;
            hashPolicies.add(policy);
        }
        switch (proto.getClusterSpecifierCase()) {
            case CLUSTER: {
                return StructOrError.fromStruct(VirtualHost.Route.RouteAction.forCluster(proto.getCluster(), hashPolicies, timeoutNano, retryPolicy, GrpcUtil.getFlag(GRPC_EXPERIMENTAL_XDS_AUTHORITY_REWRITE, false) && args.getServerInfo().isTrustedXdsServer() && proto.getAutoHostRewrite().getValue()));
            }
            case CLUSTER_HEADER: {
                return null;
            }
            case WEIGHTED_CLUSTERS: {
                List<WeightedCluster.ClusterWeight> clusterWeights = proto.getWeightedClusters().getClustersList();
                if (clusterWeights.isEmpty()) {
                    return StructOrError.fromError("No cluster found in weighted cluster list");
                }
                ArrayList<VirtualHost.Route.RouteAction.ClusterWeight> weightedClusters = new ArrayList<VirtualHost.Route.RouteAction.ClusterWeight>();
                long clusterWeightSum = 0L;
                for (WeightedCluster.ClusterWeight clusterWeight : clusterWeights) {
                    StructOrError<VirtualHost.Route.RouteAction.ClusterWeight> clusterWeightOrError = XdsRouteConfigureResource.parseClusterWeight(clusterWeight, filterRegistry);
                    if (clusterWeightOrError.getErrorDetail() != null) {
                        return StructOrError.fromError("RouteAction contains invalid ClusterWeight: " + clusterWeightOrError.getErrorDetail());
                    }
                    VirtualHost.Route.RouteAction.ClusterWeight parsedWeight = clusterWeightOrError.getStruct();
                    clusterWeightSum += parsedWeight.weight();
                    weightedClusters.add(parsedWeight);
                }
                if (clusterWeightSum <= 0L) {
                    return StructOrError.fromError("Sum of cluster weights should be above 0.");
                }
                if (clusterWeightSum > UnsignedInteger.MAX_VALUE.longValue()) {
                    return StructOrError.fromError(String.format("Sum of cluster weights should be less than the maximum unsigned integer (%d), but was %d. ", UnsignedInteger.MAX_VALUE.longValue(), clusterWeightSum));
                }
                return StructOrError.fromStruct(VirtualHost.Route.RouteAction.forWeightedClusters(weightedClusters, hashPolicies, timeoutNano, retryPolicy, GrpcUtil.getFlag(GRPC_EXPERIMENTAL_XDS_AUTHORITY_REWRITE, false) && args.getServerInfo().isTrustedXdsServer() && proto.getAutoHostRewrite().getValue()));
            }
            case CLUSTER_SPECIFIER_PLUGIN: {
                if (enableRouteLookup) {
                    String pluginName = proto.getClusterSpecifierPlugin();
                    ClusterSpecifierPlugin.PluginConfig pluginConfig = pluginConfigMap.get(pluginName);
                    if (pluginConfig == null) {
                        if (optionalPlugins.contains(pluginName)) {
                            return null;
                        }
                        return StructOrError.fromError("ClusterSpecifierPlugin for [" + pluginName + "] not found");
                    }
                    ClusterSpecifierPlugin.NamedPluginConfig namedPluginConfig = ClusterSpecifierPlugin.NamedPluginConfig.create(pluginName, pluginConfig);
                    return StructOrError.fromStruct(VirtualHost.Route.RouteAction.forClusterSpecifierPlugin(namedPluginConfig, hashPolicies, timeoutNano, retryPolicy, GrpcUtil.getFlag(GRPC_EXPERIMENTAL_XDS_AUTHORITY_REWRITE, false) && args.getServerInfo().isTrustedXdsServer() && proto.getAutoHostRewrite().getValue()));
                }
                return null;
            }
        }
        return null;
    }

    @Nullable
    private static StructOrError<VirtualHost.Route.RouteAction.RetryPolicy> parseRetryPolicy(RetryPolicy retryPolicyProto) {
        int maxAttempts = 2;
        if (retryPolicyProto.hasNumRetries()) {
            maxAttempts = retryPolicyProto.getNumRetries().getValue() + 1;
        }
        Duration initialBackoff = Durations.fromMillis(25L);
        Duration maxBackoff = Durations.fromMillis(250L);
        if (retryPolicyProto.hasRetryBackOff()) {
            RetryPolicy.RetryBackOff retryBackOff = retryPolicyProto.getRetryBackOff();
            if (!retryBackOff.hasBaseInterval()) {
                return StructOrError.fromError("No base_interval specified in retry_backoff");
            }
            Duration originalInitialBackoff = initialBackoff = retryBackOff.getBaseInterval();
            if (Durations.compare(initialBackoff, Durations.ZERO) <= 0) {
                return StructOrError.fromError("base_interval in retry_backoff must be positive");
            }
            if (Durations.compare(initialBackoff, Durations.fromMillis(1L)) < 0) {
                initialBackoff = Durations.fromMillis(1L);
            }
            if (retryBackOff.hasMaxInterval()) {
                maxBackoff = retryPolicyProto.getRetryBackOff().getMaxInterval();
                if (Durations.compare(maxBackoff, originalInitialBackoff) < 0) {
                    return StructOrError.fromError("max_interval in retry_backoff cannot be less than base_interval");
                }
                if (Durations.compare(maxBackoff, Durations.fromMillis(1L)) < 0) {
                    maxBackoff = Durations.fromMillis(1L);
                }
            } else {
                maxBackoff = Durations.fromNanos(Durations.toNanos(initialBackoff) * 10L);
            }
        }
        Iterable<String> retryOns = Splitter.on(',').omitEmptyStrings().trimResults().split(retryPolicyProto.getRetryOn());
        ImmutableList.Builder retryableStatusCodesBuilder = ImmutableList.builder();
        for (String retryOn : retryOns) {
            Status.Code code;
            try {
                code = Status.Code.valueOf(retryOn.toUpperCase(Locale.US).replace('-', '_'));
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            if (!SUPPORTED_RETRYABLE_CODES.contains((Object)code)) continue;
            retryableStatusCodesBuilder.add((Object)code);
        }
        ImmutableCollection retryableStatusCodes = retryableStatusCodesBuilder.build();
        return StructOrError.fromStruct(VirtualHost.Route.RouteAction.RetryPolicy.create(maxAttempts, (List<Status.Code>)((Object)retryableStatusCodes), initialBackoff, maxBackoff, null));
    }

    @VisibleForTesting
    static StructOrError<VirtualHost.Route.RouteAction.ClusterWeight> parseClusterWeight(WeightedCluster.ClusterWeight proto, FilterRegistry filterRegistry) {
        StructOrError<Map<String, Filter.FilterConfig>> overrideConfigs = XdsRouteConfigureResource.parseOverrideFilterConfigs(proto.getTypedPerFilterConfigMap(), filterRegistry);
        if (overrideConfigs.getErrorDetail() != null) {
            return StructOrError.fromError("ClusterWeight [" + proto.getName() + "] contains invalid HttpFilter config: " + overrideConfigs.getErrorDetail());
        }
        return StructOrError.fromStruct(VirtualHost.Route.RouteAction.ClusterWeight.create(proto.getName(), Integer.toUnsignedLong(proto.getWeight().getValue()), overrideConfigs.getStruct()));
    }

    @Nullable
    private static ClusterSpecifierPlugin.PluginConfig parseClusterSpecifierPlugin(net.snowflake.client.jdbc.internal.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.ClusterSpecifierPlugin pluginProto) throws XdsResourceType.ResourceInvalidException {
        return XdsRouteConfigureResource.parseClusterSpecifierPlugin(pluginProto, ClusterSpecifierPluginRegistry.getDefaultRegistry());
    }

    @Nullable
    @VisibleForTesting
    static ClusterSpecifierPlugin.PluginConfig parseClusterSpecifierPlugin(net.snowflake.client.jdbc.internal.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.ClusterSpecifierPlugin pluginProto, ClusterSpecifierPluginRegistry registry) throws XdsResourceType.ResourceInvalidException {
        ClusterSpecifierPlugin plugin;
        TypedExtensionConfig extension = pluginProto.getExtension();
        String pluginName = extension.getName();
        Any anyConfig = extension.getTypedConfig();
        String typeUrl = anyConfig.getTypeUrl();
        GeneratedMessage rawConfig = anyConfig;
        if (typeUrl.equals("type.googleapis.com/udpa.type.v1.TypedStruct") || typeUrl.equals("type.googleapis.com/xds.type.v3.TypedStruct")) {
            try {
                TypedStruct typedStruct = XdsRouteConfigureResource.unpackCompatibleType(anyConfig, TypedStruct.class, "type.googleapis.com/udpa.type.v1.TypedStruct", "type.googleapis.com/xds.type.v3.TypedStruct");
                typeUrl = typedStruct.getTypeUrl();
                rawConfig = typedStruct.getValue();
            }
            catch (InvalidProtocolBufferException e) {
                throw new XdsResourceType.ResourceInvalidException("ClusterSpecifierPlugin [" + pluginName + "] contains invalid proto", e);
            }
        }
        if ((plugin = registry.get(typeUrl)) == null) {
            if (!pluginProto.getIsOptional()) {
                throw new XdsResourceType.ResourceInvalidException("Unsupported ClusterSpecifierPlugin type: " + typeUrl);
            }
            return null;
        }
        ConfigOrError<? extends ClusterSpecifierPlugin.PluginConfig> pluginConfigOrError = plugin.parsePlugin(rawConfig);
        if (pluginConfigOrError.errorDetail != null) {
            throw new XdsResourceType.ResourceInvalidException(pluginConfigOrError.errorDetail);
        }
        return (ClusterSpecifierPlugin.PluginConfig)pluginConfigOrError.config;
    }

    static final class RdsUpdate
    implements XdsClient.ResourceUpdate {
        final List<VirtualHost> virtualHosts;

        RdsUpdate(List<VirtualHost> virtualHosts) {
            this.virtualHosts = Collections.unmodifiableList(new ArrayList(Preconditions.checkNotNull(virtualHosts, "virtualHosts")));
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("virtualHosts", this.virtualHosts).toString();
        }

        public int hashCode() {
            return Objects.hash(this.virtualHosts);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RdsUpdate that = (RdsUpdate)o;
            return Objects.equals(this.virtualHosts, that.virtualHosts);
        }
    }
}

