/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.internal;

import java.io.IOException;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.snowflake.client.jdbc.internal.google.common.annotations.VisibleForTesting;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.google.common.base.Supplier;
import net.snowflake.client.jdbc.internal.grpc.HttpConnectProxiedSocketAddress;
import net.snowflake.client.jdbc.internal.grpc.ProxiedSocketAddress;
import net.snowflake.client.jdbc.internal.grpc.ProxyDetector;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;

class ProxyDetectorImpl
implements ProxyDetector {
    private static final Logger log = Logger.getLogger(ProxyDetectorImpl.class.getName());
    private static final AuthenticationProvider DEFAULT_AUTHENTICATOR = new AuthenticationProvider(){

        @Override
        public PasswordAuthentication requestPasswordAuthentication(String host, InetAddress addr, int port, String protocol, String prompt, String scheme) {
            URL url = null;
            try {
                url = new URL(protocol, host, port, "");
            }
            catch (MalformedURLException e) {
                log.log(Level.WARNING, "failed to create URL for Authenticator: {0} {1}", new Object[]{protocol, host});
            }
            return Authenticator.requestPasswordAuthentication(host, addr, port, protocol, prompt, scheme, url, Authenticator.RequestorType.PROXY);
        }
    };
    private static final Supplier<ProxySelector> DEFAULT_PROXY_SELECTOR = new Supplier<ProxySelector>(){

        @Override
        public ProxySelector get() {
            return ProxySelector.getDefault();
        }
    };
    private final Supplier<ProxySelector> proxySelector;
    private final AuthenticationProvider authenticationProvider;
    static final String PROXY_SCHEME = "https";

    public ProxyDetectorImpl() {
        this(DEFAULT_PROXY_SELECTOR, DEFAULT_AUTHENTICATOR);
    }

    @VisibleForTesting
    ProxyDetectorImpl(Supplier<ProxySelector> proxySelector, AuthenticationProvider authenticationProvider) {
        this.proxySelector = Preconditions.checkNotNull(proxySelector);
        this.authenticationProvider = Preconditions.checkNotNull(authenticationProvider);
    }

    @Override
    @Nullable
    public ProxiedSocketAddress proxyFor(SocketAddress targetServerAddress) throws IOException {
        if (!(targetServerAddress instanceof InetSocketAddress)) {
            return null;
        }
        return this.detectProxy((InetSocketAddress)targetServerAddress);
    }

    private ProxiedSocketAddress detectProxy(InetSocketAddress targetAddr) throws IOException {
        InetSocketAddress resolvedProxyAddr;
        Proxy proxy;
        URI uri;
        String host = targetAddr.getHostString();
        try {
            uri = new URI(PROXY_SCHEME, null, host, targetAddr.getPort(), null, null, null);
        }
        catch (URISyntaxException e) {
            log.log(Level.WARNING, "Failed to construct URI for proxy lookup, proceeding without proxy", e);
            return null;
        }
        ProxySelector proxySelector = this.proxySelector.get();
        if (proxySelector == null) {
            log.log(Level.FINE, "proxy selector is null, so continuing without proxy lookup");
            return null;
        }
        List<Proxy> proxies = proxySelector.select(uri);
        if (proxies.size() > 1) {
            log.warning("More than 1 proxy detected, gRPC will select the first one");
        }
        if ((proxy = proxies.get(0)).type() == Proxy.Type.DIRECT) {
            return null;
        }
        InetSocketAddress proxyAddr = (InetSocketAddress)proxy.address();
        String promptString = "";
        PasswordAuthentication auth = this.authenticationProvider.requestPasswordAuthentication(proxyAddr.getHostString(), proxyAddr.getAddress(), proxyAddr.getPort(), PROXY_SCHEME, promptString, null);
        if (proxyAddr.isUnresolved()) {
            InetAddress resolvedAddress = InetAddress.getByName(proxyAddr.getHostName());
            resolvedProxyAddr = new InetSocketAddress(resolvedAddress, proxyAddr.getPort());
        } else {
            resolvedProxyAddr = proxyAddr;
        }
        HttpConnectProxiedSocketAddress.Builder builder = HttpConnectProxiedSocketAddress.newBuilder().setTargetAddress(targetAddr).setProxyAddress(resolvedProxyAddr);
        if (auth == null) {
            return builder.build();
        }
        return builder.setUsername(auth.getUserName()).setPassword(auth.getPassword() == null ? null : new String(auth.getPassword())).build();
    }

    static interface AuthenticationProvider {
        public PasswordAuthentication requestPasswordAuthentication(String var1, InetAddress var2, int var3, String var4, String var5, String var6);
    }
}

